/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.ptp.debug.core.model.IPStackFrame;

public class PWatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(final String expression, IDebugElement context, final IWatchExpressionListener listener) {
        if (!(context instanceof IPStackFrame)) {
            listener.watchEvaluationFinished(null);
            return;
        }
        final IPStackFrame frame = (IPStackFrame)context;
        Runnable runnable = new Runnable(){

            public void run() {
                IValue value = null;
                DebugException de = null;
                try {
                    value = frame.evaluateExpression(expression);
                }
                catch (DebugException e) {
                    de = e;
                }
                IWatchExpressionResult result = PWatchExpressionDelegate.this.evaluationComplete(expression, value, de);
                listener.watchEvaluationFinished(result);
            }
        };
        DebugPlugin.getDefault().asyncExec(runnable);
    }

    protected IWatchExpressionResult evaluationComplete(final String expression, final IValue value, final DebugException de) {
        return new IWatchExpressionResult(){

            public IValue getValue() {
                return value;
            }

            public boolean hasErrors() {
                return de != null;
            }

            public String getExpressionText() {
                return expression;
            }

            public DebugException getException() {
                return de;
            }

            public String[] getErrorMessages() {
                String[] stringArray;
                if (de != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = de.getMessage();
                } else {
                    stringArray = new String[]{};
                }
                return stringArray;
            }
        };
    }
}

