/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.m2e.core.ui.wizard;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenImportWizardPage;
import org.eclipse.reddeer.eclipse.selectionwizard.ImportMenuWizard;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.Matcher;

public class MavenImportWizard
extends ImportMenuWizard {
    public static final String TITLE = "Import Maven Projects";
    private MavenImportWizardPage page = new MavenImportWizardPage((ReferencedComposite)this);

    public MavenImportWizard() {
        super(TITLE, "Maven", "Existing Maven Projects");
    }

    public MavenImportWizardPage getWizardPage() {
        return this.page;
    }

    public void finish() {
        this.finish(TimePeriod.VERY_LONG);
    }

    public void finish(TimePeriod timeout) {
        this.finish(timeout, true);
    }

    public void finish(TimePeriod timeout, boolean waitForResolve) {
        DefaultShell shell = new DefaultShell(TITLE);
        new PushButton("Finish").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)shell), TimePeriod.DEFAULT);
        new WaitUntil((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT, false);
        new WaitWhile((WaitCondition)new JobIsRunning(), timeout);
        if (waitForResolve) {
            DefaultShell dialog;
            try {
                dialog = new ResolveDialog();
                dialog.resolveAllLater();
                try {
                    dialog.finish();
                }
                catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
                    dialog.cancel();
                }
            }
            catch (Exception exception) {}
            try {
                dialog = new IncompleteDialog();
                dialog.ok();
            }
            catch (CoreLayerException | SWTLayerException throwable) {}
            new WaitUntil((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT, false);
            new WaitWhile((WaitCondition)new JobIsRunning(), timeout);
        }
    }

    public static void importProject(String path) {
        MavenImportWizard.importProject(path, TimePeriod.VERY_LONG);
    }

    public static void importProject(String path, TimePeriod timeout) {
        MavenImportWizard wizard = new MavenImportWizard();
        wizard.open();
        wizard.getWizardPage().setRootDirectory(path);
        wizard.getWizardPage().refresh();
        wizard.getWizardPage().waitUntilProjectIsLoaded(TimePeriod.VERY_LONG);
        wizard.finish(timeout);
    }

    private class IncompleteDialog
    extends DefaultShell {
        public IncompleteDialog() {
            super("Incomplete Maven Goal Execution");
        }

        public void ok() {
            new PushButton("OK").click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)this));
        }
    }

    private class ResolveDialog
    extends DefaultShell {
        public static final String TITLE_MARS = "Import Maven Projects";
        public static final String TITLE_NEON = "Discover m2e connectors";

        public ResolveDialog() {
            super(new Matcher[]{new WithTextMatcher((Matcher)new RegexMatcher("(Import Maven Projects)|(Discover m2e connectors)"))});
        }

        public void resolveAllLater() {
            new PushButton("Resolve All Later").click();
        }

        public void finish() {
            new PushButton("Finish").click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)this));
        }

        public void cancel() {
            new PushButton("Cancel").click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)this));
        }
    }
}

