/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.expandbar;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ExpandBarHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.ExpandBar;
import org.eclipse.reddeer.swt.api.ExpandItem;
import org.eclipse.reddeer.swt.impl.expandbar.DefaultExpandItem;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.widgets.Control;
import org.hamcrest.Matcher;

public abstract class AbstractExpandBar
extends AbstractControl<org.eclipse.swt.widgets.ExpandBar>
implements ExpandBar {
    private static final Logger logger = Logger.getLogger(AbstractExpandBar.class);

    protected AbstractExpandBar(org.eclipse.swt.widgets.ExpandBar swtExpandBar) {
        super(swtExpandBar);
    }

    protected AbstractExpandBar(ReferencedComposite referencedComposite, int index, Matcher<?> ... matchers) {
        super(org.eclipse.swt.widgets.ExpandBar.class, referencedComposite, index, matchers);
    }

    @Override
    public int getItemsCount() {
        return this.getItems().size();
    }

    @Override
    public List<ExpandItem> getItems() {
        List items = ExpandBarHandler.getInstance().getItems((org.eclipse.swt.widgets.ExpandBar)this.swtWidget);
        List<ExpandItem> rdItems = items.stream().map(t -> new DefaultExpandItem((org.eclipse.swt.widgets.ExpandItem)t)).collect(Collectors.toList());
        return rdItems;
    }

    @Override
    public void setFocus() {
        ControlHandler.getInstance().setFocus((Control)this.getSWTWidget());
    }

    @Override
    public void expandAll() {
        logger.info("Expand all expand bar items");
        for (ExpandItem expandBarItem : this.getItems()) {
            expandBarItem.expand();
        }
    }

    @Override
    public void collapseAll() {
        logger.info("Collapse all expand bar items");
        for (ExpandItem expandBarItem : this.getItems()) {
            expandBarItem.collapse();
        }
    }
}

