/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.draw2d.geometry.PointList;
import org.eclipse.wb.draw2d.geometry.Rectangle;

public class Graphics {
    public final GC gc;
    public int m_translateX;
    public int m_translateY;
    private final State m_appliedState = new State();
    private final State m_currentState = new State();
    private final List<State> m_stack = Lists.newArrayList();
    private int m_stackPointer = 0;
    private final Rectangle m_clipping;

    public Graphics(GC gc) {
        this.gc = gc;
        this.gc.setLineWidth(1);
        this.m_clipping = new Rectangle(gc.getClipping());
        this.m_currentState.fill(gc, this.m_clipping);
        this.m_appliedState.fill(gc, this.m_clipping);
    }

    public final void drawArc(Rectangle r, int offset, int length) {
        this.drawArc(r.x, r.y, r.width, r.height, offset, length);
    }

    public void drawArc(int x, int y, int width, int height, int offset, int length) {
        this.checkPaint();
        this.gc.drawArc(x + this.m_translateX, y + this.m_translateY, width, height, offset, length);
    }

    public void fillArc(int x, int y, int width, int height, int offset, int length) {
        this.checkFill();
        this.gc.fillArc(x + this.m_translateX, y + this.m_translateY, width, height, offset, length);
    }

    public final void fillArc(Rectangle r, int offset, int length) {
        this.fillArc(r.x, r.y, r.width, r.height, offset, length);
    }

    public final void fillGradient(Rectangle r, boolean vertical) {
        this.fillGradient(r.x, r.y, r.width, r.height, vertical);
    }

    public void fillGradient(int x, int y, int width, int height, boolean vertical) {
        this.checkFill();
        this.checkPaint();
        this.gc.fillGradientRectangle(x + this.m_translateX, y + this.m_translateY, width, height, vertical);
    }

    public final void drawFocus(Rectangle r) {
        this.drawFocus(r.x, r.y, r.width, r.height);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.checkPaint();
        this.checkFill();
        this.gc.drawFocus(x + this.m_translateX, y + this.m_translateY, w + 1, h + 1);
    }

    public final void drawImage(Image srcImage, Point p) {
        this.drawImage(srcImage, p.x, p.y);
    }

    public void drawImage(Image srcImage, int x, int y) {
        this.checkGC();
        this.gc.drawImage(srcImage, x + this.m_translateX, y + this.m_translateY);
    }

    public final void drawImage(Image srcImage, Rectangle src, Rectangle dest) {
        this.drawImage(srcImage, src.x, src.y, src.width, src.height, dest.x, dest.y, dest.width, dest.height);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        this.checkGC();
        this.gc.drawImage(srcImage, x1, y1, w1, h1, x2 + this.m_translateX, y2 + this.m_translateY, w2, h2);
    }

    public final void drawLine(Point p1, Point p2) {
        this.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkPaint();
        this.gc.drawLine(x1 + this.m_translateX, y1 + this.m_translateY, x2 + this.m_translateX, y2 + this.m_translateY);
    }

    public void drawPoint(int x, int y) {
        this.checkPaint();
        this.gc.drawPoint(x + this.m_translateX, y + this.m_translateY);
    }

    public final void drawOval(Rectangle r) {
        this.drawOval(r.x, r.y, r.width, r.height);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.checkPaint();
        this.gc.drawOval(x + this.m_translateX, y + this.m_translateY, width, height);
    }

    public final void fillOval(Rectangle r) {
        this.fillOval(r.x, r.y, r.width, r.height);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.checkFill();
        this.gc.fillOval(x + this.m_translateX, y + this.m_translateY, w, h);
    }

    public void drawPolygon(PointList points) {
        this.checkPaint();
        points.performTranslate(this.m_translateX, this.m_translateY);
        this.gc.drawPolygon(points.toIntArray());
        points.performTranslate(-this.m_translateX, -this.m_translateY);
    }

    public void fillPolygon(PointList points) {
        this.checkFill();
        points.performTranslate(this.m_translateX, this.m_translateY);
        this.gc.fillPolygon(points.toIntArray());
        points.performTranslate(-this.m_translateX, -this.m_translateY);
    }

    public void drawPolyline(PointList points) {
        this.checkPaint();
        points.performTranslate(this.m_translateX, this.m_translateY);
        int[] array = points.toIntArray();
        this.gc.drawPolyline(array);
        if (this.getLineWidth() == 1 && array.length >= 2) {
            int x = array[array.length - 2];
            int y = array[array.length - 1];
            this.gc.drawLine(x, y, x, y);
        }
        points.performTranslate(-this.m_translateX, -this.m_translateY);
    }

    public final void drawRectangle(Rectangle r) {
        this.drawRectangle(r.x, r.y, r.width, r.height);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.checkPaint();
        this.gc.drawRectangle(x + this.m_translateX, y + this.m_translateY, width, height);
    }

    public final void fillRectangle(Rectangle r) {
        this.fillRectangle(r.x, r.y, r.width, r.height);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.checkFill();
        this.gc.fillRectangle(x + this.m_translateX, y + this.m_translateY, width, height);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkPaint();
        this.gc.drawRoundRectangle(r.x + this.m_translateX, r.y + this.m_translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkFill();
        this.gc.fillRoundRectangle(r.x + this.m_translateX, r.y + this.m_translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void drawText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.m_translateX, y + this.m_translateY, true);
    }

    public void drawString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.m_translateX, y + this.m_translateY, true);
    }

    public final void drawString(String s, Point p) {
        this.drawString(s, p.x, p.y);
    }

    public final void drawText(String s, Point p) {
        this.drawText(s, p.x, p.y);
    }

    public final void fillString(String s, Point p) {
        this.fillString(s, p.x, p.y);
    }

    public void fillString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.m_translateX, y + this.m_translateY, false);
    }

    public final void fillText(String s, Point p) {
        this.fillText(s, p.x, p.y);
    }

    public void fillText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.m_translateX, y + this.m_translateY, false);
    }

    public Dimension getTextExtent(String s) {
        this.checkText();
        org.eclipse.swt.graphics.Point extent = this.gc.textExtent(s);
        return new Dimension(extent.x, extent.y);
    }

    public Color getBackgroundColor() {
        return this.m_currentState.background;
    }

    public Font getFont() {
        return this.m_currentState.font;
    }

    public FontMetrics getFontMetrics() {
        this.checkText();
        return this.gc.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.m_currentState.foreground;
    }

    public int getLineStyle() {
        return this.m_currentState.lineStyle;
    }

    public int getLineWidth() {
        return this.m_currentState.lineWidth;
    }

    public boolean getXORMode() {
        return this.m_currentState.xor;
    }

    public void setBackgroundColor(Color color) {
        if (!this.m_currentState.background.equals((Object)color)) {
            this.m_currentState.background = color;
        }
    }

    public Rectangle getClip() {
        return new Rectangle(this.m_clipping);
    }

    public void clipRect(Rectangle rectangle) {
        this.m_clipping.intersect(rectangle);
        this.m_currentState.clippingX = this.m_clipping.x + this.m_translateX;
        this.m_currentState.clippingY = this.m_clipping.y + this.m_translateY;
        this.m_currentState.clippingWidth = this.m_clipping.width;
        this.m_currentState.clippingHeight = this.m_clipping.height;
    }

    public void setFont(Font font) {
        if (this.m_currentState.font != font) {
            this.m_currentState.font = font;
        }
    }

    public void setForegroundColor(Color color) {
        if (!this.m_currentState.foreground.equals((Object)color)) {
            this.m_currentState.foreground = color;
        }
    }

    public void setLineStyle(int style) {
        if (this.m_currentState.lineStyle != style) {
            this.m_currentState.lineStyle = style;
        }
    }

    public void setLineWidth(int width) {
        if (this.m_currentState.lineWidth != width) {
            this.m_currentState.lineWidth = width;
        }
    }

    public void setXORMode(boolean b) {
        if (this.m_currentState.xor != b) {
            this.m_currentState.xor = b;
        }
    }

    public final void translate(Point p) {
        this.translate(p.x, p.y);
    }

    public void translate(int dx, int dy) {
        this.setTranslation(this.m_translateX + dx, this.m_translateY + dy);
        this.m_clipping.x -= dx;
        this.m_clipping.y -= dy;
    }

    protected void setTranslation(int x, int y) {
        this.m_translateX = this.m_currentState.translateX = x;
        this.m_translateY = this.m_currentState.translateY = y;
    }

    protected final void checkFill() {
        if (!this.m_appliedState.background.equals((Object)this.m_currentState.background)) {
            this.m_appliedState.background = this.m_currentState.background;
            this.gc.setBackground(this.m_appliedState.background);
        }
        this.checkGC();
    }

    protected final void checkGC() {
        if (this.m_appliedState.xor != this.m_currentState.xor) {
            this.m_appliedState.xor = this.m_currentState.xor;
            this.gc.setXORMode(this.m_appliedState.xor);
        }
        if (this.m_appliedState.clippingX != this.m_currentState.clippingX || this.m_appliedState.clippingY != this.m_currentState.clippingY || this.m_appliedState.clippingWidth != this.m_currentState.clippingWidth || this.m_appliedState.clippingHeight != this.m_currentState.clippingHeight) {
            this.m_appliedState.clippingX = this.m_currentState.clippingX;
            this.m_appliedState.clippingY = this.m_currentState.clippingY;
            this.m_appliedState.clippingWidth = this.m_currentState.clippingWidth;
            this.m_appliedState.clippingHeight = this.m_currentState.clippingHeight;
            this.gc.setClipping(this.m_appliedState.clippingX, this.m_appliedState.clippingY, this.m_appliedState.clippingWidth, this.m_appliedState.clippingHeight);
        }
    }

    protected final void checkPaint() {
        this.checkGC();
        if (!this.m_appliedState.foreground.equals((Object)this.m_currentState.foreground)) {
            this.m_appliedState.foreground = this.m_currentState.foreground;
            this.gc.setForeground(this.m_appliedState.foreground);
        }
        if (this.m_appliedState.lineStyle != this.m_currentState.lineStyle) {
            this.m_appliedState.lineStyle = this.m_currentState.lineStyle;
            this.gc.setLineStyle(this.m_appliedState.lineStyle);
        }
        if (this.m_appliedState.lineWidth != this.m_currentState.lineWidth) {
            this.m_appliedState.lineWidth = this.m_currentState.lineWidth;
            this.gc.setLineWidth(this.m_appliedState.lineWidth);
        }
        if (!this.m_appliedState.background.equals((Object)this.m_currentState.background)) {
            this.m_appliedState.background = this.m_currentState.background;
            this.gc.setBackground(this.m_appliedState.background);
        }
    }

    protected final void checkText() {
        this.checkPaint();
        this.checkFill();
        if (!this.m_appliedState.font.equals((Object)this.m_currentState.font)) {
            this.m_appliedState.font = this.m_currentState.font;
            this.gc.setFont(this.m_appliedState.font);
        }
    }

    public void pushState() {
        if (this.m_stackPointer < this.m_stack.size()) {
            State state = this.m_stack.get(this.m_stackPointer);
            state.fill(this.m_currentState);
        } else {
            this.m_stack.add(this.m_currentState.copy());
        }
        ++this.m_stackPointer;
    }

    public void popState() {
        this.restoreState(--this.m_stackPointer);
    }

    public void restoreState() {
        this.restoreState(this.m_stackPointer - 1);
    }

    private void restoreState(int index) {
        State state = this.m_stack.get(index);
        state.fillTo(this);
        this.m_translateX = this.m_currentState.translateX = state.translateX;
        this.m_translateY = this.m_currentState.translateY = state.translateY;
        this.m_currentState.clippingX = state.clippingX;
        this.m_currentState.clippingY = state.clippingY;
        this.m_currentState.clippingWidth = state.clippingWidth;
        this.m_currentState.clippingHeight = state.clippingHeight;
        this.m_clipping.x = state.clippingX - this.m_translateX;
        this.m_clipping.y = state.clippingY - this.m_translateY;
        this.m_clipping.width = state.clippingWidth;
        this.m_clipping.height = state.clippingHeight;
    }

    private static class State {
        public Color background;
        public Color foreground;
        public int clippingX;
        public int clippingY;
        public int clippingWidth;
        public int clippingHeight;
        public Font font;
        public int lineWidth;
        public int lineStyle;
        public int translateX;
        public int translateY;
        public boolean xor;

        private State() {
        }

        public State copy() {
            return new State().fill(this);
        }

        public State fill(State state) {
            this.background = state.background;
            this.foreground = state.foreground;
            this.clippingX = state.clippingX;
            this.clippingY = state.clippingY;
            this.clippingWidth = state.clippingWidth;
            this.clippingHeight = state.clippingHeight;
            this.lineStyle = state.lineStyle;
            this.lineWidth = state.lineWidth;
            this.translateX = state.translateX;
            this.translateY = state.translateY;
            this.font = state.font;
            this.xor = state.xor;
            return this;
        }

        public void fill(GC gc, Rectangle clipping) {
            this.background = gc.getBackground();
            this.foreground = gc.getForeground();
            this.clippingX = clipping.x;
            this.clippingY = clipping.y;
            this.clippingWidth = clipping.width;
            this.clippingHeight = clipping.height;
            this.font = gc.getFont();
            this.lineWidth = gc.getLineWidth();
            this.lineStyle = gc.getLineStyle();
            this.xor = gc.getXORMode();
        }

        public void fillTo(Graphics graphics) {
            graphics.setBackgroundColor(this.background);
            graphics.setForegroundColor(this.foreground);
            graphics.setLineStyle(this.lineStyle);
            graphics.setLineWidth(this.lineWidth);
            graphics.setFont(this.font);
            graphics.setXORMode(this.xor);
        }
    }
}

