/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashCode;
import com.google.common.io.Files;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.xtext.builder.standalone.incremental.BinaryFileHashing;
import org.eclipse.xtext.builder.standalone.incremental.ClasspathEntryHash;
import org.eclipse.xtext.builder.standalone.incremental.CoarseGrainedEntryHash;
import org.eclipse.xtext.builder.standalone.incremental.FineGrainedEntryHash;

@Singleton
public class ClasspathInfos {
    private ConcurrentHashMap<IPath, ClasspathEntryHash> classpathEntries = new ConcurrentHashMap();

    public ClasspathEntryHash hashClassesOrJar(IPath classpathEntry) {
        return this.classpathEntries.computeIfAbsent(classpathEntry, any -> {
            File classpathEntryAsFile = classpathEntry.toFile();
            if ("jar".equalsIgnoreCase(classpathEntry.getFileExtension()) && classpathEntryAsFile.isFile()) {
                String maybeHash;
                List<String> segments = Arrays.asList(classpathEntry.segments());
                if (segments.contains(".gradle") && (maybeHash = segments.get(segments.size() - 2)).length() >= 36) {
                    HashCode hash = BinaryFileHashing.hashFunction().hashString((CharSequence)maybeHash, StandardCharsets.ISO_8859_1);
                    BinaryFileHashing.LOG.trace((Object)("Hashed file " + classpathEntryAsFile.getName() + " to " + hash));
                    return new CoarseGrainedEntryHash(hash);
                }
                File mavenSha1 = classpathEntry.addFileExtension("sha1").toFile();
                if (mavenSha1.isFile()) {
                    return new CoarseGrainedEntryHash(BinaryFileHashing.processFile(mavenSha1));
                }
                return new CoarseGrainedEntryHash(BinaryFileHashing.processFile(classpathEntryAsFile));
            }
            HashMap<IPath, HashCode> classHashes = new HashMap<IPath, HashCode>();
            Files.fileTraverser().breadthFirst((Object)classpathEntryAsFile).forEach(file -> {
                String fileName;
                if (file.isFile() && (fileName = file.getName().toLowerCase()).endsWith(".class")) {
                    BinaryFileHashing.processFile(file, (path, hash) -> {
                        IPath fqn = path.makeRelativeTo(classpathEntry).removeFileExtension();
                        classHashes.put(fqn, (HashCode)hash);
                    });
                }
            });
            return new FineGrainedEntryHash(classHashes);
        });
    }

    @VisibleForTesting
    public void clear() {
        this.classpathEntries.clear();
    }
}

