/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Driver;
import org.mandas.docker.client.messages.swarm.IpamConfig;
import org.mandas.docker.client.messages.swarm.IpamOptions;

final class ImmutableIpamOptions
implements IpamOptions {
    private final Driver driver;
    @Nullable
    private final List<IpamConfig> configs;

    private ImmutableIpamOptions(Driver driver, @Nullable List<IpamConfig> configs) {
        this.driver = driver;
        this.configs = configs;
    }

    @Override
    @JsonProperty(value="Driver")
    public Driver driver() {
        return this.driver;
    }

    @Override
    @JsonProperty(value="Configs")
    @Nullable
    public List<IpamConfig> configs() {
        return this.configs;
    }

    public final ImmutableIpamOptions withDriver(Driver value) {
        if (this.driver == value) {
            return this;
        }
        Driver newValue = Objects.requireNonNull(value, "driver");
        return new ImmutableIpamOptions(newValue, this.configs);
    }

    public final ImmutableIpamOptions withConfigs(IpamConfig ... elements) {
        if (elements == null) {
            return new ImmutableIpamOptions(this.driver, null);
        }
        List<IpamConfig> newValue = Arrays.asList(elements) == null ? null : ImmutableIpamOptions.createUnmodifiableList(false, ImmutableIpamOptions.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableIpamOptions(this.driver, newValue);
    }

    public final ImmutableIpamOptions withConfigs(@Nullable Iterable<? extends IpamConfig> elements) {
        if (this.configs == elements) {
            return this;
        }
        List<IpamConfig> newValue = elements == null ? null : ImmutableIpamOptions.createUnmodifiableList(false, ImmutableIpamOptions.createSafeList(elements, true, false));
        return new ImmutableIpamOptions(this.driver, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIpamOptions && this.equalTo((ImmutableIpamOptions)another);
    }

    private boolean equalTo(ImmutableIpamOptions another) {
        return this.driver.equals(another.driver) && Objects.equals(this.configs, another.configs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.driver.hashCode();
        h += (h << 5) + Objects.hashCode(this.configs);
        return h;
    }

    public String toString() {
        return "IpamOptions{driver=" + this.driver + ", configs=" + this.configs + "}";
    }

    public static ImmutableIpamOptions copyOf(IpamOptions instance) {
        if (instance instanceof ImmutableIpamOptions) {
            return (ImmutableIpamOptions)instance;
        }
        return ImmutableIpamOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_DRIVER = 1L;
        private long initBits = 1L;
        private Driver driver;
        private List<IpamConfig> configs = null;

        private Builder() {
        }

        public final Builder from(IpamOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.driver(instance.driver());
            List<IpamConfig> configsValue = instance.configs();
            if (configsValue != null) {
                this.addAllConfigs(configsValue);
            }
            return this;
        }

        @JsonProperty(value="Driver")
        public final Builder driver(Driver driver) {
            this.driver = Objects.requireNonNull(driver, "driver");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder config(IpamConfig element) {
            if (this.configs == null) {
                this.configs = new ArrayList<IpamConfig>();
            }
            this.configs.add(Objects.requireNonNull(element, "configs element"));
            return this;
        }

        public final Builder configs(IpamConfig ... elements) {
            if (this.configs == null) {
                this.configs = new ArrayList<IpamConfig>();
            }
            for (IpamConfig element : elements) {
                this.configs.add(Objects.requireNonNull(element, "configs element"));
            }
            return this;
        }

        @JsonProperty(value="Configs")
        public final Builder configs(@Nullable Iterable<? extends IpamConfig> elements) {
            if (elements == null) {
                this.configs = null;
                return this;
            }
            this.configs = new ArrayList<IpamConfig>();
            return this.addAllConfigs(elements);
        }

        public final Builder addAllConfigs(Iterable<? extends IpamConfig> elements) {
            Objects.requireNonNull(elements, "configs element");
            if (this.configs == null) {
                this.configs = new ArrayList<IpamConfig>();
            }
            for (IpamConfig ipamConfig : elements) {
                this.configs.add(Objects.requireNonNull(ipamConfig, "configs element"));
            }
            return this;
        }

        public ImmutableIpamOptions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIpamOptions(this.driver, this.configs == null ? null : ImmutableIpamOptions.createUnmodifiableList(true, this.configs));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("driver");
            }
            return "Cannot build IpamOptions, some of required attributes are not set " + attributes;
        }
    }
}

