/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.net.URL;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CustomTaskImageProvider {
    public static final String ICONS_FOLDER = "icons/";
    public static final String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId("BPMN2");
    private static boolean registered = false;

    public CustomTaskImageProvider(Package pluginPackage) {
    }

    public static void registerAvailableImages() {
        if (!registered) {
            for (TargetRuntime rt : TargetRuntime.createTargetRuntimes()) {
                for (CustomTaskDescriptor ctd : rt.getCustomTaskDescriptors()) {
                    String icon = ctd.getIcon();
                    if (icon == null) continue;
                    CustomTaskImageProvider.registerImage(ctd, icon);
                }
                for (ToolPaletteDescriptor tp : rt.getToolPaletteDescriptors()) {
                    for (ToolPaletteDescriptor.CategoryDescriptor cd : tp.getCategories()) {
                        for (ToolPaletteDescriptor.ToolDescriptor td : cd.getTools()) {
                            String icon = td.getIcon();
                            if (icon == null) continue;
                            CustomTaskImageProvider.registerImage(rt, icon);
                        }
                    }
                }
            }
            registered = true;
        }
    }

    public static Image createImage(CustomTaskDescriptor ctd, GraphicsAlgorithmContainer ga, String icon, IconSize size) {
        String imageId = ctd.getImageId(icon, size);
        if (imageId != null) {
            Image img = Graphiti.getGaService().createImage(ga, imageId);
            img.setProportional(Boolean.valueOf(false));
            return img;
        }
        return null;
    }

    public static Image createImage(CustomTaskDescriptor ctd, GraphicsAlgorithmContainer ga, String icon, int w, int h) {
        String imageId = ctd.getImageId(icon, IconSize.LARGE);
        if (imageId != null) {
            Image img = Graphiti.getGaService().createImage(ga, imageId);
            img.setProportional(Boolean.valueOf(false));
            img.setWidth(w);
            img.setHeight(h);
            img.setStretchH(Boolean.valueOf(true));
            img.setStretchV(Boolean.valueOf(true));
            return img;
        }
        return null;
    }

    protected static void registerImage(CustomTaskDescriptor ctd, String icon) {
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize size = iconSizeArray[n2];
            String imageId = ctd.getImageId(icon, size);
            if (imageId != null) {
                String filename = ctd.getImagePath(icon, size);
                URL url = ctd.getFeatureContainer().getClass().getClassLoader().getResource(filename);
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
                CustomTaskImageProvider.registerImage(imageId, descriptor);
            }
            ++n2;
        }
    }

    public static void registerImage(String imageId, ImageDescriptor image) {
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        if (imageRegistry.get(imageId = String.valueOf(providerId) + "||" + imageId) != null) {
            if (CustomTaskImageProvider.editorInstances() > 1) {
                return;
            }
            imageRegistry.remove(imageId);
        }
        imageRegistry.put(imageId, image);
    }

    private static int editorInstances() {
        int count = 0;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = window.getActivePage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n3 = iEditorReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference ref = iEditorReferenceArray[n4];
                IEditorPart part = ref.getEditor(false);
                if (part != null && part.getAdapter(DiagramEditor.class) != null) {
                    ++count;
                }
                ++n4;
            }
            ++n2;
        }
        return count;
    }

    public static Image createImage(TargetRuntime rt, GraphicsAlgorithmContainer ga, String icon, IconSize size) {
        String imageId = CustomTaskImageProvider.getImageId(rt, icon, size);
        if (imageId != null) {
            Image img = Graphiti.getGaService().createImage(ga, imageId);
            img.setProportional(Boolean.valueOf(false));
            return img;
        }
        return null;
    }

    public static Image createImage(TargetRuntime rt, GraphicsAlgorithmContainer ga, String icon, int w, int h) {
        String imageId = CustomTaskImageProvider.getImageId(rt, icon, IconSize.LARGE);
        if (imageId != null) {
            Image img = Graphiti.getGaService().createImage(ga, imageId);
            img.setProportional(Boolean.valueOf(false));
            img.setWidth(w);
            img.setHeight(h);
            img.setStretchH(Boolean.valueOf(true));
            img.setStretchV(Boolean.valueOf(true));
            return img;
        }
        return null;
    }

    protected static void registerImage(TargetRuntime rt, String icon) {
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize size = iconSizeArray[n2];
            String imageId = CustomTaskImageProvider.getImageId(rt, icon, size);
            if (imageId != null) {
                String filename = CustomTaskImageProvider.getImagePath(rt, icon, size);
                URL url = rt.getRuntimeExtension().getClass().getClassLoader().getResource(filename);
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
                CustomTaskImageProvider.registerImage(imageId, descriptor);
            }
            ++n2;
        }
    }

    public static String getImageId(TargetRuntime rt, String icon, IconSize size) {
        if (icon != null && icon.trim().length() > 0) {
            String prefix = rt.getRuntimeExtension().getClass().getPackage().getName();
            return String.valueOf(prefix) + "." + icon.trim() + "." + size.value;
        }
        return null;
    }

    public static String getImagePath(TargetRuntime rt, String icon, IconSize size) {
        if (icon != null && icon.trim().length() > 0) {
            rt.getRuntimeExtension().getClass().getPackage().getName();
            return ICONS_FOLDER + size.value + "/" + icon.trim();
        }
        return null;
    }

    public static enum IconSize {
        SMALL("small"),
        LARGE("large");

        String value;

        private IconSize(String value) {
            this.value = value;
        }
    }
}

