/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.providers;

import org.eclipse.bpmn2.modeler.ui.property.providers.MessageTypeTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.ModelTreeContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.XSDElementDeclarationTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.XSDSchemaTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.XSDTypeDefinitionTreeNode;
import org.eclipse.bpmn2.modeler.ui.util.ListMap;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class VariableTypeTreeContentProvider
extends ModelTreeContentProvider {
    boolean isPropertyTree;
    boolean displayParticles;

    public VariableTypeTreeContentProvider(boolean isCondensed, boolean displayParticles) {
        super(isCondensed);
        this.displayParticles = displayParticles;
    }

    public boolean isPropertyTree() {
        return this.isPropertyTree;
    }

    @Override
    public Object[] primGetElements(Object inputElement) {
        Object[] list = new Object[1];
        if (inputElement instanceof XSDTypeDefinition) {
            XSDTypeDefinition typeDef = (XSDTypeDefinition)inputElement;
            list[0] = new XSDTypeDefinitionTreeNode(typeDef, this.isCondensed);
        } else if (inputElement instanceof XSDElementDeclaration) {
            XSDElementDeclaration decl = (XSDElementDeclaration)inputElement;
            list[0] = new XSDElementDeclarationTreeNode(decl, this.isCondensed);
        } else if (inputElement instanceof Message) {
            Message msg = (Message)inputElement;
            list[0] = new MessageTypeTreeNode(msg, this.isCondensed, false);
        } else if (inputElement instanceof XSDSchema) {
            XSDSchema schema = (XSDSchema)inputElement;
            list[0] = new XSDSchemaTreeNode(schema, this.isCondensed);
        } else if (inputElement instanceof Definition) {
            Definition defn = (Definition)inputElement;
            Types types = defn.getETypes();
            if (types != null) {
                return (Object[])ListMap.Map(types.getSchemas(), new ListMap.Visitor(){

                    @Override
                    public Object visit(Object obj) {
                        return new XSDSchemaTreeNode((XSDSchema)obj, VariableTypeTreeContentProvider.this.isCondensed);
                    }
                }, list);
            }
            return EMPTY_ARRAY;
        }
        return list;
    }
}

