/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.tasks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.TableColumn;
import org.eclipse.bpmn2.modeler.ui.property.tasks.Messages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class IoParameterMappingColumn
extends TableColumn {
    protected DataAssociation association = null;

    public IoParameterMappingColumn(EObject o, EStructuralFeature f) {
        super(o, f);
    }

    public String getHeaderText() {
        if (this.headerText != null) {
            return this.headerText;
        }
        return ExtendedPropertiesProvider.getLabel((Resource)this.object.eResource(), (EClass)Bpmn2Package.eINSTANCE.getDataAssociation(), (EStructuralFeature)(this.feature.getName().startsWith("dataInput") ? Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef() : Bpmn2Package.eINSTANCE.getDataAssociation_TargetRef()));
    }

    public String getText(Object element) {
        String result = null;
        ItemAwareElement source = (ItemAwareElement)element;
        for (DataAssociation da : this.getDataAssociations(source)) {
            String text = null;
            List<ItemAwareElement> target = this.getTargetElements(da);
            if (!target.isEmpty()) {
                for (ItemAwareElement e : target) {
                    text = text == null ? "" : String.valueOf(text) + ", ";
                    text = String.valueOf(text) + ExtendedPropertiesProvider.getTextValue((EObject)e);
                }
            } else {
                if (da.getTransformation() != null) {
                    text = String.valueOf(Messages.IoParameterMappingColumn_Transform_Prefix) + ExtendedPropertiesProvider.getTextValue((EObject)da.getTransformation());
                }
                if (!da.getAssignment().isEmpty()) {
                    String text2 = null;
                    for (Assignment assign : da.getAssignment()) {
                        FormalExpression expr = this.getTargetExpression(da, assign);
                        String body = ExtendedPropertiesProvider.getTextValue((EObject)expr);
                        if (body == null || body.isEmpty()) continue;
                        body = body.replaceAll("\n", "\\\\n");
                        text2 = text2 == null ? "\"" + body + "\"" : String.valueOf(text2) + ",\n" + body;
                    }
                    text = text == null ? text2 : String.valueOf(text) + " + " + text2;
                }
            }
            if (text == null || text.isEmpty()) continue;
            result = result == null ? "" : String.valueOf(result) + ", ";
            result = String.valueOf(result) + text;
        }
        return result == null ? "" : result;
    }

    private FormalExpression getTargetExpression(DataAssociation da, Assignment assign) {
        return (FormalExpression)(da instanceof DataInputAssociation ? assign.getFrom() : assign.getTo());
    }

    private List<DataAssociation> getDataAssociations(ItemAwareElement element) {
        List list = null;
        if (element instanceof DataInput) {
            list = this.getDataInputAssociations();
        }
        if (element instanceof DataOutput) {
            list = this.getDataOutputAssociations();
        }
        ArrayList<DataAssociation> result = new ArrayList<DataAssociation>();
        if (list != null) {
            for (DataAssociation da : list) {
                for (ItemAwareElement e : this.getSourceElements(da)) {
                    if (element != e) continue;
                    result.add(da);
                }
            }
        }
        return result;
    }

    private List getDataInputAssociations() {
        if (this.object instanceof Activity) {
            return ((Activity)this.object).getDataInputAssociations();
        }
        if (this.object instanceof ThrowEvent) {
            return ((ThrowEvent)this.object).getDataInputAssociation();
        }
        return null;
    }

    private List getDataOutputAssociations() {
        if (this.object instanceof Activity) {
            return ((Activity)this.object).getDataOutputAssociations();
        }
        if (this.object instanceof CatchEvent) {
            return ((CatchEvent)this.object).getDataOutputAssociation();
        }
        return null;
    }

    private List<ItemAwareElement> getSourceElements(DataAssociation da) {
        ArrayList<ItemAwareElement> result = new ArrayList<ItemAwareElement>();
        if (da instanceof DataOutputAssociation) {
            if (da.getSourceRef().size() > 0) {
                result.addAll(da.getSourceRef());
            }
        } else if (da instanceof DataInputAssociation && da.getTargetRef() != null) {
            result.add(da.getTargetRef());
        }
        return result;
    }

    private List<ItemAwareElement> getTargetElements(DataAssociation da) {
        ArrayList<ItemAwareElement> result = new ArrayList<ItemAwareElement>();
        if (da instanceof DataInputAssociation) {
            if (da.getSourceRef().size() > 0) {
                result.addAll(da.getSourceRef());
            }
        } else if (da instanceof DataOutputAssociation && da.getTargetRef() != null) {
            result.add(da.getTargetRef());
        }
        return result;
    }

    private EStructuralFeature getTargetFeature(ItemAwareElement element) {
        return element instanceof DataInput ? Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef() : Bpmn2Package.eINSTANCE.getDataAssociation_TargetRef();
    }
}

