/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine;

import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.templateengine.Messages;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.cdt.core.templateengine.TemplateInitializationException;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.TemplateProcessHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class TemplateCore {
    private static final String DESCRIPTION = "description";
    private static final String LABEL = "label";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static Map<TemplateInfo, TemplateCore> templateCache = new HashMap<TemplateInfo, TemplateCore>();
    public static final Comparator<TemplateCore> TEMPLATE_ID_CASE_INSENSITIVE_COMPARATOR = new Comparator<TemplateCore>(){

        @Override
        public int compare(TemplateCore t1, TemplateCore t2) {
            return String.CASE_INSENSITIVE_ORDER.compare(t1.getTemplateId(), t2.getTemplateId());
        }
    };
    private TemplateDescriptor templateDescriptor;
    private Map<String, String> valueStore;
    private TemplateInfo templateInfo;
    private Set<String> allMacrosInProcesses;
    private TemplateProcessHandler processHandler;
    private String description;
    private String label;
    private String templateId;
    private String templateType;
    private boolean fireDirtyEvents;

    protected TemplateCore(TemplateInfo templateInfo) throws TemplateInitializationException {
        URL descriptorURL;
        this.templateInfo = templateInfo;
        try {
            descriptorURL = TemplateEngineHelper.getTemplateResourceURL(templateInfo.getPluginId(), templateInfo.getTemplatePath());
        }
        catch (IOException ioe) {
            String msg = NLS.bind((String)Messages.TemplateCore_init_failed, (Object)templateInfo.getTemplatePath());
            throw new TemplateInitializationException(msg);
        }
        if (descriptorURL == null) {
            throw new TemplateInitializationException("Unable to load project template. Location URL is null for " + templateInfo.getTemplateId());
        }
        this.templateDescriptor = new TemplateDescriptor(descriptorURL, templateInfo.getPluginId());
        this.valueStore = new ValueStore<String>(this);
        this.valueStore.putAll(this.templateDescriptor.getTemplateDefaults(this.templateDescriptor.getRootElement()));
        this.valueStore.putAll(TemplateEngine.getSharedDefaults());
        this.valueStore.put("projectType", templateInfo.getProjectType());
        this.processHandler = new TemplateProcessHandler(this);
        this.allMacrosInProcesses = this.processHandler.getAllMacros();
        this.fireDirtyEvents = true;
    }

    public Set<String> getAllMissingMacrosInProcesses() {
        TreeSet<String> set = new TreeSet<String>(this.allMacrosInProcesses);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (this.valueStore.get(iter.next()) == null) continue;
            iter.remove();
        }
        return set;
    }

    public Map<String, String> getValueStore() {
        return this.valueStore;
    }

    public List<String> getPersistTrueIDs() {
        return this.templateDescriptor.getPersistTrueIDs();
    }

    public TemplateInfo getTemplateInfo() {
        return this.templateInfo;
    }

    public TemplateDescriptor getTemplateDescriptor() {
        return this.templateDescriptor;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.templateDescriptor.getRootElement().getAttribute(DESCRIPTION).trim();
        }
        return TemplateEngineHelper.externalizeTemplateString(this.templateInfo, this.description);
    }

    public String getTemplateId() {
        if (this.templateId == null) {
            this.templateId = this.templateDescriptor.getRootElement().getAttribute(ID).trim();
        }
        return this.templateId;
    }

    public String getTemplateType() {
        if (this.templateType == null) {
            this.templateType = this.templateDescriptor.getRootElement().getAttribute(TYPE).trim();
        }
        return this.templateType;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.templateDescriptor.getRootElement().getAttribute(LABEL).trim();
        }
        return TemplateEngineHelper.externalizeTemplateString(this.templateInfo, this.label);
    }

    public TemplateProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    public String toString() {
        return this.getLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty() {
        if (this.fireDirtyEvents) {
            Map<TemplateInfo, TemplateCore> map = templateCache;
            synchronized (map) {
                templateCache.remove(this.templateInfo);
            }
        }
    }

    public IStatus[] executeTemplateProcesses(IProgressMonitor monitor, boolean showError) {
        this.setDirty();
        TemplateEngine.getDefault().updateSharedDefaults(this);
        IStatus[][] result = new IStatus[1][];
        try {
            result[0] = this.getProcessHandler().processAll(monitor);
        }
        catch (ProcessFailureException e) {
            TemplateEngineUtil.log(e);
            result[0] = new IStatus[]{new Status(4, this.getClass(), 4, e.getMessage(), (Throwable)e)};
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateCore getTemplate(TemplateInfo templateInfo) throws TemplateInitializationException {
        Map<TemplateInfo, TemplateCore> map = templateCache;
        synchronized (map) {
            TemplateCore template = templateCache.get(templateInfo);
            if (template == null) {
                template = new TemplateCore(templateInfo);
                templateCache.put(templateInfo, template);
            }
            return template;
        }
    }

    private static class ValueStore<K>
    extends HashMap<K, String> {
        private static final long serialVersionUID = -4523467333437879406L;
        private TemplateCore template;

        ValueStore(TemplateCore template) {
            this.template = template;
        }

        @Override
        public String put(K key, String value) {
            value = TemplateEngineHelper.externalizeTemplateString(this.template.getTemplateInfo(), value);
            String v = super.put(key, value);
            this.template.setDirty();
            return v;
        }

        @Override
        public void putAll(Map<? extends K, ? extends String> map) {
            for (K key : map.keySet()) {
                String value = map.get(key);
                value = TemplateEngineHelper.externalizeTemplateString(this.template.getTemplateInfo(), value);
                super.put(key, value);
            }
            this.template.setDirty();
        }

        @Override
        public String remove(Object key) {
            String v = (String)super.remove(key);
            this.template.setDirty();
            return v;
        }
    }
}

