/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.utils.CharArraySequence;

public abstract class ScriptContentDescriber
implements ITextContentDescriber {
    private static final int BUFFER_LENGTH = 2048;
    private static final int HEADER_LENGTH = 4096;
    private static final int FOOTER_LENGTH = 4096;

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[]{DLTKContentTypeManager.DLTK_VALID};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkHeader(File file, Pattern[] headerPatterns, Pattern[] footerPatterns) throws FileNotFoundException, IOException {
        FileInputStream reader = null;
        try {
            reader = new FileInputStream(file);
            byte[] buf = new byte[2049];
            int res = reader.read(buf);
            if (res == -1) return false;
            if (res == 0) {
                return false;
            }
            String header = new String(buf);
            if (ScriptContentDescriber.checkBufferForPatterns(header, headerPatterns)) {
                return true;
            }
            if (file.length() >= 2048L) return false;
            if (footerPatterns == null) return false;
            if (!ScriptContentDescriber.checkBufferForPatterns(header, footerPatterns)) return false;
            return true;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean checkFooter(File file, Pattern[] footerPatterns) throws FileNotFoundException, IOException {
        try (RandomAccessFile raFile = new RandomAccessFile(file, "r");){
            String content;
            long len = 2048L;
            long fileSize = raFile.length();
            long offset = fileSize - len;
            if (offset < 0L) {
                offset = 0L;
            }
            raFile.seek(offset);
            byte[] buf = new byte[2049];
            int code = raFile.read(buf);
            return code != -1 && ScriptContentDescriber.checkBufferForPatterns(content = new String(buf, 0, code), footerPatterns);
            {
            }
        }
    }

    private static boolean checkBufferForPatterns(CharSequence header, Pattern[] patterns) {
        if (patterns == null) {
            return false;
        }
        int i = 0;
        while (i < patterns.length) {
            Matcher m = patterns[i].matcher(header);
            if (m.find()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean checkPatterns(File file, Pattern[] headerPatterns, Pattern[] footerPatterns) {
        block4: {
            if (!ScriptContentDescriber.checkHeader(file, headerPatterns, footerPatterns)) break block4;
            return true;
        }
        try {
            return footerPatterns != null && file.length() > 2048L && ScriptContentDescriber.checkFooter(file, footerPatterns);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static int read(Reader reader, char[] bufffer, int offset, int len) {
        try {
            int count = 0;
            while (len > 0) {
                int result = reader.read(bufffer, offset, len);
                if (result > 0) {
                    offset += result;
                    len -= result;
                    count += result;
                    continue;
                }
                if (result >= 0) continue;
                if (count != 0) break;
                return result;
            }
            return count;
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return -1;
        }
    }

    public static boolean checkPatterns(Reader reader, Pattern[] headerPatterns, Pattern[] footerPatterns) {
        int bufferSize = Math.max(4096, 4096);
        char[] buffer = new char[bufferSize];
        int len = ScriptContentDescriber.read(reader, buffer, 0, 4096);
        if (len > 0 && headerPatterns != null && headerPatterns.length > 0 && ScriptContentDescriber.checkBufferForPatterns(new CharArraySequence(buffer, len), headerPatterns)) {
            return true;
        }
        if (footerPatterns != null && footerPatterns.length > 0) {
            char[] prevBuffer = new char[bufferSize];
            int prevLen = 0;
            char[] tempBuffer = buffer;
            buffer = prevBuffer;
            prevBuffer = tempBuffer;
            int savedLen = prevLen;
            prevLen = len;
            len = savedLen;
            len = ScriptContentDescriber.read(reader, buffer, 0, bufferSize);
            if (len <= 0) {
                CharArraySequence footer;
                if (savedLen >= 4096) {
                    footer = new CharArraySequence(buffer, savedLen - 4096, 4096);
                } else {
                    int footerLength = prevLen;
                    if (savedLen > 0) {
                        footerLength += savedLen;
                    }
                    if (footerLength > 4096) {
                        footerLength = 4096;
                    }
                    int prevOffset = Math.max(prevLen - footerLength, 0);
                    int prevSize = Math.min(prevLen, footerLength);
                    if (savedLen > 0) {
                        System.arraycopy(buffer, 0, buffer, footerLength - savedLen, savedLen);
                        prevOffset += savedLen;
                        prevSize -= savedLen;
                    }
                    if (prevSize > 0) {
                        System.arraycopy(prevBuffer, prevOffset, buffer, 0, prevSize);
                    }
                    footer = new CharArraySequence(buffer, footerLength);
                }
                if (ScriptContentDescriber.checkBufferForPatterns(footer, footerPatterns)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return this.describe(new InputStreamReader(contents), description);
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        Pattern[] footer;
        Pattern[] header = this.getHeaderPatterns();
        if (ScriptContentDescriber.checkPatterns(contents, header, footer = this.getFooterPatterns())) {
            if (description != null) {
                description.setProperty(DLTKContentTypeManager.DLTK_VALID, (Object)Boolean.TRUE);
            }
            return 2;
        }
        return 1;
    }

    protected abstract Pattern[] getHeaderPatterns();

    protected Pattern[] getFooterPatterns() {
        return null;
    }
}

