/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.AbstractPickList;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.imp.ModelImportWizard;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VApplicationCategoriesEditor
extends AbstractComponentEditor<MApplication> {
    private Composite composite;
    private TableViewer viewer;
    private EMFDataBindingContext context;
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Action> actionsImport = new ArrayList<Action>();

    @Inject
    public VApplicationCategoriesEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.VApplicationCategoriesEditor_AddCategory, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Category")){

            public void run() {
                VApplicationCategoriesEditor.this.handleAdd();
            }
        });
        this.actionsImport.add(new Action(this.Messages.VApplicationCategoriesEditor_AddCategory, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Category")){

            public void run() {
                VApplicationCategoriesEditor.this.handleImport();
            }
        });
    }

    protected void handleImport() {
        ModelImportWizard wizard = new ModelImportWizard(MCategory.class, this, this.resourcePool);
        WizardDialog wizardDialog = new WizardDialog(this.viewer.getControl().getShell(), (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            MCategory[] elements;
            MCategory[] mCategoryArray = elements = (MCategory[])wizard.getElements(MCategory.class);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                MCategory category = mCategoryArray[n2];
                this.addCategory(category);
                ++n2;
            }
        }
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.VApplicationCategoriesEditor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.VApplicationCategoriesEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = this.createForm(parent, this.context, this.getMaster());
        }
        VirtualEntry o = (VirtualEntry)object;
        this.viewer.setInput(o.getList());
        this.getMaster().setValue((Object)((MApplication)o.getOriginalParent()));
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<MApplication> master) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        E4PickList pickList = new E4PickList(parent, 0, Arrays.asList(AbstractPickList.PickListFeatures.NO_PICKER), (AbstractComponentEditor)this, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION__CATEGORIES){

            @Override
            protected void addPressed() {
                VApplicationCategoriesEditor.this.handleAdd();
            }

            @Override
            protected List<?> getContainerChildren(Object container) {
                return ((MApplication)container).getCategories();
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.viewer = pickList.getList();
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        return null;
    }

    protected void handleAdd() {
        MCategory category = CommandsFactoryImpl.eINSTANCE.createCategory();
        this.addCategory(category);
    }

    private void addCategory(MCategory category) {
        this.setElementId(category);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)ApplicationPackageImpl.Literals.APPLICATION__CATEGORIES, (Object)category);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(category);
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }

    @Override
    public List<Action> getActionsImport(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actionsImport);
        return l;
    }
}

