/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.ui.discovery.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class WorkbenchUtil {
    private static Optional<Shell> getModalShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        return Arrays.stream(shells).filter(shell -> shell.isVisible() && (shell.getStyle() & modal) != 0).findFirst();
    }

    public static Shell getShell() {
        if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        return WorkbenchUtil.getModalShell().orElse(WorkbenchUtil.getNonModalShell().orElse(null));
    }

    private static Optional<Shell> getNonModalShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return Optional.of(windows[0].getShell());
            }
        } else {
            return Optional.of(window.getShell());
        }
        return Optional.empty();
    }

    public static final boolean isFiltering() {
        return !PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds().isEmpty();
    }

    public static boolean allowUseOf(Object object) {
        IPluginContribution contribution;
        if (!WorkbenchUtil.isFiltering()) {
            return true;
        }
        if (object instanceof IPluginContribution && (contribution = (IPluginContribution)object).getPluginId() != null) {
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchUtil.createUnifiedId(contribution));
            return identifier.isEnabled();
        }
        if (object instanceof String) {
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier((String)object);
            return identifier.isEnabled();
        }
        return true;
    }

    private static final String createUnifiedId(IPluginContribution contribution) {
        if (contribution.getPluginId() != null) {
            return contribution.getPluginId() + "/" + contribution.getLocalId();
        }
        return contribution.getLocalId();
    }

    public static void openUrl(String location) {
        WorkbenchUtil.openUrl(location, 0);
    }

    public static void openUrl(String location, int customFlags) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (WebBrowserPreference.getBrowserChoice() == 1 || (customFlags & 0x80) != 0) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (PartInitException partInitException) {
                    Status status = new Status(4, "org.eclipse.equinox.p2.ui.discovery", Messages.WorkbenchUtil_Browser_Initialization_Failed);
                    MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
                }
            } else {
                IWebBrowser browser = null;
                int flags = customFlags;
                flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? (flags |= 0x26) : (flags |= 0x86);
                String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException e) {
            Status status = new Status(4, "org.eclipse.equinox.p2.ui.discovery", Messages.WorkbenchUtil_Browser_Initialization_Failed, (Throwable)e);
            LogHelper.log((IStatus)status);
            MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
        }
        catch (MalformedURLException e) {
            if (location != null && location.trim().equals("")) {
                Status status = new Status(2, "org.eclipse.equinox.p2.ui.discovery", Messages.WorkbenchUtil_No_URL_Error, (Throwable)e);
                MessageDialog.openWarning((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
            }
            Status status = new Status(4, "org.eclipse.equinox.p2.ui.discovery", NLS.bind((String)Messages.WorkbenchUtil_Invalid_URL_Error, (Object)location), (Throwable)e);
            MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
        }
    }
}

