/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import java.util.HashSet;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class SnappingBehavior
extends AbstractBehavior {
    public static final String SNAPPING_FEEDBACK_PART_FACTORY = "snappingFeedbackPartFactory";
    private ListChangeListener<SnappingModel.SnappingLocation> snappingLocationsObserver = new ListChangeListener<SnappingModel.SnappingLocation>(){

        public void onChanged(ListChangeListener.Change<? extends SnappingModel.SnappingLocation> c) {
            List previousContents = CollectionUtils.getPreviousContents(c);
            SnappingBehavior.this.onSnappingLocationsChanged(previousContents, (List<? extends SnappingModel.SnappingLocation>)c.getList());
        }
    };

    @Override
    protected void doActivate() {
        super.doActivate();
        SnappingModel snappingModel = (SnappingModel)this.getHost().getRoot().getViewer().getAdapter(SnappingModel.class);
        snappingModel.snappingLocationsProperty().addListener(this.snappingLocationsObserver);
    }

    @Override
    protected void doDeactivate() {
        SnappingModel snappingModel = (SnappingModel)this.getHost().getRoot().getViewer().getAdapter(SnappingModel.class);
        snappingModel.snappingLocationsProperty().removeListener(this.snappingLocationsObserver);
        super.doDeactivate();
    }

    @Override
    protected IFeedbackPartFactory getFeedbackPartFactory(IViewer viewer) {
        return this.getFeedbackPartFactory(viewer, SNAPPING_FEEDBACK_PART_FACTORY);
    }

    protected void onSnappingLocationsChanged(List<? extends SnappingModel.SnappingLocation> oldValue, List<? extends SnappingModel.SnappingLocation> newValue) {
        HashSet<IContentPart<? extends Node>> oldParts = new HashSet<IContentPart<? extends Node>>();
        for (SnappingModel.SnappingLocation snappingLocation : oldValue) {
            oldParts.add(snappingLocation.getPart());
        }
        HashSet<IContentPart<? extends Node>> hashSet = new HashSet<IContentPart<? extends Node>>();
        for (SnappingModel.SnappingLocation snappingLocation : newValue) {
            if (snappingLocation.getPart().getRoot() == null) {
                throw new IllegalStateException("ContentPart has no link to the RootPart!");
            }
            hashSet.add(snappingLocation.getPart());
        }
        for (IVisualPart iVisualPart : oldParts) {
            this.removeFeedback(iVisualPart);
        }
        for (IVisualPart iVisualPart : hashSet) {
            this.addFeedback(iVisualPart);
        }
    }
}

