/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JavaClassJDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JavaFieldJDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JavaMethodJDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JavaReflectionSynchronizer;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdapterFactory;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.ReflectionAdaptor;

public class JavaJDOMAdapterFactory
extends JavaReflectionAdapterFactory {
    protected JavaReflectionSynchronizer synchronizer;
    protected IJavaProject javaProject;

    public JavaJDOMAdapterFactory() {
    }

    public JavaJDOMAdapterFactory(IJavaProject aJavaProject) {
        this();
        this.setJavaProject(aJavaProject);
    }

    protected ReflectionAdaptor createJavaClassAdaptor(Notifier target) {
        return new JavaClassJDOMAdaptor(target, this.getJavaProject(), this);
    }

    protected ReflectionAdaptor createJavaFieldAdaptor(Notifier target) {
        return new JavaFieldJDOMAdaptor(target, this.getJavaProject());
    }

    protected ReflectionAdaptor createJavaMethodAdaptor(Notifier target) {
        return new JavaMethodJDOMAdaptor(target, this.getJavaProject());
    }

    public void flushAll() {
        this.doFlush(this.reflected.values(), true, true);
    }

    public List flushAllNoNotification() {
        return this.doFlush(this.reflected.values(), true, false);
    }

    public void flushPackage(String packageName, boolean noFlushIfSourceFound) {
        List adaptors = this.getReflectedForPackage(packageName, noFlushIfSourceFound);
        this.doFlush(adaptors, true, true);
    }

    public List flushPackageNoNotification(String packageName, boolean noFlushIfSourceFound) {
        List adaptors = this.getReflectedForPackage(packageName, noFlushIfSourceFound);
        return this.doFlush(adaptors, true, false);
    }

    private List getReflectedForPackage(String packageName, boolean filterFoundTypes) {
        if (packageName != null && !this.reflected.isEmpty()) {
            this.isBusyIteratingReflected = true;
            ArrayList result = null;
            try {
                for (Map.Entry entry : this.reflected.entrySet()) {
                    String key;
                    JavaClassJDOMAdaptor adaptor = (JavaClassJDOMAdaptor)((Object)entry.getValue());
                    if (filterFoundTypes && adaptor.hasValidReflection() || !(key = (String)entry.getKey()).startsWith(packageName) || key.indexOf(46, packageName.length() + 1) >= 0) continue;
                    if (result == null) {
                        result = new ArrayList();
                    }
                    result.add(entry.getValue());
                }
            }
            finally {
                this.finishedIteratingReflected();
            }
            if (result != null) {
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List doFlush(Collection adaptors, boolean clearSourceType, boolean doNotify) {
        if (!adaptors.isEmpty()) {
            this.isBusyIteratingReflected = true;
            ArrayList<Notification> notifications = doNotify ? null : new ArrayList<Notification>(adaptors.size());
            try {
                for (JDOMAdaptor adaptor : adaptors) {
                    if (doNotify) {
                        adaptor.flushReflectedValuesIfNecessary(clearSourceType);
                        continue;
                    }
                    Notification notification = adaptor.flushReflectedValuesIfNecessaryNoNotification(clearSourceType);
                    if (notification == null) continue;
                    notifications.add(notification);
                }
            }
            finally {
                this.finishedIteratingReflected();
            }
            return notifications;
        }
        return Collections.EMPTY_LIST;
    }

    public void flushReflection(String source) {
        JDOMAdaptor a = (JDOMAdaptor)((Object)this.reflected.get(source));
        if (a != null) {
            a.flushReflectedValuesIfNecessary();
        }
    }

    public Notification flushReflectionNoNotification(String source) {
        JDOMAdaptor a = (JDOMAdaptor)((Object)this.reflected.get(source));
        if (a != null) {
            return a.flushReflectedValuesIfNecessaryNoNotification(false);
        }
        return null;
    }

    public Notification flushReflectionPlusInnerNoNotification(String source) {
        this.isBusyIteratingReflected = true;
        Notification notification = null;
        try {
            String innerName = String.valueOf(source) + '$';
            for (Map.Entry entry : this.reflected.entrySet()) {
                JavaReflectionAdaptor adaptor;
                String key = (String)entry.getKey();
                if (!key.equals(source) && !key.startsWith(innerName) || (adaptor = (JavaReflectionAdaptor)this.reflected.get(key)) == null) continue;
                if (notification == null) {
                    notification = adaptor.flushReflectedValuesIfNecessaryNoNotification(false);
                    continue;
                }
                ((NotificationChain)notification).add(adaptor.flushReflectedValuesIfNecessaryNoNotification(false));
            }
        }
        finally {
            this.finishedIteratingReflected();
        }
        return notification;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    protected void initializeSynchronizer() {
        this.synchronizer = new JavaReflectionSynchronizer(this);
    }

    public void notifyContentChanged(ICompilationUnit targetCU) {
        if (targetCU == null || this.reflected.values() == null) {
            return;
        }
        this.isBusyIteratingReflected = true;
        try {
            for (Object a : this.reflected.values()) {
                if (!(a instanceof JDOMAdaptor)) continue;
                JDOMAdaptor adaptor = (JDOMAdaptor)((Object)a);
                IMember reflectionSource = (IMember)adaptor.getReflectionSource();
                ICompilationUnit adapterCU = null;
                if (reflectionSource != null) {
                    try {
                        adapterCU = reflectionSource.getCompilationUnit();
                    }
                    catch (Exception exception) {}
                }
                if (adapterCU == null || !targetCU.equals(adapterCU)) continue;
                adaptor.contentChanged();
            }
        }
        finally {
            this.finishedIteratingReflected();
        }
    }

    public void setJavaProject(IJavaProject newJavaProject) {
        this.javaProject = newJavaProject;
        if (newJavaProject != null && this.synchronizer == null) {
            this.initializeSynchronizer();
        }
    }
}

