/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jpt.common.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.common.ui.internal.swt.events.DisposeAdapter;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableItemModelAdapter {
    protected final TableItem tableItem;
    protected final DisposeListener tableItemDisposeListener;
    private ColumnAdapter<Object> columnAdapter;
    private ModifiablePropertyValueModel<?>[] valueModels;
    private PropertyChangeListener[] propertyChangeListeners;
    private final ITableLabelProvider labelProvider;

    public static TableItemModelAdapter adapt(TableItem tableItem, ColumnAdapter<?> columnAdapter, ITableLabelProvider labelProvider) {
        return new TableItemModelAdapter(tableItem, columnAdapter, labelProvider);
    }

    protected TableItemModelAdapter(TableItem tableItem, ColumnAdapter<?> columnAdapter, ITableLabelProvider labelProvider) {
        if (tableItem == null || columnAdapter == null || labelProvider == null) {
            throw new NullPointerException();
        }
        this.tableItem = tableItem;
        this.labelProvider = labelProvider;
        this.columnAdapter = columnAdapter;
        this.tableItemDisposeListener = this.buildTableItemDisposeListener();
        this.tableItem.addDisposeListener(this.tableItemDisposeListener);
        this.valueModels = this.columnAdapter.cellModels(tableItem.getData());
        this.propertyChangeListeners = this.buildPropertyChangeListeners();
        int index = this.columnAdapter.columnCount();
        while (--index >= 0) {
            this.tableItemChanged(index, tableItem.getData(), false);
            this.valueModels[index].addPropertyChangeListener("value", this.propertyChangeListeners[index]);
        }
    }

    private PropertyChangeListener[] buildPropertyChangeListeners() {
        PropertyChangeListener[] listeners = new PropertyChangeListener[this.columnAdapter.columnCount()];
        int index = listeners.length;
        while (index-- > 0) {
            listeners[index] = this.buildPropertyChangeListener(index);
        }
        return listeners;
    }

    protected PropertyChangeListener buildPropertyChangeListener(int index) {
        return SWTListenerTools.wrap(this.buildPropertyChangeListener_(index), (Widget)this.tableItem);
    }

    protected PropertyChangeListener buildPropertyChangeListener_(int index) {
        return new TableItemPropertyChangeListener(index);
    }

    protected DisposeListener buildTableItemDisposeListener() {
        return new TableItemDisposeListener();
    }

    protected void cellModelChanged(int index) {
        if (!this.tableItem.isDisposed()) {
            Table table = this.tableItem.getParent();
            this.tableItemChanged(index, this.tableItem.getData(), table.getColumnCount() == 0);
        }
    }

    protected void tableItemChanged(int index, Object subject, boolean revalidate) {
        if (!this.tableItem.isDisposed()) {
            this.updateTableItemText(index, subject);
            this.updateTableItemImage(index, subject);
            if (revalidate) {
                this.layoutTable();
            }
        }
    }

    private void updateTableItemText(int index, Object subject) {
        String text = this.labelProvider.getColumnText(subject, index);
        if (text == null) {
            text = "";
        }
        this.tableItem.setText(index, text);
    }

    private void updateTableItemImage(int index, Object subject) {
        Image image = this.labelProvider.getColumnImage(subject, index);
        this.tableItem.setImage(index, image);
    }

    private void layoutTable() {
        Composite container = this.tableItem.getParent().getParent();
        container.computeSize(-1, -1);
        container.layout();
    }

    protected void tableItemDisposed() {
        this.tableItem.removeDisposeListener(this.tableItemDisposeListener);
        int index = this.valueModels.length;
        while (index-- > 0) {
            this.valueModels[index].removePropertyChangeListener("value", this.propertyChangeListeners[index]);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }

    protected class TableItemDisposeListener
    extends DisposeAdapter {
        protected TableItemDisposeListener() {
        }

        @Override
        public void widgetDisposed(DisposeEvent event) {
            TableItemModelAdapter.this.tableItemDisposed();
        }
    }

    protected class TableItemPropertyChangeListener
    extends PropertyChangeAdapter {
        private final int index;

        protected TableItemPropertyChangeListener(int index) {
            this.index = index;
        }

        public void propertyChanged(PropertyChangeEvent event) {
            TableItemModelAdapter.this.cellModelChanged(this.index);
        }
    }
}

