/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.layout.TextLayoutSupport;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.jst.pagedesigner.css2.widget.AbstractWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.BorderUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TextAreaWidgetProvider
extends AbstractWidgetProvider {
    private static final int DEFAULTCOLUMN = 20;
    private static final int DEFAULTROWS = 2;
    private static final int VERTICAL_PADDING = 2;
    private static final int HORIZONTAL_PADDING = 2;
    private static int ARRAWWIDTH = 16;
    private static int ARROWHEIGHT = 16;
    private int _columns = 20;
    private int _rows = 2;
    private String _value;

    public TextAreaWidgetProvider(ICSSStyle style) {
        super(style);
    }

    @Override
    public DimensionInfo getPreferredDimension(int width, int height) {
        if (width <= 0) {
            width = this.getDefaultWidth();
        }
        if (height <= 0) {
            height = this.getDefaultHeight();
        }
        return new DimensionInfo(width, height, -1);
    }

    private int getDefaultHeight() {
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            style = DefaultStyle.getInstance();
        }
        ICSSFont font = style.getCSSFont();
        Font swtfont = font.getSwtFont();
        int fontHeight = FigureUtilities.getFontMetrics((Font)swtfont).getHeight();
        return fontHeight * this._rows + 2;
    }

    private int getDefaultWidth() {
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            style = DefaultStyle.getInstance();
        }
        ICSSFont font = style.getCSSFont();
        int fontWidth = FigureUtilities.getFontMetrics((Font)font.getSwtFont()).getAverageCharWidth();
        return this._columns * fontWidth + ARRAWWIDTH + 2;
    }

    @Override
    public void paintFigure(Graphics g, Rectangle rect) {
        if (this._value != null) {
            int y;
            g.clipRect(rect);
            ICSSStyle style = this.getCSSStyle();
            if (style == null) {
                style = DefaultStyle.getInstance();
            }
            int decoration = (Integer)style.getStyleProperty("text-decoration");
            ICSSFont font = style.getCSSFont();
            g.setFont(font.getSwtFont());
            Color newColor = null;
            Object color = style.getColor();
            if (color instanceof Color) {
                g.setForegroundColor((Color)color);
            } else if (color instanceof RGB) {
                newColor = new Color((Device)Display.getCurrent(), (RGB)color);
                g.setForegroundColor(newColor);
            } else {
                g.setForegroundColor(ColorConstants.black);
            }
            Object textAlign = style.getStyleProperty("text-align");
            int begin = 0;
            int end = 0;
            int fontHeight = FigureUtilities.getFontMetrics((Font)font.getSwtFont()).getHeight();
            int fontWidth = FigureUtilities.getFontMetrics((Font)font.getSwtFont()).getAverageCharWidth();
            int columns = (rect.width - 2) / fontWidth;
            int i = 0;
            while ((y = rect.y + 1 + fontHeight * i) < rect.bottom()) {
                if ((end += columns) > this._value.length()) {
                    end = this._value.length();
                }
                end = this.getTextCount(begin, end, g.getFont(), rect.width - ARRAWWIDTH);
                String text = this._value.substring(begin, end);
                int width = FigureUtilities.getTextWidth((String)text, (Font)g.getFont());
                int x = TextLayoutSupport.getBeginX(textAlign, rect, width);
                g.drawString(text, x, y);
                TextLayoutSupport.paintTextDecoration(g, new Rectangle(x, y, width, fontHeight), decoration);
                begin = end;
                if (end == this._value.length()) break;
                ++i;
            }
            if (newColor != null) {
                newColor.dispose();
            }
        }
        int borderThick = 2;
        BorderUtil.drawVertialBar(g, ARRAWWIDTH, ARROWHEIGHT, borderThick, rect);
    }

    private int getTextCount(int begin, int end, Font swtFont, int textWidth) {
        while (begin > -1 && end > begin && FigureUtilities.getTextWidth((String)this._value.substring(begin, end), (Font)swtFont) > textWidth) {
            --end;
        }
        return end;
    }

    public void setColumns(int columns) {
        this._columns = columns > 0 ? columns : 20;
    }

    public void setRows(int rows) {
        this._rows = rows > 0 ? rows : 2;
    }

    public void setValue(String value) {
        this._value = value;
    }
}

