/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.dialogs;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class NewHandlerChainDialog
extends ElementTreeSelectionDialog
implements ISelectionStatusValidator {
    private IStatus ok_status = new Status(0, "org.eclipse.jst.ws.jaxws.ui", "");
    private String handlerChainFileName = "handler-chain.xml";

    public NewHandlerChainDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setTitle(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_TITLE);
        this.setMessage(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_DESCRIPTION);
        this.setAllowMultiple(false);
        this.setValidator(this);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite fileComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        fileComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        fileComposite.setLayoutData((Object)gridData);
        Label handleChainLabel = new Label(fileComposite, 0);
        handleChainLabel.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_NAME);
        Text newHandlerChainText = new Text(fileComposite, 2048);
        gridData = new GridData(4, 4, true, false);
        newHandlerChainText.setLayoutData((Object)gridData);
        newHandlerChainText.setText(this.handlerChainFileName);
        newHandlerChainText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                NewHandlerChainDialog.this.handlerChainFileName = ((Text)e.widget).getText();
                NewHandlerChainDialog.this.updateOKStatus();
            }
        });
        this.updateOKStatus();
        return composite;
    }

    public IStatus validate(Object[] selection) {
        if (this.handlerChainFileName.trim().length() == 0) {
            return new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_ENTER_NAME);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(this.handlerChainFileName, 1);
        if (!result.isOK()) {
            return result;
        }
        if (selection == null || selection.length == 0 || selection[0] instanceof IJavaProject) {
            return new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_CHOOSE_FOLDER);
        }
        if (!this.handlerChainFileName.endsWith(".xml")) {
            return new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_INVALID_NAME);
        }
        Path path = new Path(this.getFilePath());
        if (path.segmentCount() > 1 && path.lastSegment() != null && path.lastSegment().equals(".xml")) {
            return new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_EMPTY_FILE_NAME);
        }
        if (workspace.getRoot().getFile((IPath)path).exists()) {
            return new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_EXISTS, (Object)this.handlerChainFileName));
        }
        return this.ok_status;
    }

    public String getFileName() {
        return this.handlerChainFileName;
    }

    public String getFilePath() {
        Object element = this.getFirstResult();
        if (element instanceof IJavaProject) {
            return String.valueOf(((IJavaProject)element).getProject().getFullPath().toOSString()) + File.separatorChar + this.handlerChainFileName;
        }
        if (element instanceof IJavaElement) {
            return String.valueOf(((IJavaElement)element).getResource().getFullPath().toOSString()) + File.separatorChar + this.handlerChainFileName;
        }
        if (element instanceof IResource) {
            return String.valueOf(((IResource)element).getFullPath().toOSString()) + File.separatorChar + this.handlerChainFileName;
        }
        return this.handlerChainFileName;
    }
}

