/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationContext;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.Messages;

public class ExternalizationManager {
    private static final int SAVE_DELAY = 90000;
    private final ExternalizationJob saveJob;
    private IStatus loadStatus;
    private String rootFolderPath;
    private static volatile boolean saveDisabled = false;
    private final List<IExternalizationParticipant> externalizationParticipants;
    private boolean forceSave = false;

    public ExternalizationManager(String rootFolderPath) {
        Assert.isNotNull((Object)rootFolderPath);
        this.externalizationParticipants = new CopyOnWriteArrayList<IExternalizationParticipant>();
        this.forceSave = false;
        this.saveJob = this.createJob();
        this.setRootFolderPath(rootFolderPath);
    }

    private ExternalizationJob createJob() {
        ExternalizationJob job = new ExternalizationJob(Messages.ExternalizationManager_Task_List_Save_Job);
        job.setUser(false);
        job.setSystem(true);
        return job;
    }

    public void addParticipant(IExternalizationParticipant participant) {
        Assert.isNotNull((Object)participant);
        this.externalizationParticipants.add(participant);
    }

    public IStatus load() {
        try {
            saveDisabled = true;
            this.loadStatus = null;
            ArrayList<IStatus> statusList = new ArrayList<IStatus>();
            IProgressMonitor monitor = Policy.monitorFor(null);
            for (IExternalizationParticipant participant : this.externalizationParticipants) {
                IStatus status = this.load(participant, monitor);
                if (status == null) continue;
                statusList.add(status);
            }
            if (statusList.size() > 0) {
                this.loadStatus = new MultiStatus("org.eclipse.mylyn.tasks.core", 4, statusList.toArray(new IStatus[0]), "Failed to load Task List", null);
            }
            IStatus iStatus = this.loadStatus;
            return iStatus;
        }
        finally {
            saveDisabled = false;
        }
    }

    public IStatus load(final IExternalizationParticipant participant, final IProgressMonitor monitor) {
        final IStatus[] result = new IStatus[1];
        final ExternalizationContext context = new ExternalizationContext(IExternalizationContext.Kind.LOAD, this.rootFolderPath);
        ISchedulingRule rule = participant.getSchedulingRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    result[0] = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, "org.eclipse.mylyn.tasks.core", "Load participant failed", e);
                }

                public void run() throws Exception {
                    participant.execute(context, monitor);
                }
            });
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
        return result[0];
    }

    public void setRootFolderPath(String rootFolderPath) {
        Assert.isNotNull((Object)rootFolderPath);
        this.rootFolderPath = rootFolderPath;
        this.saveJob.setContext(new ExternalizationContext(IExternalizationContext.Kind.SAVE, rootFolderPath));
    }

    public void requestSave() {
        if (!saveDisabled) {
            this.saveJob.schedule(90000L);
        }
    }

    public void stop() {
        try {
            saveDisabled = true;
            this.saveNow();
        }
        catch (InterruptedException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task List save on shutdown canceled.", (Throwable)e));
        }
    }

    public void saveNow() throws InterruptedException {
        this.saveJob.setFullSavePending();
        this.saveJob.wakeUp();
        this.saveJob.join();
        while (this.saveJob.isFullSavePending()) {
            this.saveJob.schedule();
            this.saveJob.wakeUp();
            this.saveJob.join();
        }
    }

    public void save(boolean force) {
        try {
            this.forceSave = force;
            this.saveJob.run((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            this.forceSave = false;
        }
    }

    public IStatus getLoadStatus() {
        return this.loadStatus;
    }

    private class ExternalizationContext
    implements IExternalizationContext {
        private final IExternalizationContext.Kind kind;
        private final String rootPath;

        public ExternalizationContext(IExternalizationContext.Kind kind, String rootPath) {
            this.kind = kind;
            this.rootPath = rootPath;
        }

        @Override
        public IExternalizationContext.Kind getKind() {
            return this.kind;
        }

        @Override
        public String getRootPath() {
            return this.rootPath;
        }
    }

    private class ExternalizationJob
    extends Job {
        private volatile IExternalizationContext context;
        private volatile boolean isFullSavePending;
        private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$mylyn$internal$tasks$core$externalization$IExternalizationContext$Kind;

        public ExternalizationJob(String jobTitle) {
            super(jobTitle);
            this.isFullSavePending = false;
        }

        public boolean isFullSavePending() {
            return this.isFullSavePending;
        }

        public void setFullSavePending() {
            this.isFullSavePending = true;
        }

        public void setContext(IExternalizationContext saveContext) {
            this.context = saveContext;
        }

        /*
         * Unable to fully structure code
         */
        protected IStatus run(IProgressMonitor monitor) {
            context = this.context;
            switch (ExternalizationJob.$SWITCH_TABLE$org$eclipse$mylyn$internal$tasks$core$externalization$IExternalizationContext$Kind()[context.getKind().ordinal()]) {
                case 1: {
                    try {
                        monitor.beginTask(Messages.ExternalizationManager_Saving_, ExternalizationManager.this.externalizationParticipants.size());
                        fullSave = this.isFullSavePending;
                        this.isFullSavePending = false;
                        for (IExternalizationParticipant participant : ExternalizationManager.this.externalizationParticipants) {
                            rule = participant.getSchedulingRule();
                            if (!ExternalizationManager.this.forceSave && !participant.isDirty(fullSave)) ** GOTO lbl25
                            try {
                                try {
                                    Job.getJobManager().beginRule(rule, monitor);
                                    monitor.setTaskName(MessageFormat.format(Messages.ExternalizationManager_Saving_X, new Object[]{participant.getDescription()}));
                                    participant.execute(context, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                                }
                                catch (CoreException e) {
                                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Save failed for " + participant.getDescription(), (Throwable)e));
                                    Job.getJobManager().endRule(rule);
                                    ** GOTO lbl25
                                }
                            }
                            catch (Throwable var8_8) {
                                Job.getJobManager().endRule(rule);
                                throw var8_8;
                            }
                            Job.getJobManager().endRule(rule);
lbl25:
                            // 3 sources

                            monitor.worked(1);
                        }
                        break;
                    }
                    finally {
                        monitor.done();
                    }
                }
                default: {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Unsupported externalization kind: " + (Object)context.getKind()));
                }
            }
            return Status.OK_STATUS;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$mylyn$internal$tasks$core$externalization$IExternalizationContext$Kind() {
            if ($SWITCH_TABLE$org$eclipse$mylyn$internal$tasks$core$externalization$IExternalizationContext$Kind != null) {
                return $SWITCH_TABLE$org$eclipse$mylyn$internal$tasks$core$externalization$IExternalizationContext$Kind;
            }
            int[] nArray = new int[IExternalizationContext.Kind.values().length];
            try {
                nArray[IExternalizationContext.Kind.LOAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[IExternalizationContext.Kind.SAVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[IExternalizationContext.Kind.SNAPSHOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$org$eclipse$mylyn$internal$tasks$core$externalization$IExternalizationContext$Kind = nArray;
            return nArray;
        }
    }
}

