/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.commands.CommandComposerPart;
import org.eclipse.pde.internal.ui.commands.CommandTreeContentProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class CommandList {
    private CommandComposerPart fCCP;
    private FormToolkit fToolkit;
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    private CommandTreeContentProvider fContentProvider;
    private ICommandImageService fComImgServ;

    protected static String getText(Object obj) {
        if (obj instanceof Command) {
            Command com = (Command)obj;
            try {
                return com.getName();
            }
            catch (NotDefinedException notDefinedException) {
                return com.getId();
            }
        }
        if (obj instanceof Category) {
            Category cat = (Category)obj;
            try {
                return cat.getName();
            }
            catch (NotDefinedException notDefinedException) {
                return cat.getId();
            }
        }
        return "";
    }

    public CommandList(CommandComposerPart cv, Composite parent) {
        this.fCCP = cv;
        this.fToolkit = cv.getToolkit();
        this.createTree(parent);
        this.fComImgServ = (ICommandImageService)PlatformUI.getWorkbench().getAdapter(ICommandImageService.class);
    }

    private void createTree(Composite parent) {
        Composite c = this.fCCP.createComposite(parent, 1808, 1, true, 5);
        Section section = this.fToolkit.createSection(c, 256);
        section.setText(PDEUIMessages.CommandList_groupName);
        section.setLayoutData((Object)new GridData(1808));
        Composite comp = this.fCCP.createComposite((Composite)section);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        toolBarManager.add((IAction)new CollapseAction(this){

            public void run() {
                fTreeViewer.collapseAll();
            }
        });
        this.fToolkit.adapt((Control)toolbar, true, true);
        toolbar.setBackground(null);
        section.setTextClient((Control)toolbar);
        toolBarManager.update(true);
        this.createFilterText(comp);
        Tree tree = this.fToolkit.createTree(comp, 768);
        tree.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        tree.setLayoutData((Object)gd);
        this.fTreeViewer = new TreeViewer(tree);
        this.fContentProvider = new CommandTreeContentProvider(this.fCCP.getCommandService());
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new CommandTreeLabelProvider());
        this.fTreeViewer.setComparator((ViewerComparator)new CommandTreeComparator());
        this.fTreeViewer.addFilter((ViewerFilter)new WildcardFilter());
        this.fTreeViewer.setInput(new Object());
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.fCCP);
        section.setClient((Control)comp);
    }

    protected void addTreeSelectionListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.fTreeViewer.addSelectionChangedListener(listener);
        }
    }

    private void createFilterText(Composite parent) {
        Composite c = this.fCCP.createComposite(parent, 768, 3, false, 0);
        this.fFilterText = this.fToolkit.createText(c, "", 2048);
        this.fFilterText.setLayoutData((Object)new GridData(768));
        this.fFilterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    CommandList.this.fTreeViewer.getControl().setFocus();
                }
            }
        });
        ImageHyperlink clearButton = this.fToolkit.createImageHyperlink(c, 0);
        Image hoverImg = PDEPluginImages.DESC_CLEAR.createImage();
        clearButton.setImage(hoverImg);
        clearButton.setToolTipText(PDEUIMessages.CommandList_clearTooltip);
        clearButton.addDisposeListener(e -> hoverImg.dispose());
        clearButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                CommandList.this.fFilterText.setText("");
            }
        });
        clearButton.setVisible(false);
        this.fFilterText.addModifyListener(e -> {
            this.fTreeViewer.refresh();
            clearButton.setVisible(this.fFilterText.getText().length() > 0);
        });
    }

    public void setFocus() {
        this.fFilterText.setFocus();
    }

    protected void setSelection(Object object) {
        if (this.fTreeViewer != null && object != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
    }

    public ISelection getSelection() {
        return this.fTreeViewer.getSelection();
    }

    private class CollapseAction
    extends Action {
        public CollapseAction() {
            super(PDEUIMessages.CommandList_collapseAll0, 1);
            this.setImageDescriptor(PDEPluginImages.DESC_COLLAPSE_ALL);
            this.setToolTipText(PDEUIMessages.CommandList_collapseAll0);
        }
    }

    protected static class CommandTreeComparator
    extends ViewerComparator {
        protected CommandTreeComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return CommandList.getText(e1).compareTo(CommandList.getText(e2));
        }
    }

    protected class CommandTreeLabelProvider
    extends LabelProvider {
        private HashMap<Object, Image> fImgMap = new HashMap();
        private Image fDefaultImage;

        protected CommandTreeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Category) {
                return CommandList.getText(element);
            }
            if (element instanceof Command) {
                return CommandList.getText(element);
            }
            return null;
        }

        public Image getImage(Object element) {
            Image img = this.fImgMap.get(element);
            if (img != null) {
                return img;
            }
            if (element instanceof Category) {
                img = PDEPluginImages.DESC_COMGROUP_OBJ.createImage();
            } else if (element instanceof Command) {
                ImageDescriptor desc = CommandList.this.fComImgServ.getImageDescriptor(((Command)element).getId());
                if (desc == null) {
                    if (this.fDefaultImage == null) {
                        this.fDefaultImage = PDEPluginImages.DESC_BUILD_VAR_OBJ.createImage();
                    }
                    return this.fDefaultImage;
                }
                img = desc.createImage();
            }
            if (img != null) {
                this.fImgMap.put(element, img);
            }
            return img;
        }

        public void dispose() {
            this.fImgMap.values().forEach(Resource::dispose);
            if (this.fDefaultImage != null) {
                this.fDefaultImage.dispose();
            }
            super.dispose();
        }
    }

    protected class WildcardFilter
    extends ViewerFilter {
        protected WildcardFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String filterText = CommandList.this.fFilterText.getText();
            if (filterText.length() == 0) {
                return true;
            }
            String wMatch = "*" + filterText + "*";
            Pattern pattern = null;
            try {
                pattern = PatternConstructor.createPattern((String)wMatch, (boolean)false);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return false;
            }
            if (element instanceof Category) {
                Command[] commands;
                ITreeContentProvider prov = (ITreeContentProvider)CommandList.this.fTreeViewer.getContentProvider();
                Command[] commandArray = commands = (Command[])prov.getChildren(element);
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    Command command = commandArray[n2];
                    String text = CommandList.getText(command);
                    if (pattern.matcher(text.subSequence(0, text.length())).matches()) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            String text = CommandList.getText(element);
            return pattern.matcher(text.subSequence(0, text.length())).matches();
        }
    }
}

