/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.net.URI;
import java.nio.file.Path;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CopyLocationAction
extends Action {
    private StructuredViewer fViewer;
    private String fLocation;

    public CopyLocationAction(StructuredViewer viewer) {
        this.fViewer = viewer;
        this.setText(Messages.CopyLocationAction_copyLocation);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        viewer.addPostSelectionChangedListener(event -> this.updateEnablement(event.getStructuredSelection()));
        this.updateEnablement(viewer.getStructuredSelection());
    }

    public void run() {
        Clipboard clipboard = new Clipboard(this.fViewer.getControl().getDisplay());
        try {
            clipboard.setContents(new Object[]{this.fLocation}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateEnablement(IStructuredSelection selection) {
        this.fLocation = null;
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            Object object = firstElement;
            if (object instanceof TargetBundle) {
                URI location;
                void targetBundle;
                TargetBundle targetBundle2 = (TargetBundle)object;
                TargetBundle cfr_ignored_0 = (TargetBundle)object;
                BundleInfo bundleInfo = targetBundle.getBundleInfo();
                if (bundleInfo != null && (location = bundleInfo.getLocation()) != null && "file".equals(location.getScheme())) {
                    this.fLocation = Path.of(location).toString();
                }
            } else {
                Object object2 = firstElement;
                if (object2 instanceof TargetFeature) {
                    void targetFeature;
                    TargetFeature bundleInfo = (TargetFeature)object2;
                    TargetFeature cfr_ignored_1 = (TargetFeature)object2;
                    this.fLocation = targetFeature.getLocation();
                } else {
                    Object object3 = firstElement;
                    if (object3 instanceof BundleDescription) {
                        void bundleDescription;
                        BundleDescription bundleDescription2 = (BundleDescription)object3;
                        BundleDescription cfr_ignored_2 = (BundleDescription)object3;
                        this.fLocation = bundleDescription.getLocation();
                    }
                }
            }
        }
        this.setEnabled(this.fLocation != null);
    }
}

