/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProductDefinitonWizardPage
extends WizardPage
implements IHyperlinkListener {
    private Text fProductName;
    private Text fPluginText;
    private Text fProductText;
    private Set<String> fProductSet;
    private Combo fApplicationCombo;
    private IProduct fProduct;
    private ModifyListener fListener = e -> this.validatePage();

    public ProductDefinitonWizardPage(String pageName, IProduct product) {
        super(pageName);
        this.fProduct = product;
        this.setTitle(PDEUIMessages.ProductDefinitonWizardPage_title);
        if (this.productNameDefined()) {
            this.setDescription(PDEUIMessages.ProductDefinitonWizardPage_desc);
        } else {
            this.setDescription(PDEUIMessages.ProductDefinitonWizardPage_descNoName);
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 20;
        comp.setLayout((Layout)layout);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.createProductGroup(toolkit, comp);
        this.createApplicationGroup(toolkit, comp);
        toolkit.dispose();
        this.setControl((Control)comp);
        this.setPageComplete(this.getPluginId() != null && this.productNameDefined());
        Dialog.applyDialogFont((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.pde.doc.user.product_definitions_wizard_page");
    }

    private void createFormText(FormToolkit toolkit, Composite parent, String content, int span) {
        FormText text = toolkit.createFormText(parent, false);
        text.setText(content, true, false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = 400;
        text.setLayoutData((Object)gd);
        text.setBackground(parent.getBackground());
        text.addHyperlinkListener((IHyperlinkListener)this);
    }

    private void createProductGroup(FormToolkit toolkit, Composite comp) {
        Label label;
        Group group = new Group(comp, 0);
        group.setText(PDEUIMessages.ProductDefinitonWizardPage_productGroup);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        this.createFormText(toolkit, (Composite)group, PDEUIMessages.ProductDefinitonWizardPage_productDefinition, 3);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        if (!this.productNameDefined()) {
            label = new Label((Composite)group, 0);
            label.setText(PDEUIMessages.ProductDefinitonWizardPage_productName);
            this.fProductName = new Text((Composite)group, 2052);
            this.fProductName.setLayoutData((Object)gd);
            this.fProductName.addModifyListener(this.fListener);
        }
        label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.ProductDefinitonWizardPage_plugin);
        this.fPluginText = new Text((Composite)group, 2052);
        this.fPluginText.setLayoutData((Object)new GridData(768));
        Button button = new Button((Composite)group, 8);
        button.setText(PDEUIMessages.ProductDefinitonWizardPage_browse);
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleBrowse()));
        label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.ProductDefinitonWizardPage_productId);
        this.fProductText = new Text((Composite)group, 2052);
        this.fProductText.setLayoutData((Object)gd);
        String pluginId = this.getPluginId();
        if (pluginId != null) {
            this.fPluginText.setText(pluginId);
            String productId = "product";
            String numString = "";
            int idNum = 1;
            while (this.getProductNameSet().contains(pluginId + "." + productId + numString)) {
                numString = Integer.toString(idNum++);
            }
            this.fProductText.setText(productId + numString);
        }
        this.fPluginText.addModifyListener(this.fListener);
        this.fProductText.addModifyListener(this.fListener);
    }

    private void createApplicationGroup(FormToolkit toolkit, Composite comp) {
        Group group = new Group(comp, 0);
        group.setText(PDEUIMessages.ProductDefinitonWizardPage_applicationGroup);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.createFormText(toolkit, (Composite)group, PDEUIMessages.ProductDefinitonWizardPage_applicationDefinition, 2);
        Label label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.ProductDefinitonWizardPage_application);
        this.fApplicationCombo = new Combo((Composite)group, 12);
        this.fApplicationCombo.setLayoutData((Object)new GridData(768));
        this.fApplicationCombo.setItems(TargetPlatform.getApplications());
        if (this.fApplicationCombo.getItemCount() > 0) {
            this.fApplicationCombo.setText(this.fApplicationCombo.getItem(0));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fProductName != null) {
                this.fProductName.setFocus();
            } else {
                this.fPluginText.setFocus();
            }
        }
        super.setVisible(visible);
    }

    private void validatePage() {
        String error = null;
        String productName = this.getProductName();
        if (productName != null && productName.length() == 0) {
            error = PDEUIMessages.ProductDefinitonWizardPage_noProductName;
        }
        this.validateIdAndProduct(error);
    }

    private void validateIdAndProduct(String error) {
        if (error == null) {
            String pluginId = this.getDefiningPlugin();
            IPluginModelBase model = PluginRegistry.findModel((String)pluginId);
            if (pluginId.length() == 0) {
                error = PDEUIMessages.ProductDefinitonWizardPage_noPluginId;
            } else if (model == null) {
                error = PDEUIMessages.ProductDefinitonWizardPage_noPlugin;
            } else if (model.getUnderlyingResource() == null) {
                error = PDEUIMessages.ProductDefinitonWizardPage_notInWorkspace;
            }
            if (error == null) {
                error = this.validateId();
            }
            if (error == null && this.getProductNameSet().contains(pluginId + "." + this.fProductText.getText().trim())) {
                error = PDEUIMessages.ProductDefinitonWizardPage_productExists;
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    private String validateId() {
        String id = this.fProductText.getText().trim();
        if (id.length() == 0) {
            return PDEUIMessages.ProductDefinitonWizardPage_noProductID;
        }
        int i = 0;
        while (i < id.length()) {
            if (!id.substring(i, i + 1).matches("[a-zA-Z0-9_]")) {
                return PDEUIMessages.ProductDefinitonWizardPage_invalidId;
            }
            ++i;
        }
        return null;
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public void linkActivated(HyperlinkEvent e) {
        String extPoint = "org.eclipse.core.runtime." + e.getHref().toString();
        IPluginExtensionPoint point = PDECore.getDefault().getExtensionsRegistry().findExtensionPoint(extPoint);
        if (point != null) {
            new ShowDescriptionAction(point, true).run();
        }
    }

    private void handleBrowse() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.getShell(), PluginRegistry.getWorkspaceModels(), false);
        if (dialog.open() == 0) {
            IPluginModelBase model = (IPluginModelBase)dialog.getFirstResult();
            this.fPluginText.setText(model.getPluginBase().getId());
        }
    }

    private Set<String> getProductNameSet() {
        if (this.fProductSet == null) {
            this.fProductSet = TargetPlatformHelper.getProductNameSet();
        }
        return this.fProductSet;
    }

    public String getDefiningPlugin() {
        return this.fPluginText.getText().trim();
    }

    public String getProductId() {
        return this.fProductText.getText().trim();
    }

    public String getApplication() {
        return this.fApplicationCombo.getText();
    }

    public String getProductName() {
        return this.fProductName == null ? null : this.fProductName.getText().trim();
    }

    private boolean productNameDefined() {
        return this.fProduct.getName() != null && !this.fProduct.getName().equals("");
    }

    private String getPluginId() {
        IProject project = this.fProduct.getModel().getUnderlyingResource().getProject();
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        return model == null ? null : model.getPluginBase().getId();
    }
}

