/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.etfw.ETFWUtils;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.toolopts.BuildTool;
import org.eclipse.ptp.etfw.toolopts.ExecTool;
import org.eclipse.ptp.etfw.toolopts.ExternalTool;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.etfw.toolopts.PostProcTool;
import org.eclipse.ptp.internal.etfw.BuilderTool;
import org.eclipse.ptp.internal.etfw.ETFWAnalysisTool;
import org.eclipse.ptp.internal.etfw.ETFWBuildTool;
import org.eclipse.ptp.internal.etfw.ETFWLaunchTool;
import org.eclipse.ptp.internal.etfw.ETFWToolStep;
import org.eclipse.ptp.internal.etfw.ILaunchFactory;
import org.eclipse.ptp.internal.etfw.LauncherTool;
import org.eclipse.ptp.internal.etfw.ParametricToolLaunchManager;
import org.eclipse.ptp.internal.etfw.PostlaunchTool;
import org.eclipse.ptp.internal.etfw.ToolStep;
import org.eclipse.ptp.internal.etfw.jaxb.data.AnalysisToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.BuildToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.EtfwToolProcessType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ExecToolType;
import org.eclipse.ptp.internal.etfw.jaxb.util.ExternalToolProcessUtil;
import org.eclipse.ptp.internal.etfw.jaxb.util.JAXBExtensionUtils;
import org.eclipse.ptp.internal.etfw.messages.Messages;

public class ToolLaunchManager {
    protected static final String buildText = Messages.ToolLaunchManager_InstrumentingAndBuilding;
    protected static final String launchText = Messages.ToolLaunchManager_ExecutingInstrumentedProject;
    protected static final String collectText = Messages.ToolLaunchManager_CollectingPerfData;
    protected LaunchConfigurationDelegate paraDel;
    private ILaunchFactory lf = null;
    private IBuildLaunchUtils utilBlob = null;

    private static boolean runJAXBStep(ETFWToolStep step) {
        step.schedule();
        try {
            step.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        boolean result = step.getResult().isOK();
        step.setSuccessAttribute(Boolean.toString(result));
        return result;
    }

    private static boolean runStep(ToolStep step) {
        step.schedule();
        try {
            step.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return step.getResult().isOK();
    }

    public ToolLaunchManager(LaunchConfigurationDelegate delegate, ILaunchFactory lf, IBuildLaunchUtils utilBlob) {
        this.paraDel = delegate;
        this.lf = lf;
        this.utilBlob = utilBlob;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launchIn, IProgressMonitor monitor) throws CoreException {
        String whichParser = configuration.getAttribute("ETFW_VERSION", "");
        if (whichParser.equals("sax-parser")) {
            this.launchSAXTool(configuration, mode, launchIn, monitor);
        } else {
            this.launchJAXBTool(configuration, mode, launchIn, monitor);
        }
    }

    private void launchJAXBTool(ILaunchConfiguration configuration, String mode, ILaunch launchIn, IProgressMonitor monitor) throws CoreException {
        ILaunch launch = launchIn;
        EtfwToolProcessType etfwTool = JAXBExtensionUtils.getTool((String)configuration.getAttribute("selected_performance_tool", null));
        boolean useParam = configuration.getAttribute("use the parametric analysis system", false);
        if (useParam) {
            ParametricToolLaunchManager.launch(configuration, this.paraDel, this.lf, mode, launchIn, monitor, this.utilBlob);
            return;
        }
        String bProgPath = null;
        String bOutLoc = null;
        boolean ran = false;
        boolean buildOnly = configuration.getAttribute("build_but_do_not_run_instrumented_executable", false);
        boolean analyzeOnly = configuration.getAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", false);
        BuildToolType bt = ExternalToolProcessUtil.getBuildTool((EtfwToolProcessType)etfwTool, (ILaunchConfiguration)configuration, (int)0);
        ExecToolType et = ExternalToolProcessUtil.getExecTool((EtfwToolProcessType)etfwTool, (ILaunchConfiguration)configuration, (int)0);
        AnalysisToolType ppt = ExternalToolProcessUtil.getAnalysisTool((EtfwToolProcessType)etfwTool, (ILaunchConfiguration)configuration, (int)0);
        if (buildOnly) {
            ETFWBuildTool builder = new ETFWBuildTool(configuration, bt, this.utilBlob);
            ToolLaunchManager.runJAXBStep(builder);
            return;
        }
        boolean bl = analyzeOnly = analyzeOnly || bt == null && ppt != null && et == null;
        if (analyzeOnly) {
            ETFWAnalysisTool analyzer = new ETFWAnalysisTool(configuration, ppt, null, this.utilBlob);
            ToolLaunchManager.runJAXBStep(analyzer);
            return;
        }
        if (!etfwTool.isRecompile()) {
            ETFWBuildTool builder = new ETFWBuildTool(configuration, null, this.utilBlob);
            if (!ToolLaunchManager.runJAXBStep(builder)) {
                return;
            }
            bProgPath = builder.getProgramPath();
            bOutLoc = builder.getOutputLocation();
            if (!(etfwTool.isPrependExecution() || etfwTool.getExecToolOrAnalysisToolOrBuildTool().get(0) instanceof ExecToolType || etfwTool.isExplicitExecution())) {
                ETFWLaunchTool launcher = new ETFWLaunchTool(configuration, null, bProgPath, this.paraDel, launch, this.utilBlob);
                if (!ToolLaunchManager.runJAXBStep(launcher)) {
                    return;
                }
                ran = true;
            }
        }
        boolean globalState = true;
        int i = 0;
        while (i < etfwTool.getExecToolOrAnalysisToolOrBuildTool().size()) {
            AnalysisToolType analysisTool;
            Object t = etfwTool.getExecToolOrAnalysisToolOrBuildTool().get(i);
            if (t instanceof BuildToolType) {
                ETFWBuildTool builder;
                BuildToolType buildTool = (BuildToolType)t;
                if (ExternalToolProcessUtil.canRun((boolean)globalState, (BuildToolType)buildTool, (ILaunchConfiguration)configuration) && (globalState &= ToolLaunchManager.runJAXBStep(builder = new ETFWBuildTool(configuration, (BuildToolType)t, this.utilBlob)))) {
                    ETFWLaunchTool launcher;
                    bProgPath = builder.getProgramPath();
                    bOutLoc = builder.getOutputLocation();
                    if (!(etfwTool.isPrependExecution() || ran || i >= etfwTool.getExecToolOrAnalysisToolOrBuildTool().size() - 1 || etfwTool.getExecToolOrAnalysisToolOrBuildTool().get(i + 1) instanceof ExecToolType || etfwTool.isExplicitExecution() || !(globalState &= ToolLaunchManager.runJAXBStep(launcher = new ETFWLaunchTool(configuration, null, bProgPath, this.paraDel, launch, this.utilBlob))))) {
                        ran = true;
                    }
                }
            } else if (t instanceof ExecToolType) {
                ETFWLaunchTool launcher;
                ExecToolType execTool = (ExecToolType)t;
                if (ExternalToolProcessUtil.canRun((boolean)globalState, (ExecToolType)execTool, (ILaunchConfiguration)configuration) && (globalState &= ToolLaunchManager.runJAXBStep(launcher = new ETFWLaunchTool(configuration, execTool, bProgPath, this.paraDel, launch, this.utilBlob))) && launcher.outputLocation != null) {
                    bOutLoc = launcher.outputLocation;
                }
            } else if (t instanceof AnalysisToolType && ExternalToolProcessUtil.canRun((boolean)globalState, (AnalysisToolType)(analysisTool = (AnalysisToolType)t), (ILaunchConfiguration)configuration)) {
                ETFWAnalysisTool analyzer = new ETFWAnalysisTool(configuration, analysisTool, bOutLoc, this.utilBlob);
                globalState &= ToolLaunchManager.runJAXBStep(analyzer);
            }
            ++i;
        }
    }

    private void launchSAXTool(ILaunchConfiguration configuration, String mode, ILaunch launchIn, IProgressMonitor monitor) throws CoreException {
        boolean useParam;
        ILaunch launch = launchIn;
        ExternalToolProcess pproc = ETFWUtils.getTool(configuration.getAttribute("selected_performance_tool", null));
        boolean bl = useParam = configuration.getAttribute("use the parametric analysis system", false) || pproc.para != null && pproc.para.runParametric;
        if (useParam) {
            ParametricToolLaunchManager.launch(configuration, this.paraDel, this.lf, mode, launchIn, monitor, this.utilBlob);
            return;
        }
        String bProgPath = null;
        String bOutLoc = null;
        boolean ran = false;
        BuilderTool builder = null;
        LauncherTool launcher = null;
        boolean buildOnly = configuration.getAttribute("build_but_do_not_run_instrumented_executable", false);
        boolean analyzeOnly = configuration.getAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", false);
        BuildTool bt = pproc.getFirstBuilder(configuration);
        PostProcTool ppt = pproc.getFirstAnalyzer(configuration);
        ExecTool et = pproc.getFirstRunner(configuration);
        if (buildOnly) {
            builder = new BuilderTool(configuration, bt, this.utilBlob);
            ToolLaunchManager.runStep(builder);
            return;
        }
        boolean bl2 = analyzeOnly = analyzeOnly || bt == null && ppt != null && et == null;
        if (analyzeOnly) {
            PostlaunchTool analyzer = new PostlaunchTool(configuration, ppt, null, this.utilBlob);
            ToolLaunchManager.runStep(analyzer);
            return;
        }
        if (!pproc.recompile) {
            builder = new BuilderTool(configuration, null, this.utilBlob);
            if (!ToolLaunchManager.runStep(builder)) {
                return;
            }
            bProgPath = builder.getProgramPath();
            bOutLoc = builder.getOutputLocation();
            if (!(pproc.prependExecution || pproc.externalTools.get(0) instanceof ExecTool || pproc.explicitExecution)) {
                launcher = new LauncherTool(configuration, null, bProgPath, this.paraDel, launch, this.utilBlob);
                if (!ToolLaunchManager.runStep(launcher)) {
                    return;
                }
                ran = true;
            }
        }
        int i = 0;
        while (i < pproc.externalTools.size()) {
            ExternalTool t = (ExternalTool)pproc.externalTools.get(i);
            if (t.canRun(configuration)) {
                PostlaunchTool analyzer;
                if (t instanceof BuildTool) {
                    builder = new BuilderTool(configuration, (BuildTool)t, this.utilBlob);
                    if (!ToolLaunchManager.runStep(builder)) {
                        return;
                    }
                    bProgPath = builder.getProgramPath();
                    bOutLoc = builder.getOutputLocation();
                    if (!(pproc.prependExecution || ran || i >= pproc.externalTools.size() - 1 || pproc.externalTools.get(i + 1) instanceof ExecTool || pproc.explicitExecution)) {
                        launcher = new LauncherTool(configuration, null, bProgPath, this.paraDel, launch, this.utilBlob);
                        if (!ToolLaunchManager.runStep(launcher)) {
                            return;
                        }
                        ran = true;
                    }
                } else if (t instanceof ExecTool) {
                    launcher = new LauncherTool(configuration, (ExecTool)t, bProgPath, this.paraDel, launch, this.utilBlob);
                    if (!ToolLaunchManager.runStep(launcher)) {
                        return;
                    }
                    if (launcher.outputLocation != null) {
                        bOutLoc = launcher.outputLocation;
                    }
                } else if (t instanceof PostProcTool && !ToolLaunchManager.runStep(analyzer = new PostlaunchTool(configuration, (PostProcTool)t, bOutLoc, this.utilBlob))) {
                    return;
                }
            }
            ++i;
        }
    }
}

