/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.util.StringUtils;
import org.osgi.framework.BundleException;

public class StartLevelSupport {
    public static final String START_LEVEL_ATTR = "Runtime-StartLevel";
    public static final String AUTO_START_ATTR = "Runtime-AutoStart";
    private static final Map<String, String> predefined = new HashMap<String, String>();

    static {
        predefined.put("org.eclipse.equinox.weaving.aspectj", "1:true");
        predefined.put("org.aspectj.runtime", "1:true");
        predefined.put("org.eclipse.osgi", "-1:true");
        predefined.put("org.eclipse.equinox.ds", "2:true");
        predefined.put("org.eclipse.equinox.common", "2:true");
        predefined.put("org.eclipse.equinox.simpleconfigurator", "1:true");
        predefined.put("org.eclipse.update.configurator", String.format("%s:%s", "3", "true"));
        predefined.put("org.eclipse.core.runtime", "default:true");
    }

    public static BundleStart getStartInfo(IPluginModelBase model, BundleStart hint) {
        String q7sl = null;
        String q7as = null;
        Map<String, String> headers = StartLevelSupport.loadManifest(model.getInstallLocation());
        if (headers != null) {
            q7sl = StringUtils.safeToString((Object)headers.get(START_LEVEL_ATTR));
            q7as = StringUtils.safeToString((Object)headers.get(AUTO_START_ATTR));
        } else {
            Q7ExtLaunchingPlugin.logWarn("Could not read manifest for bundle %s", model.getInstallLocation());
        }
        if (q7sl != null || q7as != null) {
            return BundleStart.fromQ7Headers(q7sl, q7as);
        }
        String id = Q7LaunchDelegateUtils.id(model);
        if (hint.isDefault() && predefined.containsKey(id)) {
            return BundleStart.fromModelString(predefined.get(id));
        }
        return hint;
    }

    /*
     * Loose catch block
     */
    public static Map<String, String> loadManifest(String path) {
        Map map;
        InputStream manifestStream;
        ZipFile jarFile;
        block11: {
            jarFile = null;
            manifestStream = null;
            File dirOrJar = new File(path);
            String extension = new Path(path).getFileExtension();
            if (extension != null && extension.equals("jar") && dirOrJar.isFile()) {
                jarFile = new ZipFile(dirOrJar, 1);
                ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(dirOrJar, "META-INF/MANIFEST.MF");
                if (file.exists()) {
                    manifestStream = new FileInputStream(file);
                }
            }
            if (manifestStream != null) break block11;
            StartLevelSupport.closeZipFileAndStream(manifestStream, jarFile);
            return null;
        }
        try {
            map = ManifestElement.parseBundleManifest((InputStream)manifestStream, new HashMap(10));
        }
        catch (BundleException e) {
            StartLevelSupport.closeZipFileAndStream(manifestStream, jarFile);
            return null;
        }
        catch (IOException e2) {
            StartLevelSupport.closeZipFileAndStream(manifestStream, jarFile);
            return null;
            {
                catch (Throwable throwable) {
                    StartLevelSupport.closeZipFileAndStream(manifestStream, jarFile);
                    throw throwable;
                }
            }
        }
        StartLevelSupport.closeZipFileAndStream(manifestStream, jarFile);
        return map;
    }

    private static void closeZipFileAndStream(InputStream stream, ZipFile jarFile) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }
}

