/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.json.internal;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tips.core.IUrlTip;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.json.IJsonTip;
import org.eclipse.tips.json.internal.Util;

public class JsonUrlTip
extends Tip
implements IUrlTip,
IJsonTip {
    private String fSubject;
    private Date fDate;
    private String fUrl;
    private JsonObject fJsonObject;

    public JsonUrlTip(String providerId, JsonObject jsonObject) throws ParseException {
        super(providerId);
        this.fJsonObject = jsonObject;
        this.fSubject = Util.getValueOrDefault(jsonObject, "subject", "Not set");
        this.fDate = JsonUrlTip.getDate(jsonObject);
        this.fUrl = Util.getValueOrDefault(jsonObject, "url", null);
    }

    private static Date getDate(JsonObject jsonObject) throws ParseException {
        String date = Util.getValueOrDefault(jsonObject, "date", "1970-01-01");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(date);
    }

    public Date getCreationDate() {
        return this.fDate;
    }

    public String getURL() {
        return Util.replace(this.fJsonObject, this.fUrl);
    }

    public String getSubject() {
        return this.fSubject;
    }

    @Override
    public String getJsonObject() {
        return this.fJsonObject.getAsString();
    }
}

