/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.themes.css;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.core.theme.IStyle;
import org.eclipse.tm4e.core.theme.RGB;
import org.eclipse.tm4e.core.theme.css.CSSParser;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.themes.ColorManager;
import org.eclipse.tm4e.ui.themes.ITokenProvider;

public class CSSTokenProvider
implements ITokenProvider {
    private final Map<IStyle, @Nullable IToken> tokenMaps = new HashMap<IStyle, IToken>();
    private final Map<String, IToken> getTokenReturnValueCache = new ConcurrentHashMap<String, IToken>();
    private final CSSParser parser;

    public CSSTokenProvider(InputStream in) {
        CSSParser parser = null;
        try {
            parser = new CSSParser(in);
            for (IStyle style : parser.getStyles()) {
                RGB color = style.getColor();
                if (color == null) continue;
                int s = 0;
                if (style.isBold()) {
                    s |= 1;
                }
                if (style.isItalic()) {
                    s |= 2;
                }
                if (style.isUnderline()) {
                    s |= 0x40000000;
                }
                if (style.isStrikeThrough()) {
                    s |= 0x20000000;
                }
                this.tokenMaps.put(style, (IToken)new Token((Object)new TextAttribute(ColorManager.getInstance().getColor(color), null, s)));
            }
        }
        catch (Exception ex) {
            TMUIPlugin.logError(ex);
        }
        this.parser = parser == null ? new NoopCSSParser() : parser;
    }

    @Override
    public IToken getToken(@Nullable String type) {
        if (type == null || type.isEmpty()) {
            return DEFAULT_TOKEN;
        }
        return this.getTokenReturnValueCache.computeIfAbsent(type, this::getTokenInternal);
    }

    private IToken getTokenInternal(String type) {
        IStyle style = this.parser.getBestStyle(StringUtils.splitToArray((String)type, (char)'.'));
        if (style == null) {
            return DEFAULT_TOKEN;
        }
        IToken token = this.tokenMaps.get(style);
        return token == null ? DEFAULT_TOKEN : token;
    }

    private @Nullable Color getColor(boolean isForeground, String ... styles) {
        RGB rgb;
        IStyle style = this.parser.getBestStyle(styles);
        if (style == null) {
            return null;
        }
        RGB rGB = rgb = isForeground ? style.getColor() : style.getBackgroundColor();
        if (rgb == null) {
            return null;
        }
        return ColorManager.getInstance().getColor(rgb);
    }

    @Override
    public @Nullable Color getEditorForeground() {
        return this.getColor(true, "editor");
    }

    @Override
    public @Nullable Color getEditorBackground() {
        return this.getColor(false, "editor");
    }

    @Override
    public @Nullable Color getEditorSelectionForeground() {
        return this.getColor(true, "editor", "selection");
    }

    @Override
    public @Nullable Color getEditorSelectionBackground() {
        return this.getColor(false, "editor", "selection");
    }

    @Override
    public @Nullable Color getEditorCurrentLineHighlight() {
        return this.getColor(false, "editor", "lineHighlight");
    }

    private static class NoopCSSParser
    extends CSSParser {
        private NoopCSSParser() {
        }

        public List<IStyle> getStyles() {
            return Collections.emptyList();
        }

        public @Nullable IStyle getBestStyle(String ... names) {
            return null;
        }
    }
}

