/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.RectangleFigure;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.handles.SideResizeHandle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.internal.swt.model.widgets.ITableColumnInfo;

public final class TableTableColumnSelectionEditPolicy
extends SelectionEditPolicy {
    private static final String REQ_RESIZE = "resize";
    private final ITableColumnInfo m_column;
    private Figure m_resizeFeedback;
    private TextFeedback m_textFeedback;

    public TableTableColumnSelectionEditPolicy(ITableColumnInfo column) {
        this.m_column = column;
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList handles = Lists.newArrayList();
        MoveHandle moveHandle = new MoveHandle(this.getHost());
        moveHandle.setForegroundColor(IColorConstants.red);
        handles.add(moveHandle);
        return handles;
    }

    protected List<Handle> createStaticHandles() {
        ArrayList handles = Lists.newArrayList();
        SideResizeHandle resizeHandle = new SideResizeHandle(this.getHost(), 4, 10, true);
        resizeHandle.setDragTrackerTool((Tool)new ResizeTracker((EditPart)this.getHost(), 16, (Object)REQ_RESIZE));
        handles.add(resizeHandle);
        return handles;
    }

    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == REQ_RESIZE;
    }

    public Command getCommand(Request request) {
        return this.getResizeCommand((ChangeBoundsRequest)request);
    }

    public void showSourceFeedback(Request request) {
        this.showResizeFeedback((ChangeBoundsRequest)request);
    }

    public void eraseSourceFeedback(Request request) {
        this.eraseResizeFeedback((ChangeBoundsRequest)request);
    }

    private Command getResizeCommand(ChangeBoundsRequest request) {
        final Rectangle newBounds = request.getTransformedRectangle(this.getHostFigure().getBounds());
        return new EditCommand(this.m_column){

            protected void executeEdit() throws Exception {
                TableTableColumnSelectionEditPolicy.this.m_column.setWidth(newBounds.width);
            }
        };
    }

    private void showResizeFeedback(ChangeBoundsRequest request) {
        if (this.m_resizeFeedback == null) {
            this.m_resizeFeedback = new RectangleFigure();
            this.m_resizeFeedback.setForegroundColor(IColorConstants.red);
            this.addFeedback(this.m_resizeFeedback);
            this.m_textFeedback = new TextFeedback(this.getFeedbackLayer());
            this.m_textFeedback.add();
        }
        Figure hostFigure = this.getHostFigure();
        Rectangle bounds = request.getTransformedRectangle(hostFigure.getBounds());
        FigureUtils.translateFigureToAbsolute((Figure)hostFigure, (Translatable)bounds.shrink(-1, -1));
        this.m_resizeFeedback.setBounds(bounds);
        this.m_textFeedback.setText(Integer.toString(bounds.width - 2));
        this.m_textFeedback.setLocation(request.getLocation().getTranslated(10, 10));
    }

    private void eraseResizeFeedback(ChangeBoundsRequest request) {
        this.removeFeedback(this.m_resizeFeedback);
        this.m_resizeFeedback = null;
        this.m_textFeedback.remove();
        this.m_textFeedback = null;
    }
}

