/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.style.StylePropertyEditor;
import org.eclipse.wb.internal.core.model.util.ExposeComponentSupport;
import org.eclipse.wb.internal.core.model.util.MorphingSupport;
import org.eclipse.wb.internal.core.model.util.RenameConvertSupport;
import org.eclipse.wb.internal.core.model.util.factory.FactoryActionsSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.WidgetInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.internal.swt.support.ContainerSupport;
import org.eclipse.wb.internal.swt.support.ControlSupport;
import org.eclipse.wb.internal.swt.support.CoordinateUtils;
import org.eclipse.wb.internal.swt.support.ToolkitSupport;
import org.eclipse.wb.os.OSSupportError;

public class ControlInfo
extends WidgetInfo
implements IControlInfo {
    public ControlInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    protected void initialize() throws Exception {
        super.initialize();
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (object == ControlInfo.this) {
                    ExposeComponentSupport.contribute((JavaInfo)ControlInfo.this, (IContributionManager)manager, (String)ModelMessages.ControlInfo_exposeText);
                    MorphingSupport.contribute((String)"org.eclipse.swt.widgets.Control", (JavaInfo)ControlInfo.this, (IContributionManager)manager);
                    FactoryActionsSupport.contribute((JavaInfo)ControlInfo.this, (IContributionManager)manager);
                    RenameConvertSupport.contribute(objects, (IContributionManager)manager);
                }
            }
        });
        StylePropertyEditor.configureContributeActions((JavaInfo)this);
    }

    protected final AbstractComponentInfo getParentComponent() {
        return (AbstractComponentInfo)this.getParent();
    }

    public void refresh_dispose() throws Exception {
        if (this.isRoot()) {
            ControlSupport.dispose(this.getObject());
        }
        super.refresh_dispose();
    }

    protected void refresh_afterCreate() throws Exception {
        this.setPreferredSize(ControlSupport.getPreferredSize(this.getObject()));
        super.refresh_afterCreate();
    }

    protected void refresh_fetch() throws Exception {
        ControlInfo.refresh_fetch(this, new RunnableEx(){

            public void run() throws Exception {
                ControlInfo.super.refresh_fetch();
            }
        });
    }

    protected final Image getLiveImage() {
        return this.getLiveComponentsManager().getImage();
    }

    protected final int getLiveBaseline() {
        return this.getLiveComponentsManager().getBaseline();
    }

    public static void refresh_fetch(AbstractComponentInfo component, RunnableEx superRefreshFetch) throws Exception {
        Object control = component.getComponentObject();
        ControlInfo.refresh_fetch(component, control, superRefreshFetch);
    }

    public static void refresh_fetch(AbstractComponentInfo component, Object control, RunnableEx superRefreshFetch) throws Exception {
        boolean wasOSSupportError = false;
        try {
            try {
                if (component.isRoot()) {
                    ToolkitSupport.beginShot(control);
                    ControlInfo.createShotImages(component, control);
                }
                Rectangle modelBounds = ControlSupport.getBounds(control);
                component.setModelBounds(modelBounds);
                Rectangle bounds = modelBounds.getCopy();
                if (component.getParent() instanceof AbstractComponentInfo) {
                    AbstractComponentInfo parent = (AbstractComponentInfo)component.getParent();
                    Object parentControl = parent.getComponentObject();
                    if (control != parentControl) {
                        Point controlLocation = CoordinateUtils.getDisplayLocation(control);
                        Point parentLocation = CoordinateUtils.getDisplayLocation(parentControl);
                        bounds.x = controlLocation.x - parentLocation.x;
                        bounds.y = controlLocation.y - parentLocation.y;
                        if (ContainerSupport.isComposite(parentControl) && ContainerSupport.isRTL(parentControl)) {
                            if (ContainerSupport.isRTL(ControlSupport.getParent(parentControl))) {
                                bounds.x += ControlSupport.getBounds((Object)parentControl).width;
                            }
                            bounds.x -= bounds.width;
                        }
                    } else {
                        bounds.x = 0;
                        bounds.y = 0;
                    }
                }
                component.setBounds(bounds);
                if (ContainerSupport.isComposite(control)) {
                    component.setClientAreaInsets(CoordinateUtils.getClientAreaInsets(control));
                }
                if (superRefreshFetch != null) {
                    superRefreshFetch.run();
                }
            }
            catch (OSSupportError e) {
                wasOSSupportError = true;
                throw e;
            }
        }
        finally {
            if (component.isRoot() && !wasOSSupportError) {
                ToolkitSupport.endShot(control);
            }
        }
    }

    private static void createShotImages(AbstractComponentInfo root, Object control) throws Exception {
        root.accept(new ObjectInfoVisitor(){

            /*
             * WARNING - void declaration
             */
            public void endVisit(ObjectInfo objectInfo) throws Exception {
                ObjectInfo objectInfo2 = objectInfo;
                if (objectInfo2 instanceof AbstractComponentInfo) {
                    void componentInfo;
                    AbstractComponentInfo abstractComponentInfo = (AbstractComponentInfo)objectInfo2;
                    AbstractComponentInfo cfr_ignored_0 = (AbstractComponentInfo)objectInfo2;
                    Object componentObject = componentInfo.getComponentObject();
                    if (ControlSupport.isControl(componentObject)) {
                        ToolkitSupport.markAsNeededImage(componentObject);
                    }
                }
            }
        });
        ToolkitSupport.makeShots(control);
        root.accept(new ObjectInfoVisitor(){

            /*
             * WARNING - void declaration
             */
            public void endVisit(ObjectInfo objectInfo) throws Exception {
                ObjectInfo objectInfo2 = objectInfo;
                if (objectInfo2 instanceof AbstractComponentInfo) {
                    void componentInfo;
                    AbstractComponentInfo abstractComponentInfo = (AbstractComponentInfo)objectInfo2;
                    AbstractComponentInfo cfr_ignored_0 = (AbstractComponentInfo)objectInfo2;
                    Object componentObject = componentInfo.getComponentObject();
                    if (ControlSupport.isControl(componentObject)) {
                        Image image = ToolkitSupport.getShotImage(componentObject);
                        componentInfo.setImage(image);
                    }
                }
            }
        });
    }

    protected List<Property> getPropertyList() throws Exception {
        List properties = super.getPropertyList();
        StylePropertyEditor.addStyleProperties((List)properties);
        return properties;
    }

    public void command_CREATE(MenuInfo menu) throws Exception {
        menu.command_CREATE(this);
    }

    public void command_ADD(MenuInfo menu) throws Exception {
        menu.command_ADD(this);
    }
}

