/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.wizards;

import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.generator.BaseGenerator;
import org.eclipse.wst.wsdl.internal.generator.BindingGenerator;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtension;
import org.eclipse.wst.wsdl.ui.internal.dialogs.ProtocolComponentControl;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.CreateWSDLElementHelper;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.wizards.ContentGeneratorOptionsPage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BindingWizard
extends Wizard {
    protected BindingGenerator bindingGenerator;
    protected BindingWizardOptionsPage specifyBindingPage;
    protected Document document;
    protected int kind;
    public static final int KIND_NEW_BINDING = 1;
    public static final int KIND_REGENERATE_BINDING = 2;
    protected Definition definition;

    public BindingWizard(Definition definition) {
        this(definition, null, 1);
    }

    public BindingWizard(Definition definition, Document document) {
        this(definition, null, 1);
        this.document = document;
    }

    public BindingWizard(Definition definition, Binding binding, int kind) {
        this.definition = definition;
        this.kind = kind;
        this.bindingGenerator = new BindingGenerator(definition, binding);
        this.setWindowTitle(Messages._UI_BINDING_WIZARD);
    }

    public void setBindingName(String bindingName) {
        this.bindingGenerator.setName(bindingName);
    }

    public void setPortTypeName(String portTypeName) {
        this.bindingGenerator.setRefName(portTypeName);
    }

    public BindingGenerator getBindingGenerator() {
        return this.bindingGenerator;
    }

    public boolean setup() {
        return true;
    }

    public void addPages() {
        this.specifyBindingPage = new BindingWizardOptionsPage();
        this.addPage((IWizardPage)this.specifyBindingPage);
    }

    public boolean performFinish() {
        boolean recordingStarted = false;
        if (this.definition.getElement() == null || this.document != null && this.document.getChildNodes().getLength() == 0) {
            recordingStarted = true;
            this.beginRecording();
            Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
            String charSet = preference.getString("outputCodeset");
            if (charSet == null || charSet.trim().equals("")) {
                charSet = "UTF-8";
            }
            this.document.appendChild(this.document.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"" + charSet + "\""));
            Element root = this.document.createElement("wsdl:definitions");
            this.document.appendChild(root);
            root.setAttribute("xmlns:soap", "http://schemas.xmlsoap.org/wsdl/soap/");
            root.setAttribute("xmlns:tns", this.getDefaultNamespace(this.definition));
            root.setAttribute("xmlns:wsdl", "http://schemas.xmlsoap.org/wsdl/");
            root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            root.setAttribute("name", this.getFileName(this.definition));
            root.setAttribute("targetNamespace", this.getDefaultNamespace(this.definition));
            this.definition.setElement(root);
        }
        try {
            try {
                IEditorPart editorPart;
                ISelectionProvider selectionProvider;
                CreateWSDLElementHelper.addRequiredNamespaces(this.bindingGenerator.getContentGenerator(), this.definition);
                Binding binding = this.bindingGenerator.generateBinding();
                if (binding != null && (selectionProvider = (ISelectionProvider)(editorPart = WSDLEditorPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getAdapter(ISelectionProvider.class)) != null) {
                    selectionProvider.setSelection((ISelection)new StructuredSelection((Object)binding));
                }
            }
            catch (Exception exception) {
                if (recordingStarted) {
                    this.endRecording();
                }
            }
        }
        finally {
            if (recordingStarted) {
                this.endRecording();
            }
        }
        return true;
    }

    private String getDefaultNamespace(Definition definition) {
        String namespace = WSDLEditorPlugin.getInstance().getPreferenceStore().getString("defaultNamespace");
        if (!namespace.endsWith("/")) {
            namespace = namespace.concat("/");
        }
        namespace = String.valueOf(namespace) + this.getFileName(definition) + "/";
        return namespace;
    }

    private String getFileName(Definition definition) {
        String fileLocation = definition.getLocation();
        Path filePath = new Path(fileLocation);
        return filePath.removeFileExtension().lastSegment().toString();
    }

    private void beginRecording() {
        Document node = this.document;
        if (node instanceof IDOMNode) {
            ((IDOMNode)node).getModel().beginRecording((Object)this, Messages._UI_ACTION_ADD_BINDING);
        }
    }

    private void endRecording() {
        Document node = this.document;
        if (node instanceof IDOMNode) {
            ((IDOMNode)node).getModel().endRecording((Object)this);
        }
    }

    public static class BindingProtocolComponentControl
    extends ProtocolComponentControl {
        public BindingProtocolComponentControl(Composite parent, BindingGenerator generator) {
            this(parent, generator, true);
        }

        public BindingProtocolComponentControl(Composite parent, BindingGenerator generator, boolean showOverwriteButton) {
            super(parent, (BaseGenerator)generator, showOverwriteButton);
            if (generator.getName() != null) {
                this.componentNameField.setEditable(false);
            }
        }

        @Override
        public String getRefNameLabelText() {
            return Messages._UI_PORT_TYPE;
        }

        @Override
        public List getRefNames() {
            return new ComponentReferenceUtil(this.generator.getDefinition()).getPortTypeNames();
        }

        @Override
        public String getDefaultName() {
            String bindingName = this.generator.getName();
            return bindingName != null ? bindingName : NameUtil.buildUniqueBindingName(this.generator.getDefinition(), null);
        }

        @Override
        public ContentGeneratorOptionsPage createContentGeneratorOptionsPage(String protocol) {
            ContentGeneratorUIExtension extension = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry().getExtensionForLabel(protocol);
            if (extension != null) {
                return extension.getBindingContentGeneratorOptionsPage();
            }
            return null;
        }
    }

    class BindingWizardOptionsPage
    extends WizardPage {
        protected ProtocolComponentControl protocolComponentControl;

        public BindingWizardOptionsPage() {
            super("SpecifyBindingPage");
            this.setTitle(Messages._UI_TITLE_SPECIFY_BINDING_DETAILS);
            this.setDescription(Messages._UI_SPECIFY_BINDING_DETAILS_LABEL);
        }

        protected BindingGenerator getBindingGenerator() {
            return ((BindingWizard)this.getWizard()).getBindingGenerator();
        }

        public void createControl(Composite parent) {
            BindingProtocolComponentControl protocolComponentControl = new BindingProtocolComponentControl(parent, BindingWizard.this.bindingGenerator, true);
            protocolComponentControl.initFields();
            this.setControl((Control)protocolComponentControl);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)protocolComponentControl, ASDEditorCSHelpIds.BINDING_WIZARD);
        }
    }
}

