/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring.importer;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.imports.ImportOrganizer;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.ui.document.DocumentRewriter;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;
import org.eclipse.xtext.xbase.ui.refactoring.ExpressionUtil;
import org.eclipse.xtext.xbase.ui.refactoring.RefactoredResourceCopier;

public abstract class AbstractStaticMethodImporter {
    @Inject
    @Extension
    protected ExpressionUtil expressionUtil;
    @Inject
    @Extension
    protected ReplaceConverter replaceConverter;
    @Inject
    @Extension
    protected RefactoredResourceCopier resourceCopier;
    @Inject
    protected DocumentRewriter.Factory rewriterFactory;
    @Inject
    protected XtendGrammarAccess grammar;
    @Inject
    protected ImportOrganizer importOrganizer;

    protected boolean useExtension() {
        return false;
    }

    protected abstract void computeChange(XMemberFeatureCall var1, DocumentRewriter var2);

    protected void computeChanges(List<XMemberFeatureCall> calls, DocumentRewriter rewriter) {
        Consumer<XMemberFeatureCall> _function = it -> this.computeChange((XMemberFeatureCall)it, rewriter);
        calls.forEach(_function);
    }

    public boolean importStaticMethod(IXtextDocument document, ITextSelection selection) {
        try {
            XMemberFeatureCall call;
            boolean _xblockexpression = false;
            IUnitOfWork _function = it -> this.resourceCopier.loadIntoNewResourceSet(it);
            XtextResource resource = (XtextResource)document.priorityReadOnly(_function);
            XExpression expression = this.expressionUtil.findSelectedExpression(resource, selection);
            if (expression instanceof XMemberFeatureCall && (call = (XMemberFeatureCall)expression).isStatic() && !call.isExtension()) {
                Pair<String, String> toImport = this.computeImport(call);
                Functions.Function1 _function_1 = it -> Objects.equal((Object)call.getFeature(), (Object)it.getFeature()) && !it.isExtension();
                Functions.Function1 _function_2 = it -> it != call;
                List calls = IterableExtensions.sortBy((Iterable)IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)resource.getAllContents(), XMemberFeatureCall.class), (Functions.Function1)_function_1)), (Functions.Function1)_function_2);
                DocumentRewriter documentRewriter = this.rewriterFactory.create(document, resource);
                DocumentRewriteSession _xifexpression = null;
                if (document instanceof IDocumentExtension4) {
                    _xifexpression = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                }
                DocumentRewriteSession rewriteSession = _xifexpression;
                RewritableImportSection _importSection = documentRewriter.newSection(0, 0).getImportSection();
                Procedures.Procedure1 _function_3 = it -> {
                    boolean _useExtension = this.useExtension();
                    if (_useExtension) {
                        it.addStaticExtensionImport((String)toImport.getKey(), (String)toImport.getValue());
                    } else {
                        it.addStaticImport((String)toImport.getKey(), (String)toImport.getValue());
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_importSection, (Procedures.Procedure1)_function_3);
                this.computeChanges(calls, documentRewriter);
                List changes = documentRewriter.getChanges();
                TextEdit _convertToTextEdit = this.replaceConverter.convertToTextEdit(changes);
                if (_convertToTextEdit != null) {
                    _convertToTextEdit.apply((IDocument)document);
                }
                IUnitOfWork _function_4 = it -> this.resourceCopier.loadIntoNewResourceSet(it);
                List _organizedImportChanges = this.importOrganizer.getOrganizedImportChanges((XtextResource)document.priorityReadOnly(_function_4));
                TextEdit _convertToTextEdit_1 = null;
                if (_organizedImportChanges != null) {
                    _convertToTextEdit_1 = this.replaceConverter.convertToTextEdit(_organizedImportChanges);
                }
                if (_convertToTextEdit_1 != null) {
                    _convertToTextEdit_1.apply((IDocument)document);
                }
                if (rewriteSession != null) {
                    ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
                }
            }
            _xblockexpression = false;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Pair<String, String> computeImport(XMemberFeatureCall call) {
        EObject _eContainer = call.getFeature().eContainer();
        String _identifier = ((JvmGenericType)_eContainer).getIdentifier();
        String _simpleName = call.getFeature().getSimpleName();
        return Pair.of((Object)_identifier, (Object)_simpleName);
    }
}

