/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;

public class Resources {
    public static Map<URL, InputStream> getAsInputStreams(String resourceRelativePath, ClassLoader ... resourceClassLoaders) throws IOException {
        if (resourceClassLoaders == null || resourceClassLoaders.length == 0) {
            resourceClassLoaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader()};
        }
        LinkedHashMap<URL, InputStream> streams = new LinkedHashMap<URL, InputStream>();
        for (ClassLoader classLoader : resourceClassLoaders) {
            Enumeration<URL> resources = classLoader.getResources(resourceRelativePath);
            while (resources.hasMoreElements()) {
                URL resourceURL = resources.nextElement();
                streams.put(resourceURL, resourceURL.openStream());
            }
        }
        return streams;
    }
}

