/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.datamodel;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.IDMContext;

public class DMContexts {
    public static final IDMContext[] EMPTY_CONTEXTS_ARRAY = new IDMContext[0];

    @ThreadSafe
    public static <V extends IDMContext> V getAncestorOfType(IDMContext ctx, Class<V> ancestorType) {
        if (ctx == null) {
            return null;
        }
        if (ancestorType.isAssignableFrom(ctx.getClass())) {
            return (V)ctx;
        }
        LinkedHashSet<IDMContext> nodes = new LinkedHashSet<IDMContext>();
        nodes.addAll(Arrays.asList(ctx.getParents()));
        while (!nodes.isEmpty()) {
            LinkedHashSet<IDMContext> parents = nodes;
            nodes = new LinkedHashSet();
            for (IDMContext parent : parents) {
                if (ancestorType.isAssignableFrom(parent.getClass())) {
                    return (V)parent;
                }
                nodes.addAll(Arrays.asList(parent.getParents()));
            }
        }
        return null;
    }

    @ThreadSafe
    public static <V extends IDMContext> V getTopMostAncestorOfType(IDMContext ctx, Class<V> ancestorType) {
        if (ctx == null) {
            return null;
        }
        IDMContext topMostAncestor = null;
        boolean hasAncestorOfType = false;
        IDMContext current = ctx;
        do {
            IDMContext[] parents;
            hasAncestorOfType = false;
            IDMContext[] iDMContextArray = parents = current.getParents();
            int n = parents.length;
            int n2 = 0;
            while (n2 < n) {
                IDMContext parent = iDMContextArray[n2];
                if (ancestorType.isAssignableFrom(parent.getClass())) {
                    hasAncestorOfType = true;
                    topMostAncestor = parent;
                    current = parent;
                }
                ++n2;
            }
        } while (hasAncestorOfType);
        return (V)topMostAncestor;
    }

    @ThreadSafe
    public static <V extends IDMContext> V getParentOfType(IDMContext ctx, Class<V> ancestorType) {
        if (ctx == null) {
            return null;
        }
        IDMContext[] iDMContextArray = ctx.getParents();
        int n = iDMContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext parent = iDMContextArray[n2];
            if (ancestorType.isAssignableFrom(parent.getClass())) {
                return (V)parent;
            }
            ++n2;
        }
        return null;
    }

    @ThreadSafe
    public static <V extends IDMContext> V[] getAllAncestorsOfType(IDMContext ctx, Class<V> ancestorType) {
        if (ctx == null) {
            return null;
        }
        LinkedHashSet<IDMContext> requestedAncestors = new LinkedHashSet<IDMContext>();
        LinkedHashSet<IDMContext> nodes = new LinkedHashSet<IDMContext>();
        nodes.add(ctx);
        while (!nodes.isEmpty()) {
            LinkedHashSet<IDMContext> parents = nodes;
            nodes = new LinkedHashSet();
            for (IDMContext parent : parents) {
                if (ancestorType.isAssignableFrom(parent.getClass())) {
                    requestedAncestors.add(parent);
                }
                nodes.addAll(Arrays.asList(parent.getParents()));
            }
        }
        if (requestedAncestors.isEmpty()) {
            return null;
        }
        IDMContext[] v = (IDMContext[])Array.newInstance(ancestorType, 0);
        return requestedAncestors.toArray(v);
    }

    @ThreadSafe
    public static boolean isAncestorOf(IDMContext dmc, IDMContext potentialAncestor) {
        IDMContext parentDmc;
        IDMContext[] iDMContextArray = dmc.getParents();
        int n = iDMContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            parentDmc = iDMContextArray[n2];
            if (potentialAncestor.equals(parentDmc)) {
                return true;
            }
            ++n2;
        }
        iDMContextArray = dmc.getParents();
        n = iDMContextArray.length;
        n2 = 0;
        while (n2 < n) {
            parentDmc = iDMContextArray[n2];
            if (DMContexts.isAncestorOf(parentDmc, potentialAncestor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @ThreadSafe
    public static List<IDMContext> toList(IDMContext dmc) {
        ArrayList<IDMContext> list = new ArrayList<IDMContext>();
        list.add(dmc);
        IDMContext[] iDMContextArray = dmc.getParents();
        int n = iDMContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext parentDmc = iDMContextArray[n2];
            list.addAll(DMContexts.toList(parentDmc));
            ++n2;
        }
        return list;
    }
}

