/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.metatype.EquinoxMetaTypeInformation;
import org.eclipse.equinox.metatype.EquinoxMetaTypeService;
import org.eclipse.equinox.metatype.impl.LogTracker;
import org.eclipse.equinox.metatype.impl.MetaTypeInformationImpl;
import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.equinox.metatype.impl.MetaTypeProviderTracker;
import org.eclipse.equinox.metatype.impl.Persistence;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.SAXException;

public class MetaTypeServiceImpl
implements EquinoxMetaTypeService,
SynchronousBundleListener {
    private static String CACHE_FILE = "metaTypeCache";
    SAXParserFactory _parserFactory;
    private Hashtable<Long, EquinoxMetaTypeInformation> _mtps = new Hashtable(7);
    private final LogTracker logger;
    private final ServiceTracker<Object, Object> metaTypeProviderTracker;

    public MetaTypeServiceImpl(SAXParserFactory parserFactory, LogTracker logger, ServiceTracker<Object, Object> metaTypeProviderTracker) {
        this._parserFactory = parserFactory;
        this.logger = logger;
        this.metaTypeProviderTracker = metaTypeProviderTracker;
    }

    @Override
    public EquinoxMetaTypeInformation getMetaTypeInformation(Bundle bundle) {
        return this.getMetaTypeProvider(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EquinoxMetaTypeInformation getMetaTypeProvider(final Bundle b) {
        final LogTracker loggerTemp = this.logger;
        final ServiceTracker<Object, Object> tracker = this.metaTypeProviderTracker;
        Long bID = b.getBundleId();
        Hashtable<Long, EquinoxMetaTypeInformation> hashtable = this._mtps;
        synchronized (hashtable) {
            if (this._mtps.containsKey(bID)) {
                return this._mtps.get(bID);
            }
            EquinoxMetaTypeInformation mti = AccessController.doPrivileged(new PrivilegedAction<EquinoxMetaTypeInformation>(){

                @Override
                public EquinoxMetaTypeInformation run() {
                    MetaTypeInformationImpl impl = null;
                    try {
                        impl = new MetaTypeInformationImpl(b, MetaTypeServiceImpl.this.newParser(), loggerTemp);
                    }
                    catch (Exception e) {
                        loggerTemp.log(1, NLS.bind((String)MetaTypeMsg.METADATA_PARSE_ERROR, (Object)b.getBundleId(), (Object)b.getSymbolicName()), e);
                    }
                    if (impl == null || !impl._isThereMeta) {
                        return new MetaTypeProviderTracker(b, loggerTemp, (ServiceTracker<Object, Object>)tracker);
                    }
                    return impl;
                }
            });
            this._mtps.put(bID, mti);
            return mti;
        }
    }

    SAXParser newParser() throws ParserConfigurationException, SAXException {
        boolean namespaceAware = this._parserFactory.isNamespaceAware();
        boolean validating = this._parserFactory.isValidating();
        this._parserFactory.setValidating(false);
        try {
            if (namespaceAware) {
                SAXParser sAXParser = this._parserFactory.newSAXParser();
                return sAXParser;
            }
            this._parserFactory.setNamespaceAware(true);
            try {
                SAXParser sAXParser = this._parserFactory.newSAXParser();
                return sAXParser;
            }
            catch (Exception e) {
                this._parserFactory.setNamespaceAware(false);
                SAXParser sAXParser = this._parserFactory.newSAXParser();
                this._parserFactory.setNamespaceAware(namespaceAware);
                this._parserFactory.setValidating(validating);
                return sAXParser;
            }
        }
        finally {
            this._parserFactory.setNamespaceAware(namespaceAware);
            this._parserFactory.setValidating(validating);
        }
    }

    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Long bID = event.getBundle().getBundleId();
        switch (type) {
            case 8: 
            case 16: {
                this._mtps.remove(bID);
                break;
            }
        }
    }

    void load(BundleContext context, LogTracker log, ServiceTracker<Object, Object> tracker) throws IOException {
        File cache = context.getDataFile(CACHE_FILE);
        BundleContext systemContext = context.getBundle("System Bundle").getBundleContext();
        if (cache.isFile()) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (Persistence.Reader reader = new Persistence.Reader(new DataInputStream(new BufferedInputStream(new FileInputStream(cache))));){
                if (!reader.isValidPersistenceVersion()) {
                    this.logger.log(3, "Metatype cache version is not supported.  Ignoring cache.");
                    return;
                }
                int numService = reader.readInt();
                int i = 0;
                while (i < numService) {
                    long id = reader.readLong();
                    Bundle b = systemContext.getBundle(id);
                    if (b != null) {
                        this._mtps.put(b.getBundleId(), new MetaTypeProviderTracker(b, log, tracker));
                    }
                    ++i;
                }
                reader.readIndexedStrings();
                int numXML = reader.readInt();
                int i2 = 0;
                while (i2 < numXML) {
                    MetaTypeInformationImpl info = MetaTypeInformationImpl.load(systemContext, log, reader);
                    if (info != null) {
                        this._mtps.put(info.getBundle().getBundleId(), info);
                    }
                    ++i2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(BundleContext context) throws IOException {
        File cache = context.getDataFile(CACHE_FILE);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Persistence.Writer writer = new Persistence.Writer(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cache))));){
            writer.writePersistenceVersion();
            ArrayList<MetaTypeInformation> serviceInfos = new ArrayList<MetaTypeInformation>();
            ArrayList<MetaTypeInformationImpl> xmlInfos = new ArrayList<MetaTypeInformationImpl>();
            Hashtable<Long, EquinoxMetaTypeInformation> hashtable = this._mtps;
            synchronized (hashtable) {
                for (MetaTypeInformation metaTypeInformation : this._mtps.values()) {
                    if (metaTypeInformation instanceof MetaTypeInformationImpl) {
                        xmlInfos.add((MetaTypeInformationImpl)metaTypeInformation);
                        continue;
                    }
                    serviceInfos.add(metaTypeInformation);
                }
            }
            writer.writeInt(serviceInfos.size());
            for (MetaTypeInformation info : serviceInfos) {
                writer.writeLong(info.getBundle().getBundleId());
            }
            HashSet<String> strings = new HashSet<String>();
            for (MetaTypeInformationImpl metaTypeInformationImpl : xmlInfos) {
                metaTypeInformationImpl.getStrings(strings);
            }
            writer.writeIndexedStrings(strings);
            writer.writeInt(xmlInfos.size());
            for (MetaTypeInformationImpl metaTypeInformationImpl : xmlInfos) {
                metaTypeInformationImpl.write(writer);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

