/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.refactor;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarImpl;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactoringProperties;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public abstract class UpdateEJBClientRefOp
extends AbstractDataModelOperation
implements ProjectRefactoringProperties {
    protected IStatus updateEJBClientRef(IProgressMonitor monitor, boolean remove) throws ExecutionException {
        ProjectRefactorMetadata refactoredMetadata;
        ProjectRefactorMetadata dependentMetadata = (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.DEPENDENT_PROJECT_METADATA");
        ProjectRefactorMetadata originalMetadata = refactoredMetadata = (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.PROJECT_METADATA");
        if (!remove) {
            originalMetadata = (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.ORIGINAL_PROJECT_METADATA");
        }
        if (!dependentMetadata.isEJB() || !refactoredMetadata.isUtility()) {
            return Status.OK_STATUS;
        }
        String originalProjectName = originalMetadata.getProjectName();
        EJBArtifactEdit ejbEdit = null;
        try {
            EJBJarImpl ejbres;
            String ejbClientJar;
            ejbEdit = EJBArtifactEdit.getEJBArtifactEditForWrite(dependentMetadata.getProject());
            if (ejbEdit != null && (ejbClientJar = (ejbres = (EJBJarImpl)ejbEdit.getDeploymentDescriptorRoot()).getEjbClientJar()) != null && ejbClientJar.equals(String.valueOf(originalProjectName) + ".jar")) {
                if (remove) {
                    ejbres.setEjbClientJar(null);
                } else {
                    String newProjectName = refactoredMetadata.getProjectName();
                    ejbres.setEjbClientJar(String.valueOf(newProjectName) + ".jar");
                }
                ejbEdit.saveIfNecessary(monitor);
            }
        }
        finally {
            if (ejbEdit != null) {
                ejbEdit.dispose();
            }
        }
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite((IProject)dependentMetadata.getProject());
            if (core != null) {
                WorkbenchComponent component = core.getComponent();
                EList propList = component.getProperties();
                int i = 0;
                while (i < propList.size()) {
                    Property newProp;
                    Property prop = (Property)propList.get(i);
                    if (prop.getName().equals("ClientProject") && prop.getValue().equals(originalMetadata.getProjectName())) {
                        propList.remove(i);
                        if (!remove) {
                            newProp = ComponentcoreFactory.eINSTANCE.createProperty();
                            newProp.setName("ClientProject");
                            newProp.setValue(refactoredMetadata.getProjectName());
                            propList.add(0, newProp);
                        } else {
                            --i;
                        }
                    } else if (prop.getName().equals("ClientJARURI") && prop.getValue().equals(String.valueOf(originalMetadata.getProjectName()) + ".jar")) {
                        propList.remove(i);
                        if (!remove) {
                            newProp = ComponentcoreFactory.eINSTANCE.createProperty();
                            newProp.setName("ClientJARURI");
                            newProp.setValue(String.valueOf(refactoredMetadata.getProjectName()) + ".jar");
                            propList.add(0, newProp);
                        } else {
                            --i;
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }
}

