/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenEditorCommand
extends Command {
    private EditPart part;
    private static final Logger log = EditorPlugin.getLogger(FacesConfigEditor.class);

    public boolean canExecute() {
        return true;
    }

    public OpenEditorCommand(EditPart part) {
        super(PageflowMessages.Pageflow_Commands_OpenEditorCommand_Label);
        this.part = part;
    }

    private void executeOpenPFPage() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String pagePath = ((PageflowPage)this.part.getModel()).getPath();
        if (pagePath != null && pagePath.length() > 0) {
            String resourceName = WebrootUtil.getProjectPath((EObject)this.part.getModel(), pagePath);
            Path resourcePath = new Path(resourceName);
            if (resourcePath.getFileExtension() != null) {
                IFile file = (IFile)workspaceRoot.findMember((IPath)resourcePath);
                this.openExistingJSFFile(file);
            } else {
                EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFTitle", "Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFFolderInfo");
            }
        } else {
            EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFTitle", "Pageflow.PageflowEditor.Alert.confirmCreateNewJSFFile");
        }
    }

    private void openExistingJSFFile(final IFile file) {
        if (file != null && file.exists()) {
            Display display = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IDE.setDefaultEditor((IFile)file, null);
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
                        page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId(), true, 3);
                    }
                    catch (PartInitException e) {
                        log.error("Pageflow.PageflowEditor.Error.canNotOpenEditor4JSF", (Throwable)e);
                        EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFTitle", "Pageflow.PageflowEditor.Error.CanNotOpenEditor4JSF");
                    }
                }
            });
        } else {
            String pagePath = ((PageflowPage)this.part.getModel()).getPath();
            EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFTitle", "Pageflow.PageflowEditor.Alert.errorOpenEditor4JSFInfo", (Object)pagePath);
        }
    }

    public void execute() {
        if (this.part.getModel() instanceof PageflowPage) {
            this.executeOpenPFPage();
        }
    }
}

