/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchScope;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.java.refactoring.BasicRefactorSearchRequestor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public abstract class JSPRenameParticipant
extends RenameParticipant
implements ISharableParticipant {
    protected String fName;
    private Map fElementAndArgumentPairs;
    private Map fLocalTextChanges;

    public boolean initialize(RefactoringProcessor processor, Object element, RefactoringArguments arguments) {
        this.fElementAndArgumentPairs = new HashMap();
        this.addElement(element, arguments);
        this.fLocalTextChanges = new HashMap();
        this.fName = "";
        return super.initialize(processor, element, arguments);
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        String elementName;
        if (element instanceof IJavaElement && this.isLegalElementType((IJavaElement)element) && arguments instanceof RenameArguments && !this.fElementAndArgumentPairs.containsKey(elementName = ((IJavaElement)element).getElementName())) {
            this.fElementAndArgumentPairs.put(elementName, new ElementAndArgumentsPair((IJavaElement)element, (RenameArguments)arguments));
        }
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        this.getTextChange("");
        CompositeChange multiChange = new CompositeChange(JSPUIMessages.JSP_changes);
        for (ElementAndArgumentsPair elemArgsPair : this.fElementAndArgumentPairs.values()) {
            Change[] changes = this.createChangesFor(elemArgsPair.fElement, elemArgsPair.fArgs.getNewName(), pm);
            int i = 0;
            while (i < changes.length) {
                if (changes[i] instanceof TextChange) {
                    this.fLocalTextChanges.put(((TextChange)changes[i]).getModifiedElement(), changes[i]);
                }
                ++i;
            }
            if (changes.length <= 0) continue;
            multiChange.addAll(changes);
        }
        CompositeChange result = null;
        if (multiChange.getChildren().length > 0) {
            result = multiChange;
        }
        return result;
    }

    public String getName() {
        return this.fName;
    }

    public TextChange getTextChange(Object element) {
        TextChange existingChange = (TextChange)this.fLocalTextChanges.get(element);
        if (existingChange == null) {
            existingChange = super.getTextChange(element);
        }
        return existingChange;
    }

    protected Change[] createChangesFor(IJavaElement element, String newName, IProgressMonitor monitor) {
        Change[] changes;
        BasicRefactorSearchRequestor requestor = this.getSearchRequestor(element, newName);
        if (requestor != null) {
            JSPSearchSupport support = JSPSearchSupport.getInstance();
            support.searchRunnable(element, (IJavaSearchScope)new JSPSearchScope(), (SearchRequestor)requestor, monitor);
            changes = requestor.getChanges((RefactoringParticipant)this);
        } else {
            changes = new Change[]{};
        }
        return changes;
    }

    protected abstract BasicRefactorSearchRequestor getSearchRequestor(IJavaElement var1, String var2);

    protected abstract boolean isLegalElementType(IJavaElement var1);

    private class ElementAndArgumentsPair {
        protected IJavaElement fElement;
        protected RenameArguments fArgs;

        public ElementAndArgumentsPair(IJavaElement element, RenameArguments args) {
            this.fElement = element;
            this.fArgs = args;
        }
    }
}

