/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.commands.BaseImagesCommandHandler;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RemoveImagesCommandHandler
extends BaseImagesCommandHandler {
    private static final String IMAGES_DELETE_MSG = "ImagesRemove.msg";
    private static final String IMAGE_DELETE_MSG = "ImageRemove.msg";
    private static final String IMAGE_DELETE_ERROR_MSG = "ImageRemoveError.msg";
    private static final String IMAGE_DELETE_CONFIRM = "ImageDeleteConfirm.msg";
    private static final String IMAGE_DELETE_LIST = "ImageDeleteList.msg";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeInJob(IDockerImage image, IDockerConnection connection) {
        try {
            connection.removeImage(image.id());
        }
        catch (InterruptedException | DockerException e) {
            if (!image.isDangling() && !image.isIntermediateImage()) {
                String errorMessage = DVMessages.getFormattedString(IMAGE_DELETE_ERROR_MSG, (String)image.repoTags().get(0));
                this.openError(errorMessage, (Exception)e);
            } else {
                String errorMessage = DVMessages.getFormattedString(IMAGE_DELETE_ERROR_MSG, image.id().substring(0, 8));
                this.openError(errorMessage, (Exception)e);
            }
        }
        finally {
            connection.getImages(true);
        }
    }

    @Override
    String getJobName(List<IDockerImage> selectedImages) {
        return DVMessages.getString(IMAGES_DELETE_MSG);
    }

    @Override
    String getTaskName(IDockerImage image) {
        if (!image.isDangling() && !image.isIntermediateImage()) {
            return DVMessages.getFormattedString(IMAGE_DELETE_MSG, (String)image.repoTags().get(0));
        }
        return DVMessages.getFormattedString(IMAGE_DELETE_MSG, image.id().substring(0, 8));
    }

    @Override
    boolean confirmed(List<IDockerImage> selectedImages) {
        ArrayList<String> imagesToRemove = new ArrayList<String>();
        for (IDockerImage image : selectedImages) {
            if (!image.isDangling() && !image.isIntermediateImage()) {
                imagesToRemove.add((String)image.repoTags().get(0));
                continue;
            }
            imagesToRemove.add(image.id().substring(0, 8));
        }
        ArrayList<String> names = imagesToRemove;
        DialogResponse response = new DialogResponse();
        Display.getDefault().syncExec(() -> {
            boolean result = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(IMAGE_DELETE_CONFIRM), (String)DVMessages.getFormattedString(IMAGE_DELETE_LIST, names.toString()));
            response.setResponse(result);
        });
        return response.getResponse();
    }

    private class DialogResponse {
        private boolean response;

        private DialogResponse() {
        }

        public boolean getResponse() {
            return this.response;
        }

        public void setResponse(boolean value) {
            this.response = value;
        }
    }
}

