/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerNetworkSettings;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerPortMapping;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.swt.widgets.Display;

public class DockerExplorerContentProvider
implements ITreeContentProvider {
    private final Object[] EMPTY = new Object[0];
    private Map<IDockerConnection, Job> openRetryJobs = new HashMap<IDockerConnection, Job>();
    private TreeViewer viewer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<Job> jobs = Collections.emptyList();
        Map<IDockerConnection, Job> map = this.openRetryJobs;
        synchronized (map) {
            jobs = new ArrayList<Job>(this.openRetryJobs.values());
        }
        for (Job job : jobs) {
            LoadingJob loadingJob = (LoadingJob)job;
            IProgressMonitor monitor = loadingJob.getMonitor();
            monitor.setCanceled(true);
            job.cancel();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof DockerConnectionManager) {
            DockerConnectionManager connectionManager = (DockerConnectionManager)inputElement;
            return connectionManager.getConnections();
        }
        return this.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IDockerConnection) {
            IDockerConnection connection = (IDockerConnection)parentElement;
            if (connection.isOpen()) {
                return new Object[]{new DockerImagesCategory(connection), new DockerContainersCategory(connection)};
            }
            if (connection.getState() == EnumDockerConnectionState.UNKNOWN) {
                this.open(connection);
                return new Object[]{new LoadingStub(connection)};
            }
            if (connection.getState() == EnumDockerConnectionState.CLOSED) {
                Map<IDockerConnection, Job> map = this.openRetryJobs;
                synchronized (map) {
                    Job job = this.openRetryJobs.get(connection);
                    if (job == null) {
                        this.openRetry(connection);
                    }
                }
                return new Object[]{new LoadingStub(connection)};
            }
            return new Object[0];
        }
        if (parentElement instanceof DockerContainersCategory) {
            DockerContainersCategory containersCategory = (DockerContainersCategory)parentElement;
            IDockerConnection connection = containersCategory.getConnection();
            if (connection.isContainersLoaded()) {
                return connection.getContainers().toArray();
            }
            this.loadContainers(containersCategory);
            return new Object[]{new LoadingStub(containersCategory)};
        }
        if (parentElement instanceof DockerImagesCategory) {
            DockerImagesCategory imagesCategory = (DockerImagesCategory)parentElement;
            IDockerConnection connection = imagesCategory.getConnection();
            if (connection.isImagesLoaded()) {
                List allImages = connection.getImages();
                List<IDockerImage> explorerImages = DockerExplorerContentProvider.splitImageTagsByRepo(allImages);
                return explorerImages.toArray();
            }
            this.loadImages(imagesCategory);
            return new Object[]{new LoadingStub(imagesCategory)};
        }
        if (parentElement instanceof IDockerContainer) {
            DockerContainer container = (DockerContainer)parentElement;
            if (container.isInfoLoaded()) {
                IDockerContainerInfo info = container.info();
                IDockerNetworkSettings networkSettings = info != null ? info.networkSettings() : null;
                IDockerHostConfig hostConfig = info != null ? info.hostConfig() : null;
                return new Object[]{new DockerContainerPortMappingsCategory((IDockerContainer)container, networkSettings != null ? networkSettings.ports() : Collections.emptyMap()), new DockerContainerVolumesCategory((IDockerContainer)container, hostConfig != null ? hostConfig.binds() : Collections.emptyList()), new DockerContainerLinksCategory((IDockerContainer)container, hostConfig != null ? hostConfig.links() : Collections.emptyList())};
            }
            this.loadContainerInfo((IDockerContainer)container);
            return new Object[]{new LoadingStub(container)};
        }
        if (parentElement instanceof DockerContainerLinksCategory) {
            DockerContainerLinksCategory linksCategory = (DockerContainerLinksCategory)parentElement;
            return linksCategory.getLinks().toArray();
        }
        if (parentElement instanceof DockerContainerPortMappingsCategory) {
            DockerContainerPortMappingsCategory portMappingsCategory = (DockerContainerPortMappingsCategory)parentElement;
            return portMappingsCategory.getPortMappings().toArray();
        }
        if (parentElement instanceof DockerContainerVolumesCategory) {
            DockerContainerVolumesCategory volumesCategory = (DockerContainerVolumesCategory)parentElement;
            return volumesCategory.getVolumes().toArray();
        }
        return this.EMPTY;
    }

    public static List<IDockerImage> splitImageTagsByRepo(List<IDockerImage> images) {
        return images.stream().flatMap(image -> DockerImage.duplicateImageByRepo((IDockerImage)image)).toList();
    }

    private void open(final IDockerConnection connection) {
        LoadingJob pingJob = new LoadingJob(DVMessages.getString("PingJob.msg"), connection){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    connection.open(true);
                    connection.ping();
                    return Status.OK_STATUS;
                }
                catch (DockerException e) {
                    Activator.logWarningMessage(DVMessages.getFormattedString("PingJobError.msg.withExplanation", connection.getName(), e.getMessage()));
                    return Status.CANCEL_STATUS;
                }
            }
        };
        pingJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openRetry(final IDockerConnection connection) {
        LoadingJob openRetryJob = new LoadingJob(DVMessages.getFormattedString("PingJob2.msg", connection.getName(), connection.getUri()), connection){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                this.setMonitor(monitor);
                long totalSleep = 0L;
                long sleepTime = 3000L;
                while (true) {
                    try {
                        if (monitor.isCanceled() || DockerConnectionManager.getInstance().getConnectionByUri(connection.getUri()) == null) {
                            Map<IDockerConnection, Job> map = DockerExplorerContentProvider.this.openRetryJobs;
                            synchronized (map) {
                                DockerExplorerContentProvider.this.openRetryJobs.remove(connection);
                            }
                            return Status.CANCEL_STATUS;
                        }
                        connection.open(true);
                        connection.ping();
                        Map<IDockerConnection, Job> map = DockerExplorerContentProvider.this.openRetryJobs;
                        synchronized (map) {
                            DockerExplorerContentProvider.this.openRetryJobs.remove(connection);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (DockerException dockerException) {
                        try {
                            Thread.sleep(sleepTime);
                            if ((totalSleep += sleepTime) <= 300000L) continue;
                            totalSleep = 0L;
                            sleepTime = Platform.getPreferencesService().getLong("org.eclipse.linuxtools.docker.ui", "containerRefreshTime", 15000L, null);
                        }
                        catch (InterruptedException e) {
                            Map<IDockerConnection, Job> map = DockerExplorerContentProvider.this.openRetryJobs;
                            synchronized (map) {
                                DockerExplorerContentProvider.this.openRetryJobs.remove(connection);
                            }
                            return Status.CANCEL_STATUS;
                        }
                    }
                }
            }
        };
        Map<IDockerConnection, Job> map = this.openRetryJobs;
        synchronized (map) {
            this.openRetryJobs.put(connection, openRetryJob);
        }
        openRetryJob.setSystem(true);
        openRetryJob.schedule();
    }

    private void loadContainers(final DockerContainersCategory containersCategory) {
        LoadingJob loadContainersJob = new LoadingJob(DVMessages.getString("ContainersLoadJob.msg"), containersCategory){

            protected IStatus run(IProgressMonitor monitor) {
                containersCategory.getConnection().getContainers(true);
                return Status.OK_STATUS;
            }
        };
        loadContainersJob.schedule();
    }

    private void loadContainerInfo(final IDockerContainer container) {
        LoadingJob loadContainersJob = new LoadingJob(DVMessages.getString("ContainerInfoLoadJob.msg"), container){

            protected IStatus run(IProgressMonitor monitor) {
                ((DockerContainer)container).info(true);
                return Status.OK_STATUS;
            }
        };
        loadContainersJob.schedule();
    }

    private void loadImages(final DockerImagesCategory imagesCategory) {
        LoadingJob loadImagesJob = new LoadingJob(DVMessages.getString("ImagesLoadJob.msg"), imagesCategory){

            protected IStatus run(IProgressMonitor monitor) {
                imagesCategory.getConnection().getImages(true);
                return Status.OK_STATUS;
            }
        };
        loadImagesJob.schedule();
    }

    public Object getParent(Object element) {
        if (element instanceof DockerImagesCategory) {
            return ((DockerImagesCategory)element).getConnection();
        }
        if (element instanceof DockerContainersCategory) {
            return ((DockerContainersCategory)element).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren(Object element) {
        IDockerConnection connection;
        if (element instanceof IDockerConnection && (connection = (IDockerConnection)element).getState() != EnumDockerConnectionState.ESTABLISHED) {
            Job openRetryJob = null;
            Map<IDockerConnection, Job> map = this.openRetryJobs;
            synchronized (map) {
                openRetryJob = this.openRetryJobs.get(connection);
            }
            if (openRetryJob == null) {
                this.openRetry(connection);
            }
        }
        return element instanceof IDockerConnection || element instanceof DockerContainersCategory || element instanceof DockerImagesCategory || element instanceof IDockerContainer || element instanceof DockerContainerLinksCategory && !((DockerContainerLinksCategory)element).getLinks().isEmpty() || element instanceof DockerContainerPortMappingsCategory && !((DockerContainerPortMappingsCategory)element).getPortMappings().isEmpty() || element instanceof DockerContainerVolumesCategory && !((DockerContainerVolumesCategory)element).getVolumes().isEmpty();
    }

    private abstract class LoadingJob
    extends Job {
        private IProgressMonitor monitor;

        public LoadingJob(String name, final Object target) {
            super(name);
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    LoadingJob.this.refreshTarget(target);
                }
            });
        }

        public IProgressMonitor getMonitor() {
            return this.monitor;
        }

        public void setMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean belongsTo(Object family) {
            return DockerExplorerView.class.equals(family);
        }

        private void refreshTarget(Object target) {
            Display.getDefault().asyncExec(() -> {
                if (DockerExplorerContentProvider.this.viewer != null && !DockerExplorerContentProvider.this.viewer.getControl().isDisposed()) {
                    TreePath[] treePaths = DockerExplorerContentProvider.this.viewer.getExpandedTreePaths();
                    DockerExplorerContentProvider.this.viewer.refresh(target, true);
                    DockerExplorerContentProvider.this.viewer.setExpandedTreePaths(treePaths);
                }
            });
        }
    }

    public static class DockerImagesCategory
    implements IAdaptable {
        private final IDockerConnection connection;

        public DockerImagesCategory(IDockerConnection connection) {
            this.connection = connection;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.equals(IDockerConnection.class)) {
                return (T)this.getConnection();
            }
            return null;
        }

        public IDockerConnection getConnection() {
            return this.connection;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerImagesCategory other = (DockerImagesCategory)obj;
            return !(this.connection == null ? other.connection != null : !this.connection.equals((Object)other.connection));
        }
    }

    public static class DockerContainersCategory
    implements IAdaptable {
        private final IDockerConnection connection;

        public DockerContainersCategory(IDockerConnection connection) {
            this.connection = connection;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.equals(IDockerConnection.class)) {
                return (T)this.getConnection();
            }
            return null;
        }

        public IDockerConnection getConnection() {
            return this.connection;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerContainersCategory other = (DockerContainersCategory)obj;
            return !(this.connection == null ? other.connection != null : !this.connection.equals((Object)other.connection));
        }
    }

    public static class LoadingStub {
        private final Object element;

        public LoadingStub(Object element) {
            this.element = element;
        }

        public Object getElement() {
            return this.element;
        }
    }

    public static class DockerContainerPortMappingsCategory
    implements IAdaptable {
        private final IDockerContainer container;
        private final List<IDockerPortMapping> portMappings;

        public DockerContainerPortMappingsCategory(IDockerContainer container, Map<String, List<IDockerPortBinding>> bindings) {
            this.container = container;
            this.portMappings = new ArrayList<IDockerPortMapping>();
            if (bindings != null) {
                for (Map.Entry<String, List<IDockerPortBinding>> entry : bindings.entrySet()) {
                    String[] source = entry.getKey().split("/");
                    int privatePort = Integer.parseInt(source[0]);
                    String type = source[1];
                    for (IDockerPortBinding portBinding : entry.getValue()) {
                        this.portMappings.add((IDockerPortMapping)new DockerPortMapping(container, privatePort, Integer.parseInt(portBinding.hostPort()), type, portBinding.hostIp()));
                    }
                }
            }
            Collections.sort(this.portMappings, (portMapping, otherPortMapping) -> portMapping.getPrivatePort() - otherPortMapping.getPrivatePort());
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.equals(IDockerConnection.class)) {
                return (T)this.getContainer().getConnection();
            }
            return null;
        }

        public IDockerContainer getContainer() {
            return this.container;
        }

        public List<IDockerPortMapping> getPortMappings() {
            return this.portMappings;
        }

        public String toString() {
            return "Port mappings for " + this.container.name();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerContainerPortMappingsCategory other = (DockerContainerPortMappingsCategory)obj;
            return !(this.container == null ? other.container != null : !this.container.equals((Object)other.container));
        }
    }

    public static class DockerContainerVolumesCategory
    implements IAdaptable {
        private final IDockerContainer container;
        private final List<DockerContainerVolume> volumes;

        public DockerContainerVolumesCategory(IDockerContainer container, List<String> volumes) {
            this.container = container;
            this.volumes = new ArrayList<DockerContainerVolume>();
            if (volumes != null) {
                for (String volume : volumes) {
                    this.volumes.add(new DockerContainerVolume(container, volume));
                }
            }
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.equals(IDockerConnection.class)) {
                return (T)this.getContainer().getConnection();
            }
            return null;
        }

        public IDockerContainer getContainer() {
            return this.container;
        }

        public List<DockerContainerVolume> getVolumes() {
            if (this.volumes == null) {
                return Collections.emptyList();
            }
            return this.volumes;
        }

        public String toString() {
            return "Volumes for " + this.container.name();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerContainerVolumesCategory other = (DockerContainerVolumesCategory)obj;
            return !(this.container == null ? other.container != null : !this.container.equals((Object)other.container));
        }
    }

    public static class DockerContainerLinksCategory
    implements IAdaptable {
        private final IDockerContainer container;
        private final List<DockerContainerLink> links;

        public DockerContainerLinksCategory(IDockerContainer container, List<String> links) {
            this.container = container;
            this.links = new ArrayList<DockerContainerLink>();
            if (links != null) {
                for (String link : links) {
                    this.links.add(new DockerContainerLink(container, link));
                }
            }
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.equals(IDockerConnection.class)) {
                return (T)this.getContainer().getConnection();
            }
            return null;
        }

        public IDockerContainer getContainer() {
            return this.container;
        }

        public List<DockerContainerLink> getLinks() {
            if (this.links == null) {
                return Collections.emptyList();
            }
            return this.links;
        }

        public String toString() {
            return "Container links for " + this.container.name();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerContainerLinksCategory other = (DockerContainerLinksCategory)obj;
            return !(this.container == null ? other.container != null : !this.container.equals((Object)other.container));
        }
    }

    public static class DockerContainerVolume
    implements IAdaptable {
        private final IDockerContainer container;
        private final String hostPath;
        private final String containerPath;
        private final String flags;

        public DockerContainerVolume(IDockerContainer container, String volume) {
            this.container = container;
            String[] args = volume.split(":");
            this.hostPath = args.length > 1 ? args[0] : null;
            this.containerPath = args.length > 1 ? args[1] : args[0];
            this.flags = args.length > 2 ? args[2] : null;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.equals(IDockerConnection.class)) {
                return (T)this.getContainer().getConnection();
            }
            return null;
        }

        public IDockerContainer getContainer() {
            return this.container;
        }

        public String getHostPath() {
            return this.hostPath;
        }

        public String getContainerPath() {
            return this.containerPath;
        }

        public String getFlags() {
            return this.flags;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.containerPath == null ? 0 : this.containerPath.hashCode());
            result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
            result = 31 * result + (this.hostPath == null ? 0 : this.hostPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerContainerVolume other = (DockerContainerVolume)obj;
            if (this.containerPath == null ? other.containerPath != null : !this.containerPath.equals(other.containerPath)) {
                return false;
            }
            if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
                return false;
            }
            return !(this.hostPath == null ? other.hostPath != null : !this.hostPath.equals(other.hostPath));
        }
    }

    public static class DockerContainerLink
    implements IAdaptable {
        private final IDockerContainer container;
        private final String containerName;
        private final String containerAlias;

        public DockerContainerLink(IDockerContainer container, String linkValue) {
            this.container = container;
            String[] args = linkValue.split(":");
            this.containerName = this.getDisplayableContainerName(args[0]);
            this.containerAlias = args.length > 0 ? this.getDisplayableContainerAlias(args[1]) : null;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.equals(IDockerConnection.class)) {
                return (T)this.getContainer().getConnection();
            }
            return null;
        }

        public IDockerContainer getContainer() {
            return this.container;
        }

        private String getDisplayableContainerName(String containerName) {
            return containerName.startsWith("/") ? containerName.substring(1) : containerName;
        }

        private String getDisplayableContainerAlias(String containerAlias) {
            String[] containerAliasSplit = containerAlias.split("/");
            if (containerAliasSplit.length > 1) {
                return containerAliasSplit[2];
            }
            return null;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public String getContainerAlias() {
            return this.containerAlias;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.containerAlias == null ? 0 : this.containerAlias.hashCode());
            result = 31 * result + (this.containerName == null ? 0 : this.containerName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerContainerLink other = (DockerContainerLink)obj;
            if (this.containerAlias == null ? other.containerAlias != null : !this.containerAlias.equals(other.containerAlias)) {
                return false;
            }
            return !(this.containerName == null ? other.containerName != null : !this.containerName.equals(other.containerName));
        }
    }
}

