// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.1.2,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.artifact.repository.metadata;

/**
 * Versioning information for "groupId/artifactId" or
 * "groupId/artifactId/version" SNAPSHOT.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Versioning
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * What the last version added to the directory is, including
     * both releases and snapshots ("groupId/artifactId" directory
     * only).
     */
    private String latest;

    /**
     * What the last version added to the directory is, for the
     * releases only ("groupId/artifactId" directory only).
     */
    private String release;

    /**
     * Field versions.
     */
    private java.util.List<String> versions;

    /**
     * When the metadata was last updated (both
     * "groupId/artifactId" and "groupId/artifactId/version"
     * directories). The timestamp is expressed using UTC in the
     * format yyyyMMddHHmmss.
     */
    private String lastUpdated;

    /**
     * The current snapshot data in use for this version
     * ("groupId/artifactId/version" only).
     */
    private Snapshot snapshot;

    /**
     * Field snapshotVersions.
     */
    private java.util.List<SnapshotVersion> snapshotVersions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addSnapshotVersion.
     * 
     * @param snapshotVersion a snapshotVersion object.
     */
    public void addSnapshotVersion( SnapshotVersion snapshotVersion )
    {
        getSnapshotVersions().add( snapshotVersion );
    } //-- void addSnapshotVersion( SnapshotVersion )

    /**
     * Method addVersion.
     * 
     * @param string a string object.
     */
    public void addVersion( String string )
    {
        getVersions().add( string );
    } //-- void addVersion( String )

    /**
     * Method clone.
     * 
     * @return Versioning
     */
    public Versioning clone()
    {
        try
        {
            Versioning copy = (Versioning) super.clone();

            if ( this.versions != null )
            {
                copy.versions = new java.util.ArrayList<String>();
                copy.versions.addAll( this.versions );
            }

            if ( this.snapshot != null )
            {
                copy.snapshot = (Snapshot) this.snapshot.clone();
            }

            if ( this.snapshotVersions != null )
            {
                copy.snapshotVersions = new java.util.ArrayList<SnapshotVersion>();
                for ( SnapshotVersion item : this.snapshotVersions )
                {
                    copy.snapshotVersions.add( ( (SnapshotVersion) item).clone() );
                }
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Versioning clone()

    /**
     * Get when the metadata was last updated (both
     * "groupId/artifactId" and "groupId/artifactId/version"
     * directories). The timestamp is expressed using UTC in the
     * format yyyyMMddHHmmss.
     * 
     * @return String
     */
    public String getLastUpdated()
    {
        return this.lastUpdated;
    } //-- String getLastUpdated()

    /**
     * Get what the last version added to the directory is,
     * including both releases and snapshots ("groupId/artifactId"
     * directory only).
     * 
     * @return String
     */
    public String getLatest()
    {
        return this.latest;
    } //-- String getLatest()

    /**
     * Get what the last version added to the directory is, for the
     * releases only ("groupId/artifactId" directory only).
     * 
     * @return String
     */
    public String getRelease()
    {
        return this.release;
    } //-- String getRelease()

    /**
     * Get the current snapshot data in use for this version
     * ("groupId/artifactId/version" only).
     * 
     * @return Snapshot
     */
    public Snapshot getSnapshot()
    {
        return this.snapshot;
    } //-- Snapshot getSnapshot()

    /**
     * Method getSnapshotVersions.
     * 
     * @return List
     */
    public java.util.List<SnapshotVersion> getSnapshotVersions()
    {
        if ( this.snapshotVersions == null )
        {
            this.snapshotVersions = new java.util.ArrayList<SnapshotVersion>();
        }

        return this.snapshotVersions;
    } //-- java.util.List<SnapshotVersion> getSnapshotVersions()

    /**
     * Method getVersions.
     * 
     * @return List
     */
    public java.util.List<String> getVersions()
    {
        if ( this.versions == null )
        {
            this.versions = new java.util.ArrayList<String>();
        }

        return this.versions;
    } //-- java.util.List<String> getVersions()

    /**
     * Method removeSnapshotVersion.
     * 
     * @param snapshotVersion a snapshotVersion object.
     */
    public void removeSnapshotVersion( SnapshotVersion snapshotVersion )
    {
        getSnapshotVersions().remove( snapshotVersion );
    } //-- void removeSnapshotVersion( SnapshotVersion )

    /**
     * Method removeVersion.
     * 
     * @param string a string object.
     */
    public void removeVersion( String string )
    {
        getVersions().remove( string );
    } //-- void removeVersion( String )

    /**
     * Set when the metadata was last updated (both
     * "groupId/artifactId" and "groupId/artifactId/version"
     * directories). The timestamp is expressed using UTC in the
     * format yyyyMMddHHmmss.
     * 
     * @param lastUpdated a lastUpdated object.
     */
    public void setLastUpdated( String lastUpdated )
    {
        this.lastUpdated = lastUpdated;
    } //-- void setLastUpdated( String )

    /**
     * Set what the last version added to the directory is,
     * including both releases and snapshots ("groupId/artifactId"
     * directory only).
     * 
     * @param latest a latest object.
     */
    public void setLatest( String latest )
    {
        this.latest = latest;
    } //-- void setLatest( String )

    /**
     * Set what the last version added to the directory is, for the
     * releases only ("groupId/artifactId" directory only).
     * 
     * @param release a release object.
     */
    public void setRelease( String release )
    {
        this.release = release;
    } //-- void setRelease( String )

    /**
     * Set the current snapshot data in use for this version
     * ("groupId/artifactId/version" only).
     * 
     * @param snapshot a snapshot object.
     */
    public void setSnapshot( Snapshot snapshot )
    {
        this.snapshot = snapshot;
    } //-- void setSnapshot( Snapshot )

    /**
     * Set information for each sub-artifact available in this
     * artifact snapshot. This is only the most recent SNAPSHOT for
     * each unique extension/classifier combination.
     * 
     * @param snapshotVersions a snapshotVersions object.
     */
    public void setSnapshotVersions( java.util.List<SnapshotVersion> snapshotVersions )
    {
        this.snapshotVersions = snapshotVersions;
    } //-- void setSnapshotVersions( java.util.List )

    /**
     * Set versions available of the artifact (both releases and
     * snapshots) ("groupId/artifactId" directory only).
     * 
     * @param versions a versions object.
     */
    public void setVersions( java.util.List<String> versions )
    {
        this.versions = versions;
    } //-- void setVersions( java.util.List )

    
    public void updateTimestamp()
    {
        setLastUpdatedTimestamp( new java.util.Date() );
    }

    public void setLastUpdatedTimestamp( java.util.Date date )
    {
        java.util.TimeZone timezone = java.util.TimeZone.getTimeZone( "UTC" );
        java.text.DateFormat fmt = new java.text.SimpleDateFormat( "yyyyMMddHHmmss" );
        fmt.setTimeZone( timezone );
        setLastUpdated( fmt.format( date ) );
    }
          
}
