/*******************************************************************************
 * Copyright (c) 2008-2010 Sonatype, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *      Sonatype, Inc. - initial API and implementation
 *******************************************************************************/

package org.eclipse.m2e.model.edit.pom;

import org.eclipse.emf.ecore.EObject;


/**
 * <!-- begin-user-doc --> A representation of the model object ' <em><b>Distribution Management</b></em>'. <!--
 * end-user-doc --> <!-- begin-model-doc --> 4.0.0 This elements describes all that pertains to distribution for a
 * project. It is primarily used for deployment of artifacts and the site produced by the build. <!-- end-model-doc -->
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getRepository <em>Repository</em>}</li>
 * <li>
 * {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getSnapshotRepository <em>Snapshot Repository</em>}</li>
 * <li>{@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getSite <em> Site</em>}</li>
 * <li>
 * {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getDownloadUrl <em>Download Url</em>}</li>
 * <li>{@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getRelocation <em>Relocation</em>}</li>
 * <li>{@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getStatus <em> Status</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.m2e.model.edit.pom.PomPackage#getDistributionManagement()
 * @model extendedMetaData="name='DistributionManagement' kind='elementOnly'"
 * @generated
 */
public interface DistributionManagement extends EObject {
  /**
   * Returns the value of the '<em><b>Repository</b></em>' containment reference. <!-- begin-user-doc --> <!--
   * end-user-doc --> <!-- begin-model-doc --> 4.0.0 Information needed to deploy the artifacts generated by the project
   * to a remote repository. <!-- end-model-doc -->
   *
   * @return the value of the '<em>Repository</em>' containment reference.
   * @see #isSetRepository()
   * @see #unsetRepository()
   * @see #setRepository(DeploymentRepository)
   * @see org.eclipse.m2e.model.edit.pom.PomPackage#getDistributionManagement_Repository()
   * @model containment="true" unsettable="true" extendedMetaData=
   *        "kind='element' name='repository' namespace='##targetNamespace'"
   * @generated
   */
  DeploymentRepository getRepository();

  /**
   * Sets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getRepository
   * <em>Repository</em>}' containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @param value the new value of the '<em>Repository</em>' containment reference.
   * @see #isSetRepository()
   * @see #unsetRepository()
   * @see #getRepository()
   * @generated
   */
  void setRepository(DeploymentRepository value);

  /**
   * Unsets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getRepository
   * <em>Repository</em>}' containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @see #isSetRepository()
   * @see #getRepository()
   * @see #setRepository(DeploymentRepository)
   * @generated
   */
  void unsetRepository();

  /**
   * Returns whether the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getRepository
   * <em>Repository</em>}' containment reference is set. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @return whether the value of the '<em>Repository</em>' containment reference is set.
   * @see #unsetRepository()
   * @see #getRepository()
   * @see #setRepository(DeploymentRepository)
   * @generated
   */
  boolean isSetRepository();

  /**
   * Returns the value of the '<em><b>Snapshot Repository</b></em>' containment reference. <!-- begin-user-doc --> <!--
   * end-user-doc --> <!-- begin-model-doc --> 4.0.0 Where to deploy snapshots of artifacts to. If not given, it
   * defaults to the &lt;code&gt;repository&lt;/code&gt; element. <!-- end-model-doc -->
   *
   * @return the value of the '<em>Snapshot Repository</em>' containment reference.
   * @see #isSetSnapshotRepository()
   * @see #unsetSnapshotRepository()
   * @see #setSnapshotRepository(DeploymentRepository)
   * @see org.eclipse.m2e.model.edit.pom.PomPackage#getDistributionManagement_SnapshotRepository()
   * @model containment="true" unsettable="true" extendedMetaData=
   *        "kind='element' name='snapshotRepository' namespace='##targetNamespace'"
   * @generated
   */
  DeploymentRepository getSnapshotRepository();

  /**
   * Sets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getSnapshotRepository
   * <em>Snapshot Repository</em>}' containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @param value the new value of the '<em>Snapshot Repository</em>' containment reference.
   * @see #isSetSnapshotRepository()
   * @see #unsetSnapshotRepository()
   * @see #getSnapshotRepository()
   * @generated
   */
  void setSnapshotRepository(DeploymentRepository value);

  /**
   * Unsets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getSnapshotRepository
   * <em>Snapshot Repository</em>}' containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @see #isSetSnapshotRepository()
   * @see #getSnapshotRepository()
   * @see #setSnapshotRepository(DeploymentRepository)
   * @generated
   */
  void unsetSnapshotRepository();

  /**
   * Returns whether the value of the '
   * {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getSnapshotRepository <em>Snapshot Repository</em>}'
   * containment reference is set. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @return whether the value of the '<em>Snapshot Repository</em>' containment reference is set.
   * @see #unsetSnapshotRepository()
   * @see #getSnapshotRepository()
   * @see #setSnapshotRepository(DeploymentRepository)
   * @generated
   */
  boolean isSetSnapshotRepository();

  /**
   * Returns the value of the '<em><b>Site</b></em>' containment reference. <!-- begin-user-doc --> <!-- end-user-doc
   * --> <!-- begin-model-doc --> 4.0.0 Information needed for deploying the web site of the project. <!-- end-model-doc
   * -->
   *
   * @return the value of the '<em>Site</em>' containment reference.
   * @see #isSetSite()
   * @see #unsetSite()
   * @see #setSite(Site)
   * @see org.eclipse.m2e.model.edit.pom.PomPackage#getDistributionManagement_Site()
   * @model containment="true" unsettable="true" extendedMetaData=
   *        "kind='element' name='site' namespace='##targetNamespace'"
   * @generated
   */
  Site getSite();

  /**
   * Sets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getSite <em>Site</em>}'
   * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @param value the new value of the '<em>Site</em>' containment reference.
   * @see #isSetSite()
   * @see #unsetSite()
   * @see #getSite()
   * @generated
   */
  void setSite(Site value);

  /**
   * Unsets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getSite <em>Site</em>}'
   * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @see #isSetSite()
   * @see #getSite()
   * @see #setSite(Site)
   * @generated
   */
  void unsetSite();

  /**
   * Returns whether the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getSite
   * <em>Site</em>}' containment reference is set. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @return whether the value of the '<em>Site</em>' containment reference is set.
   * @see #unsetSite()
   * @see #getSite()
   * @see #setSite(Site)
   * @generated
   */
  boolean isSetSite();

  /**
   * Returns the value of the '<em><b>Download Url</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
   * <!-- begin-model-doc --> 4.0.0+ The URL of the project's download page. If not given users will be referred to the
   * homepage given by &lt;code&gt;url&lt;/code&gt;. This is given to assist in locating artifacts that are not in the
   * repository due to licensing restrictions. <!-- end-model-doc -->
   *
   * @return the value of the '<em>Download Url</em>' attribute.
   * @see #setDownloadUrl(String)
   * @see org.eclipse.m2e.model.edit.pom.PomPackage#getDistributionManagement_DownloadUrl()
   * @model dataType="org.eclipse.emf.ecore.xml.type.String" extendedMetaData=
   *        "kind='element' name='downloadUrl' namespace='##targetNamespace'"
   * @generated
   */
  String getDownloadUrl();

  /**
   * Sets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getDownloadUrl
   * <em>Download Url</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @param value the new value of the '<em>Download Url</em>' attribute.
   * @see #getDownloadUrl()
   * @generated
   */
  void setDownloadUrl(String value);

  /**
   * Returns the value of the '<em><b>Relocation</b></em>' containment reference. <!-- begin-user-doc --> <!--
   * end-user-doc --> <!-- begin-model-doc --> 4.0.0 Relocation information of the artifact if it has been moved to a
   * new group ID and/or artifact ID. <!-- end-model-doc -->
   *
   * @return the value of the '<em>Relocation</em>' containment reference.
   * @see #isSetRelocation()
   * @see #unsetRelocation()
   * @see #setRelocation(Relocation)
   * @see org.eclipse.m2e.model.edit.pom.PomPackage#getDistributionManagement_Relocation()
   * @model containment="true" unsettable="true" extendedMetaData=
   *        "kind='element' name='relocation' namespace='##targetNamespace'"
   * @generated
   */
  Relocation getRelocation();

  /**
   * Sets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getRelocation
   * <em>Relocation</em>}' containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @param value the new value of the '<em>Relocation</em>' containment reference.
   * @see #isSetRelocation()
   * @see #unsetRelocation()
   * @see #getRelocation()
   * @generated
   */
  void setRelocation(Relocation value);

  /**
   * Unsets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getRelocation
   * <em>Relocation</em>}' containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @see #isSetRelocation()
   * @see #getRelocation()
   * @see #setRelocation(Relocation)
   * @generated
   */
  void unsetRelocation();

  /**
   * Returns whether the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getRelocation
   * <em>Relocation</em>}' containment reference is set. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @return whether the value of the '<em>Relocation</em>' containment reference is set.
   * @see #unsetRelocation()
   * @see #getRelocation()
   * @see #setRelocation(Relocation)
   * @generated
   */
  boolean isSetRelocation();

  /**
   * Returns the value of the '<em><b>Status</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc --> <!--
   * begin-model-doc --> 4.0.0 Gives the status of this artifact in the remote repository. This must not be set in your
   * local project, as it is updated by tools placing it in the reposiory. Valid values are:
   * &lt;code&gt;none&lt;/code&gt; (default), &lt;code&gt;converted&lt;/code&gt; (repository manager converted this from
   * an Maven 1 POM), &lt;code&gt;partner&lt;/code&gt; (directly synced from a partner Maven 2 repository),
   * &lt;code&gt;deployed&lt;/code&gt; (was deployed from a Maven 2 instance), &lt;code&gt;verified&lt;/code&gt; (has
   * been hand verified as correct and final). <!-- end-model-doc -->
   *
   * @return the value of the '<em>Status</em>' attribute.
   * @see #setStatus(String)
   * @see org.eclipse.m2e.model.edit.pom.PomPackage#getDistributionManagement_Status()
   * @model dataType="org.eclipse.emf.ecore.xml.type.String" extendedMetaData=
   *        "kind='element' name='status' namespace='##targetNamespace'"
   * @generated
   */
  String getStatus();

  /**
   * Sets the value of the ' {@link org.eclipse.m2e.model.edit.pom.DistributionManagement#getStatus <em>Status</em>}'
   * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @param value the new value of the '<em>Status</em>' attribute.
   * @see #getStatus()
   * @generated
   */
  void setStatus(String value);

} // DistributionManagement
