/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.NativeStackFrame;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.VMException;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;

public class SimpleDebugger
implements Debugger {
    private Stack stepStack = new Stack();
    private boolean showStackTrace;
    private boolean step;
    private List stepops;
    private List deepstepops;
    private List nostepops;
    private List deepnostepops;
    private boolean showSummary;
    private boolean profile;
    private boolean continueAfterErrors;
    private boolean terminated;
    private Map operationCalls = new HashMap();
    private long instr = 0L;

    public SimpleDebugger(boolean step, List stepops, List deepstepops, List nostepops, List deepnostepops, boolean showStackTrace) {
        this(step, stepops, deepstepops, nostepops, deepnostepops, showStackTrace, false, false, true);
    }

    public SimpleDebugger(boolean step, List stepops, List deepstepops, List nostepops, List deepnostepops, boolean showStackTrace, boolean continueAfterErrors) {
        this(step, stepops, deepstepops, nostepops, deepnostepops, showStackTrace, false, false, continueAfterErrors);
    }

    public SimpleDebugger(boolean step, List stepops, List deepstepops, List nostepops, List deepnostepops, boolean showStackTrace, boolean showSummary, boolean profile, boolean continueAfterErrors) {
        this.step = step;
        this.stepops = stepops;
        this.deepstepops = deepstepops;
        this.nostepops = nostepops;
        this.deepnostepops = deepnostepops;
        this.showStackTrace = showStackTrace;
        this.showSummary = showSummary;
        this.profile = profile;
        this.continueAfterErrors = continueAfterErrors;
        this.terminated = false;
    }

    public void enter(StackFrame frame) {
        Operation op = frame.getOperation();
        String opName = op.getName();
        if (this.profile && op instanceof ASMOperation) {
            OperationCall oc = (OperationCall)this.operationCalls.get(op);
            if (oc == null) {
                oc = new OperationCall(op);
                this.operationCalls.put(op, oc);
            }
            oc.incrementCallCount(frame.getArgs());
        }
        if (!this.stepops.contains(opName)) {
            if (this.deepstepops.contains(opName)) {
                this.stepStack.push(new Boolean(this.step));
                this.step = true;
            } else if (!this.nostepops.contains(opName) && this.deepnostepops.contains(opName)) {
                this.stepStack.push(new Boolean(this.step));
                this.step = false;
            }
        }
        if (this.getShowEnter()) {
            if (frame instanceof ASMStackFrame) {
                ATLLogger.info((String)("********************* Entering " + op + " with " + ((ASMStackFrame)frame).getLocalVariables()));
            } else {
                ATLLogger.info((String)("********************* Entering " + op + " with " + frame.getArgs()));
            }
        }
    }

    public void leave(StackFrame frame) {
        Operation op = frame.getOperation();
        String opName = op.getName();
        if (this.getShowLeave()) {
            ASMOclAny ret = null;
            if (frame instanceof ASMStackFrame) {
                if (!((ASMStackFrame)frame).empty()) {
                    ret = ((ASMStackFrame)frame).peek();
                }
            } else {
                ret = ((NativeStackFrame)frame).getRet();
            }
            ATLLogger.info((String)("********************* Leaving " + op + " with " + ret));
        }
        if (!this.stepops.contains(opName)) {
            if (this.deepstepops.contains(opName)) {
                this.step = (Boolean)this.stepStack.pop();
            } else if (!this.nostepops.contains(opName) && this.deepnostepops.contains(opName)) {
                this.step = (Boolean)this.stepStack.pop();
            }
        }
    }

    private String conv(int i) {
        if (i < 10) {
            return "000" + i;
        }
        if (i < 100) {
            return "00" + i;
        }
        if (i < 1000) {
            return "0" + i;
        }
        return "" + i;
    }

    private void printStack(ASMStackFrame frame) {
        StringBuffer out = new StringBuffer("[");
        Iterator i = frame.getLocalStack().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o == null) {
                out.append("null");
            } else {
                String s = o.toString();
                if (s.length() > 30) {
                    s = String.valueOf(s.substring(0, 10)) + "..." + s.substring(s.length() - 10);
                }
                out.append(s);
            }
            if (!i.hasNext()) continue;
            out.append(", ");
        }
        out.append("]");
        ATLLogger.info((String)out.toString());
    }

    public void step(ASMStackFrame frame) {
        ++this.instr;
        if (this.step) {
            this.printStack(frame);
            ATLLogger.info((String)(String.valueOf(this.conv(frame.getLocation())) + ": " + ((ASMOperation)frame.getOperation()).getInstructions().get(frame.getLocation())));
        }
    }

    public void error(StackFrame frame, String msg, Exception e) {
        if (this.terminated) {
            throw new VMException(frame, msg, e);
        }
        VMException exception = null;
        exception = this.getShowStackTrace() ? new VMException(frame, msg, e) : new VMException(null, msg, e);
        if (!this.continueAfterErrors) {
            this.terminated = true;
            throw exception;
        }
        ATLLogger.warning((String)msg);
        ATLLogger.info((String)"Trying to continue execution despite the error.");
    }

    public void terminated() {
        if (this.showSummary || this.profile) {
            ATLLogger.info((String)("Number of instructions executed: " + this.instr));
            if (this.profile) {
                ATLLogger.info((String)"Operation calls:");
                ArrayList opCalls = new ArrayList(this.operationCalls.values());
                Collections.sort(opCalls, Collections.reverseOrder());
                Iterator i = opCalls.iterator();
                while (i.hasNext()) {
                    ATLLogger.info((String)("\t" + i.next()));
                }
            }
        }
    }

    private boolean getShowEnter() {
        return this.step;
    }

    private boolean getShowLeave() {
        return this.step;
    }

    private boolean getShowStackTrace() {
        return this.showStackTrace;
    }

    private String toTimes(int n) {
        String ret = null;
        switch (n) {
            case 1: {
                ret = "once";
                break;
            }
            case 2: {
                ret = "twice";
                break;
            }
            default: {
                ret = String.valueOf(n) + " times";
            }
        }
        return ret;
    }

    protected class OperationCall
    implements Comparable {
        private Operation op;
        private int callCount = 0;
        private Map callCountByArgs = new HashMap();
        private int maxCallCountByArgs = 0;
        private List maxCalledArgs = null;

        public OperationCall(Operation op) {
            this.op = op;
        }

        public void incrementCallCount(List args) {
            ++this.callCount;
            Integer ccba = (Integer)this.callCountByArgs.get(args);
            int ccbai = 0;
            if (ccba != null) {
                ccbai = ccba;
            }
            this.callCountByArgs.put(args, new Integer(++ccbai));
            if (this.maxCallCountByArgs < ccbai) {
                this.maxCallCountByArgs = ccbai;
                this.maxCalledArgs = args;
            }
        }

        public int getCallCount() {
            return this.callCount;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer(this.op.toString());
            ret.append(": called ");
            ret.append(SimpleDebugger.this.toTimes(this.callCount));
            ret.append(" and at most ");
            ret.append(SimpleDebugger.this.toTimes(this.maxCallCountByArgs));
            ret.append(" for the same set of arguments: " + this.maxCalledArgs + ".");
            return ret.toString();
        }

        public int hashCode() {
            return this.op.hashCode();
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int compareTo(Object o) {
            return this.maxCallCountByArgs - ((OperationCall)o).maxCallCountByArgs;
        }
    }
}

