/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.wizard;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewBugzillaTaskWizard
extends NewTaskWizard
implements INewWizard {
    private IStructuredSelection selection;

    public NewBugzillaTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        super(taskRepository, taskSelection);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected ITaskMapping getInitializationData() {
        ISelection sel;
        IWorkbenchWindow window;
        if (this.getTaskSelection() != null) {
            return this.getTaskSelection();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (sel = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)sel;
        }
        final AtomicReference<String> product = new AtomicReference<String>();
        final AtomicReference<String> component = new AtomicReference<String>();
        if (this.selection == null || this.selection.isEmpty()) {
            product.set(this.getTaskRepository().getProperty("last.selection.product"));
            component.set(this.getTaskRepository().getProperty("last.selection.component"));
        } else {
            Object element = this.selection.getFirstElement();
            this.extractMapping(element, product, component);
        }
        if (product.get() != null) {
            return new TaskMapping(){

                public String getProduct() {
                    return (String)product.get();
                }

                public String getComponent() {
                    return (String)component.get();
                }
            };
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void extractMapping(Object element, AtomicReference<String> product, AtomicReference<String> component) {
        Object object = element;
        if (object instanceof ITask) {
            void task;
            ITask iTask = (ITask)object;
            ITask cfr_ignored_0 = (ITask)object;
            product.set(task.getAttribute(BugzillaAttribute.PRODUCT.getKey()));
        } else {
            IRepositoryQuery query = null;
            if (element instanceof IRepositoryQuery) {
                query = (IRepositoryQuery)element;
            }
            if (query != null && query.getConnectorKind().equals("bugzilla")) {
                String[] options;
                String queryUrl = query.getUrl();
                queryUrl = queryUrl.substring(queryUrl.indexOf("?") + 1);
                String[] stringArray = options = queryUrl.split("&");
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    int index = option.indexOf("=");
                    if (index != -1) {
                        String key = option.substring(0, index);
                        if ("product".equals(key) && product.get() == null) {
                            try {
                                product.set(URLDecoder.decode(option.substring(index + 1), this.getTaskRepository().getCharacterEncoding()));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        } else if ("component".equals(key) && component.get() == null) {
                            try {
                                component.set(URLDecoder.decode(option.substring(index + 1), this.getTaskRepository().getCharacterEncoding()));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                    }
                    ++n2;
                }
            } else {
                Object object2 = element;
                if (object2 instanceof IAdaptable) {
                    void adaptable;
                    IAdaptable queryUrl = (IAdaptable)object2;
                    IAdaptable cfr_ignored_1 = (IAdaptable)object2;
                    ITask task = (ITask)adaptable.getAdapter(ITask.class);
                    if (task != null) {
                        product.set(task.getAttribute(BugzillaAttribute.PRODUCT.getKey()));
                    }
                }
            }
        }
    }
}

