/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.resources.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.ui.AbstractAutoFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.navigator.actions.LinkEditorAction;
import org.eclipse.ui.internal.navigator.filters.CommonFilterDescriptor;
import org.eclipse.ui.internal.navigator.filters.CommonFilterDescriptorManager;
import org.eclipse.ui.internal.navigator.filters.CoreExpressionFilter;
import org.eclipse.ui.internal.navigator.filters.SelectFiltersAction;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.navigator.LinkHelperService;

public abstract class FocusCommonNavigatorAction
extends AbstractAutoFocusViewAction {
    private LinkHelperService linkService;
    private boolean resolveFailed;
    private CommonNavigator commonNavigator;
    private CommonFilterDescriptor[] filterDescriptors;
    private Field filterExpressionField1;
    private Field filterExpressionField2;

    public FocusCommonNavigatorAction(InterestFilter interestFilter, boolean manageViewer, boolean manageFilters, boolean manageLinking) {
        super(interestFilter, manageViewer, manageFilters, manageLinking);
    }

    protected boolean installInterestFilter(StructuredViewer viewer) {
        if (this.commonNavigator == null) {
            this.commonNavigator = (CommonNavigator)super.getPartForAction();
        }
        try {
            Class<CoreExpressionFilter> clazz2 = CoreExpressionFilter.class;
            this.filterExpressionField1 = clazz2.getDeclaredField("filterExpression");
            this.filterExpressionField1.setAccessible(true);
            Class<CommonFilterDescriptor> clazz1 = CommonFilterDescriptor.class;
            this.filterExpressionField2 = clazz1.getDeclaredField("filterExpression");
            this.filterExpressionField2.setAccessible(true);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Could not determine filter", (Throwable)e));
        }
        this.filterDescriptors = CommonFilterDescriptorManager.getInstance().findVisibleFilters(this.commonNavigator.getNavigatorContentService());
        return super.installInterestFilter(viewer);
    }

    protected ISelection resolveSelection(IEditorPart editor, ITextSelection changedSelection, StructuredViewer viewer) throws CoreException {
        if (this.resolveFailed) {
            return null;
        }
        if (this.linkService == null) {
            try {
                Method method = CommonNavigator.class.getDeclaredMethod("getLinkHelperService", new Class[0]);
                method.setAccessible(true);
                this.linkService = (LinkHelperService)method.invoke((Object)this.commonNavigator, new Object[0]);
            }
            catch (Throwable e) {
                this.resolveFailed = true;
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Initialization of LinkHelperService failed", e));
            }
        }
        IEditorInput input = editor.getEditorInput();
        ILinkHelper[] helpers = this.linkService.getLinkHelpersFor(input);
        StructuredSelection selection = StructuredSelection.EMPTY;
        StructuredSelection newSelection = StructuredSelection.EMPTY;
        ILinkHelper[] iLinkHelperArray = helpers;
        int n = helpers.length;
        int n2 = 0;
        while (n2 < n) {
            ILinkHelper helper = iLinkHelperArray[n2];
            selection = helper.findSelection(input);
            if (selection != null && !selection.isEmpty()) {
                newSelection = this.mergeSelection((IStructuredSelection)newSelection, (IStructuredSelection)selection);
            }
            ++n2;
        }
        if (!newSelection.isEmpty()) {
            return newSelection;
        }
        return null;
    }

    protected void select(StructuredViewer viewer, ISelection toSelect) {
        Display.getDefault().asyncExec(() -> {
            if (this.commonNavigator == null) {
                this.commonNavigator = (CommonNavigator)FocusCommonNavigatorAction.super.getPartForAction();
            }
            if (this.commonNavigator != null) {
                this.commonNavigator.selectReveal(toSelect);
            }
        });
    }

    protected void setManualFilteringAndLinkingEnabled(boolean on) {
        IViewPart part = super.getPartForAction();
        if (part instanceof CommonNavigator) {
            ActionContributionItem actionItem;
            IContributionItem iContributionItem;
            IContributionItem item;
            IContributionItem[] iContributionItemArray = ((CommonNavigator)part).getViewSite().getActionBars().getToolBarManager().getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                item = iContributionItemArray[n2];
                iContributionItem = item;
                if (iContributionItem instanceof ActionContributionItem) {
                    ActionContributionItem cfr_ignored_0 = (ActionContributionItem)iContributionItem;
                    ActionContributionItem cfr_ignored_1 = (ActionContributionItem)iContributionItem;
                    if (actionItem.getAction() instanceof LinkEditorAction) {
                        actionItem.getAction().setEnabled(on);
                    }
                }
                ++n2;
            }
            iContributionItemArray = ((CommonNavigator)part).getViewSite().getActionBars().getMenuManager().getItems();
            n = iContributionItemArray.length;
            n2 = 0;
            while (n2 < n) {
                item = iContributionItemArray[n2];
                iContributionItem = item;
                if (iContributionItem instanceof ActionContributionItem) {
                    ActionContributionItem cfr_ignored_2 = (ActionContributionItem)iContributionItem;
                    ActionContributionItem cfr_ignored_3 = (ActionContributionItem)iContributionItem;
                    if (actionItem.getAction() instanceof SelectFiltersAction) {
                        actionItem.getAction().setEnabled(on);
                    }
                }
                ++n2;
            }
        }
    }

    protected void setDefaultLinkingEnabled(boolean on) {
        IViewPart part = super.getPartForAction();
        if (part instanceof CommonNavigator) {
            ((CommonNavigator)part).setLinkingEnabled(on);
        }
    }

    protected boolean isDefaultLinkingEnabled() {
        IViewPart part = super.getPartForAction();
        if (part instanceof CommonNavigator) {
            return ((CommonNavigator)part).isLinkingEnabled();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isPreservedFilter(ViewerFilter filter) {
        ViewerFilter viewerFilter = filter;
        if (!(viewerFilter instanceof CoreExpressionFilter)) return false;
        CoreExpressionFilter coreExpressionFilter = (CoreExpressionFilter)viewerFilter;
        CoreExpressionFilter cfr_ignored_0 = (CoreExpressionFilter)viewerFilter;
        Set preservedIds = ContextUiPlugin.getDefault().getPreservedFilterIds(this.viewPart.getSite().getId());
        if (preservedIds.isEmpty()) return false;
        try {
            void expressionFilter;
            Expression expression2 = (Expression)this.filterExpressionField1.get(expressionFilter);
            CommonFilterDescriptor[] commonFilterDescriptorArray = this.filterDescriptors;
            int n = this.filterDescriptors.length;
            int n2 = 0;
            while (true) {
                Expression expression1;
                if (n2 >= n) {
                    return false;
                }
                CommonFilterDescriptor commonFilterDescriptor = commonFilterDescriptorArray[n2];
                if (preservedIds.contains(commonFilterDescriptor.getId()) && (expression1 = (Expression)this.filterExpressionField2.get(commonFilterDescriptor)) != null && expression1.equals(expression2)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Could not determine filter", (Throwable)e));
        }
        return false;
    }

    private IStructuredSelection mergeSelection(IStructuredSelection aBase, IStructuredSelection aSelectionToAppend) {
        if (aBase == null || aBase.isEmpty()) {
            return aSelectionToAppend != null ? aSelectionToAppend : StructuredSelection.EMPTY;
        }
        if (aSelectionToAppend == null || aSelectionToAppend.isEmpty()) {
            return aBase;
        }
        ArrayList newItems = new ArrayList(aBase.toList());
        newItems.addAll(aSelectionToAppend.toList());
        return new StructuredSelection(newItems);
    }
}

