/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.spi.edit.remote;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.reviews.edit.provider.ReviewsItemProviderAdapterFactory;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsResourceFactory;

public abstract class AbstractRemoteEditFactoryProvider<ERootObject extends EObject, EChildObject extends EObject>
extends AbstractRemoteEmfFactoryProvider<ERootObject, EChildObject> {
    final EditingDomain editingDomain;
    ERootObject rootObject;
    private final EFactory emfFactory;
    private final EReference parentReference;
    private final EAttribute localKeyAttribute;
    private final EClass childType;
    private final Map<Object, EChildObject> memberForId = new HashMap<Object, EChildObject>();

    public AbstractRemoteEditFactoryProvider(EFactory emfFactory, EReference parentReference, EAttribute localKeyAttribute, EClass childType) {
        this.emfFactory = emfFactory;
        this.parentReference = parentReference;
        this.localKeyAttribute = localKeyAttribute;
        this.childType = childType;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("reviews", new ReviewsResourceFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReviewsItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public EClass getRootClass() {
        return this.parentReference.getEContainingClass();
    }

    public ERootObject open() {
        if (this.rootObject == null) {
            this.rootObject = this.open(this.getRootClass(), this.getRootClass().getName());
            this.clearChildren();
        }
        return this.rootObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EChildObject open(Object id) {
        if (this.getRoot() != null) {
            ERootObject ERootObject = this.getRoot();
            synchronized (ERootObject) {
                EObject child = (EObject)this.memberForId.get(id);
                if (child == null) {
                    child = this.open(this.childType, (String)id);
                    if (child != null && this.getRoot() != null) {
                        this.memberForId.put(id, child);
                        ((List)this.getRoot().eGet((EStructuralFeature)this.parentReference)).add(child);
                    }
                    return (EChildObject)child;
                }
                return (EChildObject)child;
            }
        }
        return null;
    }

    private Resource getResourceImpl(URI uri, boolean loadOnDemand) {
        Object object;
        Resource resource = null;
        String fileString = uri.toFileString();
        Path filePath = new Path(fileString);
        File file = new File(filePath.toOSString());
        if (!file.exists()) {
            File dir = new File(new Path(fileString).removeFileExtension().removeLastSegments(1).toOSString());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            resource = this.editingDomain.getResourceSet().createResource(uri);
            this.save(resource);
        }
        try {
            resource = this.editingDomain.getResourceSet().getResource(uri, loadOnDemand);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.edit", "Problem with model file. Will be recreated at: " + String.valueOf(uri), (Throwable)e));
            file.delete();
            resource = this.editingDomain.getResourceSet().getResource(uri, loadOnDemand);
        }
        String className = this.getDataLocator().parseFileType((IPath)filePath);
        EClass eClass = null;
        for (EClassifier classifier : this.emfFactory.getEPackage().getEClassifiers()) {
            if (!className.equals(classifier.getName())) continue;
            eClass = (EClass)classifier;
            break;
        }
        if (eClass == null) {
            throw new RuntimeException("No instances of " + className + " found in " + String.valueOf(this.emfFactory.getEPackage().getEClassifiers()));
        }
        if (resource.getContents().size() > 0 && !eClass.isInstance(object = resource.getContents().get(0))) {
            resource.getContents().clear();
        }
        if (resource.getContents().size() == 0) {
            try {
                object = this.emfFactory.create(eClass);
                String id = this.getDataLocator().parseFileName((IPath)filePath);
                if (object.eClass().getEAllAttributes().contains((Object)this.localKeyAttribute)) {
                    object.eSet((EStructuralFeature)this.localKeyAttribute, (Object)id);
                }
                resource.getContents().add(object);
                this.save(resource);
            }
            catch (AssertionError e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.edit", "Bad provider defintion. Local key attribute must be reference of class child type. Local Key: " + this.localKeyAttribute.getName() + " Class: " + eClass.getName(), (Throwable)((Object)e)));
            }
            catch (ClassCastException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.edit", "Bad provider definition. Root remote refernce must match child type.", (Throwable)e));
            }
        }
        return resource;
    }

    protected EObject open(EClass eClass, String id) {
        String containerSegment = this.getContainerSegment();
        URI uri = URI.createFileURI((String)this.getDataLocator().getFilePath(containerSegment, eClass.getName(), id, this.getFileExtension(this.parentReference.getEContainingClass())).toOSString());
        Resource resource = this.getResourceImpl(uri, true);
        return (EObject)resource.getContents().get(0);
    }

    public String getContainerSegment() {
        return this.parentReference.getContainerClass().getName();
    }

    public String getScalablePath(String id) {
        return id;
    }

    public abstract String getFileExtension(EClass var1);

    public Resource recreateResource(URI fileUri) {
        return this.editingDomain.getResourceSet().createResource(fileUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void close(EObject child) {
        if (child == null || this.getRoot() == null || child.eResource() == this.getRoot().eResource() || child.eContainer() != this.getRoot()) {
            return;
        }
        ERootObject ERootObject = this.getRoot();
        synchronized (ERootObject) {
            Object parentList;
            Object object;
            Object key = null;
            for (Map.Entry<Object, EChildObject> entry : this.memberForId.entrySet()) {
                if (entry.getValue() != child) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                this.memberForId.remove(key);
            }
            if ((object = (parentList = this.getRoot().eGet((EStructuralFeature)this.parentReference))) instanceof List) {
                void members;
                List list = (List)object;
                List cfr_ignored_0 = (List)object;
                members.remove(child);
            }
        }
        this.save();
        this.save(child);
        Resource resource = child.eResource();
        if (resource != null) {
            resource.getResourceSet().getResources().remove((Object)resource);
            resource.unload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void clearChildren() {
        if (this.getRoot() != null) {
            ERootObject ERootObject = this.getRoot();
            synchronized (ERootObject) {
                Object parentList;
                Object object = parentList = this.getRoot().eGet((EStructuralFeature)this.parentReference);
                if (object instanceof List) {
                    void members;
                    List list = (List)object;
                    List cfr_ignored_0 = (List)object;
                    members.clear();
                }
            }
        }
    }

    public void close() {
        this.clearChildren();
        this.save();
        if (this.getService() != null) {
            this.getService().dispose();
        }
        this.rootObject = null;
    }

    public void save(EObject object) {
        if (object != null) {
            this.save(object.eResource());
        }
    }

    public void save() {
        this.save((EObject)this.getRoot());
    }

    public void save(Resource resource) {
        if (resource == null) {
            return;
        }
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        try {
            resource.save(saveOptions);
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.edit", "Couldn't save model.", (Throwable)e));
        }
    }

    public void deleteCache() {
        this.close();
        IPath systemPath = this.getDataLocator().getModelPath();
        File file = new File(systemPath.toOSString());
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.edit", "Problem when deleting cache.", (Throwable)e));
            }
        }
    }

    public void modelExec(final Runnable runnable, boolean block) {
        super.modelExec(() -> this.editingDomain.getCommandStack().execute((Command)new AbstractCommand(){

            public void redo() {
            }

            public void execute() {
                runnable.run();
            }

            protected boolean prepare() {
                return true;
            }

            public boolean canUndo() {
                return false;
            }
        }), block);
    }

    public ERootObject getRoot() {
        return this.rootObject;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }
}

