/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.wikitext.ui.editor.FindAndReplaceTarget;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;

public class MarkupSourceViewer
extends SourceViewer {
    private final MarkupLanguage markupLanguage;
    public static final int QUICK_OUTLINE = 513;
    private IInformationPresenter outlinePresenter;
    private IFindReplaceTarget findReplaceTarget;

    public MarkupSourceViewer(Composite parent, IVerticalRuler ruler, int styles, MarkupLanguage markupLanguage) {
        super(parent, ruler, styles);
        this.markupLanguage = markupLanguage;
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        if (document != null) {
            this.configurePartitioning(document);
        }
        super.setDocument(document, annotationModel, modelRangeOffset, modelRangeLength);
    }

    private void configurePartitioning(IDocument document) {
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage(this.markupLanguage.clone());
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public void doOperation(int operation) {
        if (operation == 513 && this.outlinePresenter != null) {
            this.outlinePresenter.showInformation();
            return;
        }
        super.doOperation(operation);
    }

    public boolean canDoOperation(int operation) {
        if (operation == 513 && this.outlinePresenter != null) {
            return true;
        }
        return super.canDoOperation(operation);
    }

    public IFindReplaceTarget getFindReplaceTarget() {
        if (this.findReplaceTarget != null) {
            return this.findReplaceTarget;
        }
        return super.getFindReplaceTarget();
    }

    /*
     * WARNING - void declaration
     */
    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        SourceViewerConfiguration sourceViewerConfiguration = configuration;
        if (sourceViewerConfiguration instanceof MarkupSourceViewerConfiguration) {
            void markupConfiguration;
            MarkupSourceViewerConfiguration markupSourceViewerConfiguration = (MarkupSourceViewerConfiguration)sourceViewerConfiguration;
            MarkupSourceViewerConfiguration cfr_ignored_0 = (MarkupSourceViewerConfiguration)sourceViewerConfiguration;
            this.outlinePresenter = markupConfiguration.getOutlineInformationPresenter((ISourceViewer)this);
            this.outlinePresenter.install((ITextViewer)this);
            if (markupConfiguration.isEnableSelfContainedIncrementalFind()) {
                this.findReplaceTarget = new FindAndReplaceTarget((ITextViewer)this);
            }
        }
    }
}

