/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.internal.runtime.registry.model.BackendChangeListener;
import org.eclipse.pde.internal.runtime.registry.model.Bundle;
import org.eclipse.pde.internal.runtime.registry.model.Extension;
import org.eclipse.pde.internal.runtime.registry.model.ExtensionPoint;
import org.eclipse.pde.internal.runtime.registry.model.ModelChangeDelta;
import org.eclipse.pde.internal.runtime.registry.model.ModelChangeListener;
import org.eclipse.pde.internal.runtime.registry.model.RegistryBackend;
import org.eclipse.pde.internal.runtime.registry.model.ServiceName;
import org.eclipse.pde.internal.runtime.registry.model.ServiceRegistration;
import org.osgi.framework.Version;

public class RegistryModel {
    private final BackendChangeListener backendListener = new BackendChangeListener(){

        @Override
        public void addBundle(Bundle adapter) {
            adapter.setModel(RegistryModel.this);
            ModelChangeDelta delta = new ModelChangeDelta(adapter, 0);
            RegistryModel.this.bundles.put(adapter.getId(), adapter);
            if (adapter.getFragmentHost() != null) {
                RegistryModel.this.addFragment(adapter);
                Bundle host = RegistryModel.this.getBundle(adapter.getFragmentHost(), adapter.getFragmentHostVersion());
                if (host != null) {
                    ModelChangeDelta d2 = new ModelChangeDelta(host, 1);
                    RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{delta, d2});
                    return;
                }
            }
            RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{delta});
        }

        @Override
        public void removeBundle(Bundle adapter) {
            ModelChangeDelta delta = new ModelChangeDelta(adapter, 2);
            RegistryModel.this.bundles.remove(adapter.getId());
            if (adapter.getFragmentHost() != null) {
                RegistryModel.this.removeFragment(adapter);
                Bundle host = RegistryModel.this.getBundle(adapter.getFragmentHost(), adapter.getFragmentHostVersion());
                if (host != null) {
                    ModelChangeDelta d2 = new ModelChangeDelta(host, 1);
                    RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{delta, d2});
                    return;
                }
            }
            RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{delta});
            adapter.setModel(null);
        }

        @Override
        public void updateBundle(Bundle adapter, int updated) {
            adapter.setModel(RegistryModel.this);
            ModelChangeDelta delta = new ModelChangeDelta(adapter, updated);
            RegistryModel.this.bundles.put(adapter.getId(), adapter);
            if (adapter.getFragmentHost() != null) {
                RegistryModel.this.addFragment(adapter);
            }
            RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{delta});
        }

        @Override
        public void addService(ServiceRegistration adapter) {
            ModelChangeDelta serviceNameDelta = null;
            if (!RegistryModel.this.serviceNames.contains(adapter.getName())) {
                ServiceName name = adapter.getName();
                name.setModel(RegistryModel.this);
                RegistryModel.this.serviceNames.add(name);
                serviceNameDelta = new ModelChangeDelta(name, 0);
            }
            adapter.setModel(RegistryModel.this);
            RegistryModel.this.services.put(adapter.getId(), adapter);
            ModelChangeDelta delta = new ModelChangeDelta(adapter, 0);
            if (serviceNameDelta != null) {
                RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{serviceNameDelta, delta});
            } else {
                RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{delta});
            }
        }

        @Override
        public void removeService(ServiceRegistration adapter) {
            ModelChangeDelta serviceNameDelta = null;
            if (RegistryModel.this.getServices(adapter.getName().getClasses()).length == 0) {
                RegistryModel.this.serviceNames.remove(adapter.getName());
                serviceNameDelta = new ModelChangeDelta(adapter.getName(), 2);
            }
            RegistryModel.this.services.remove(adapter.getId());
            ModelChangeDelta delta = new ModelChangeDelta(adapter, 2);
            if (serviceNameDelta != null) {
                RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{serviceNameDelta, delta});
                adapter.getName().setModel(null);
                adapter.setModel(null);
            } else {
                RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{delta});
                adapter.setModel(null);
            }
        }

        @Override
        public void updateService(ServiceRegistration adapter) {
            adapter.setModel(RegistryModel.this);
            RegistryModel.this.services.put(adapter.getId(), adapter);
            ModelChangeDelta delta = new ModelChangeDelta(adapter, 1);
            RegistryModel.this.fireModelChangeEvent(new ModelChangeDelta[]{delta});
        }

        @Override
        public void addExtensions(Extension[] extensionAdapters) {
            Extension[] extensionArray = extensionAdapters;
            int n = extensionAdapters.length;
            int n2 = 0;
            while (n2 < n) {
                Extension extension = extensionArray[n2];
                extension.setModel(RegistryModel.this);
                String id = extension.getExtensionPointUniqueIdentifier();
                ExtensionPoint extPoint = RegistryModel.this.extensionPoints.get(id);
                extPoint.getExtensions().add(extension);
                ++n2;
            }
            ModelChangeDelta[] delta = new ModelChangeDelta[extensionAdapters.length];
            int i = 0;
            while (i < delta.length) {
                delta[i] = new ModelChangeDelta(extensionAdapters[i], 0);
                ++i;
            }
            RegistryModel.this.fireModelChangeEvent(delta);
        }

        @Override
        public void removeExtensions(Extension[] extensionAdapters) {
            Extension[] extensionArray = extensionAdapters;
            int n = extensionAdapters.length;
            int n2 = 0;
            while (n2 < n) {
                Extension extension = extensionArray[n2];
                String id = extension.getExtensionPointUniqueIdentifier();
                ExtensionPoint extPoint = RegistryModel.this.extensionPoints.get(id);
                extPoint.getExtensions().remove(extension);
                ++n2;
            }
            ModelChangeDelta[] delta = new ModelChangeDelta[extensionAdapters.length];
            int i = 0;
            while (i < delta.length) {
                delta[i] = new ModelChangeDelta(extensionAdapters[i], 2);
                ++i;
            }
            RegistryModel.this.fireModelChangeEvent(delta);
            Extension[] extensionArray2 = extensionAdapters;
            int n3 = extensionAdapters.length;
            n = 0;
            while (n < n3) {
                Extension extension = extensionArray2[n];
                extension.setModel(null);
                ++n;
            }
        }

        @Override
        public void addExtensionPoints(ExtensionPoint[] extensionPointAdapters) {
            ExtensionPoint[] extensionPointArray = extensionPointAdapters;
            int n = extensionPointAdapters.length;
            int n2 = 0;
            while (n2 < n) {
                ExtensionPoint extPoint = extensionPointArray[n2];
                extPoint.setModel(RegistryModel.this);
                RegistryModel.this.extensionPoints.put(extPoint.getUniqueIdentifier(), extPoint);
                ++n2;
            }
            ModelChangeDelta[] delta = new ModelChangeDelta[extensionPointAdapters.length];
            int i = 0;
            while (i < delta.length) {
                delta[i] = new ModelChangeDelta(extensionPointAdapters[i], 0);
                ++i;
            }
            RegistryModel.this.fireModelChangeEvent(delta);
        }

        @Override
        public void removeExtensionPoints(ExtensionPoint[] extensionPointAdapters) {
            ExtensionPoint[] extensionPointArray = extensionPointAdapters;
            int n = extensionPointAdapters.length;
            int n2 = 0;
            while (n2 < n) {
                ExtensionPoint extPoint = extensionPointArray[n2];
                RegistryModel.this.extensionPoints.remove(extPoint.getUniqueIdentifier());
                ++n2;
            }
            ModelChangeDelta[] delta = new ModelChangeDelta[extensionPointAdapters.length];
            int i = 0;
            while (i < delta.length) {
                delta[i] = new ModelChangeDelta(extensionPointAdapters[i], 2);
                ++i;
            }
            RegistryModel.this.fireModelChangeEvent(delta);
            ExtensionPoint[] extensionPointArray2 = extensionPointAdapters;
            int n3 = extensionPointAdapters.length;
            n = 0;
            while (n < n3) {
                ExtensionPoint extPoint = extensionPointArray2[n];
                extPoint.setModel(null);
                ++n;
            }
        }
    };
    private final List<ModelChangeListener> listeners = new ArrayList<ModelChangeListener>();
    private final Map<Long, Bundle> bundles = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<Long, ServiceRegistration> services = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, ExtensionPoint> extensionPoints = Collections.synchronizedMap(new LinkedHashMap());
    private final Set<ServiceName> serviceNames = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<String, Set<Bundle>> fragments = Collections.synchronizedMap(new LinkedHashMap());
    protected RegistryBackend backend;

    public RegistryModel(RegistryBackend backend) {
        this.backend = backend;
        backend.setRegistryListener(this.backendListener);
    }

    protected void addFragment(Bundle fragment) {
        Set<Bundle> hostFragments = this.fragments.get(fragment.getFragmentHost());
        if (hostFragments == null) {
            hostFragments = Collections.synchronizedSet(new HashSet());
            this.fragments.put(fragment.getFragmentHost(), hostFragments);
        }
        if (!hostFragments.add(fragment)) {
            hostFragments.remove(fragment);
            hostFragments.add(fragment);
        }
    }

    protected void removeFragment(Bundle fragment) {
        Set<Bundle> hostFragments = this.fragments.get(fragment.getFragmentHost());
        if (hostFragments == null) {
            return;
        }
        hostFragments.remove(fragment);
    }

    public void connect(IProgressMonitor monitor, boolean forceInit) {
        this.backend.connect(monitor);
        if (forceInit) {
            this.initialize(monitor);
        }
    }

    public void initialize(IProgressMonitor monitor) {
        this.backend.initializeBundles(monitor);
        this.backend.initializeServices(monitor);
        this.backend.initializeExtensionPoints(monitor);
    }

    public void disconnect() {
        this.backend.disconnect();
    }

    public Bundle[] getBundles() {
        return this.bundles.values().toArray(new Bundle[this.bundles.size()]);
    }

    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints.values().toArray(new ExtensionPoint[this.extensionPoints.size()]);
    }

    public ServiceRegistration[] getServices() {
        return this.services.values().toArray(new ServiceRegistration[this.services.size()]);
    }

    public ServiceName[] getServiceNames() {
        return this.serviceNames.toArray(new ServiceName[this.serviceNames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration[] getServices(String[] classes) {
        ArrayList<ServiceRegistration> result = new ArrayList<ServiceRegistration>();
        Map<Long, ServiceRegistration> map = this.services;
        synchronized (map) {
            for (ServiceRegistration sr : this.services.values()) {
                if (!Arrays.equals(classes, sr.getName().getClasses())) continue;
                result.add(sr);
            }
        }
        return result.toArray(new ServiceRegistration[result.size()]);
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelChangeListener(ModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireModelChangeEvent(ModelChangeDelta[] delta) {
        for (ModelChangeListener listener : this.listeners) {
            listener.modelChanged(delta);
        }
    }

    public Bundle getBundle(Long id) {
        return this.bundles.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getBundle(String symbolicName, String versionRange) {
        Map<Long, Bundle> map = this.bundles;
        synchronized (map) {
            for (Bundle bundle : this.bundles.values()) {
                if (!bundle.getSymbolicName().equals(symbolicName) || !this.versionMatches(bundle.getVersion(), versionRange)) continue;
                return bundle;
            }
        }
        return null;
    }

    public ExtensionPoint getExtensionPoint(String extensionPointUniqueIdentifier) {
        return this.extensionPoints.get(extensionPointUniqueIdentifier);
    }

    public Bundle[] getFragments(Bundle bundle) {
        Set<Bundle> set = this.fragments.get(bundle.getSymbolicName());
        if (set == null) {
            return new Bundle[0];
        }
        ArrayList<Bundle> result = new ArrayList<Bundle>(set.size());
        Version hostVersion = Version.parseVersion((String)bundle.getVersion());
        for (Bundle fragment : set) {
            String fragmentVersionOrRange = fragment.getFragmentHostVersion();
            if (!this.versionMatches(hostVersion, fragmentVersionOrRange)) continue;
            result.add(fragment);
        }
        return result.toArray(new Bundle[result.size()]);
    }

    private boolean versionMatches(String hostVersion, String versionOrRange) {
        try {
            Version version = Version.parseVersion((String)hostVersion);
            return this.versionMatches(version, versionOrRange);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private boolean versionMatches(Version hostVersion, String versionOrRange) {
        if (versionOrRange == null) {
            return true;
        }
        try {
            Version version = Version.parseVersion((String)versionOrRange);
            if (hostVersion.compareTo(version) >= 0) {
                return true;
            }
        }
        catch (IllegalArgumentException version) {
            // empty catch block
        }
        try {
            VersionRange range = new VersionRange(versionOrRange);
            if (range.isIncluded(hostVersion)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }
}

