/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools.change;

import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.build.model.EE;
import aQute.bnd.build.model.clauses.VersionedClause;
import aQute.bnd.properties.Document;
import aQute.bnd.properties.IDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class ManifestToBndChange
extends Change {
    private IFile manifestFile;
    private IPluginModelBase model;
    private boolean keepRequireBundle;
    private boolean keepImportPackage;
    private boolean keepBREE;
    private boolean keepExportPackage;
    private IFile instructionFile;

    public ManifestToBndChange(IProject project, IFile manifest, IPluginModelBase model, IFile instructionsFile, boolean keepRequireBundle, boolean keepImportPackage, boolean keepBREE, boolean keepExportPackage) {
        this.keepRequireBundle = keepRequireBundle;
        this.keepImportPackage = keepImportPackage;
        this.keepBREE = keepBREE;
        this.keepExportPackage = keepExportPackage;
        this.manifestFile = manifest;
        this.model = model;
        this.instructionFile = instructionsFile;
    }

    public String getName() {
        return PDEUIMessages.ProjectUpdateChange_convert_manifest_to_bnd;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        BndEditModel editModel;
        Manifest manifest;
        List<VersionedClause> bundleClasspath = DependencyManager.getDependencies(List.of(this.model), (DependencyManager.Options[])new DependencyManager.Options[0]).stream().map(BundleDescription::getSymbolicName).map(bsn -> new VersionedClause(bsn)).toList();
        Document document = new Document("");
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream contents = this.manifestFile.getContents();){
                manifest = new Manifest(contents);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)"Reading file content failed", (Throwable)e));
        }
        try {
            editModel = new BndEditModel((IDocument)document);
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)"Reading document failed", (Throwable)e));
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
            String propertyName = entry.getKey().toString();
            if ("Bundle-ManifestVersion".equals(propertyName) || "Manifest-Version".equals(propertyName)) continue;
            String string = entry.getValue().toString();
            editModel.setGenericString(propertyName, BndEditModel.format((String)propertyName, (String)string));
        }
        String bree = (String)editModel.genericGet("Bundle-RequiredExecutionEnvironment");
        if (bree != null && !this.keepBREE) {
            try {
                editModel.setEE(EE.parse((String)bree));
                editModel.genericSet("Bundle-RequiredExecutionEnvironment", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.keepRequireBundle) {
            editModel.genericSet("Require-Bundle", null);
        }
        if (!this.keepImportPackage) {
            editModel.genericSet("Import-Package", null);
        }
        if (!this.keepExportPackage) {
            editModel.genericSet("Export-Package", null);
        }
        editModel.setBuildPath(bundleClasspath);
        editModel.setGenericString("-sources", "false");
        editModel.saveChangesTo((IDocument)document);
        this.instructionFile.create((InputStream)new ByteArrayInputStream(document.get().getBytes(StandardCharsets.UTF_8)), true, pm);
        return null;
    }

    public Object getModifiedElement() {
        return this.instructionFile;
    }
}

