/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.DRepresentationDescriptorQuery;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.IFileQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.api.views.common.item.AnalysisResourceItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.CommonSessionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.internal.views.common.FileSessionFinder;
import org.eclipse.sirius.ui.tools.internal.views.common.SessionLabelProvider;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonContentProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SiriusCommonLabelProvider
extends ColumnLabelProvider
implements ICommonLabelProvider,
IColorProvider {
    public static final ImageDescriptor SIRIUS_MODELING_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/ovr16/SessionDecorator.gif");
    public static final ImageDescriptor ERROR_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/error_co.png");
    public static final ImageDescriptor WARNING_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/warning_co.png");
    public static final ImageDescriptor INFO_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/info_co.png");
    private static final ImageDescriptor REPRESENTATION_DESCRIPTION_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/ovr16/description_decorator.png");
    private static final String DISABLED_REPRESENTATION_SUFFIX = "_disabled";
    private static final String DIRTY = "*";
    private ILabelProvider sessionLabelProvider = new SessionLabelProvider(ViewHelper.INSTANCE.createAdapterFactory());

    public Image getImage(Object element) {
        Image img;
        block15: {
            IFile file;
            img = null;
            if (!(element instanceof IResource) && this.sessionLabelProvider != null) {
                try {
                    Object wrapped;
                    img = this.sessionLabelProvider.getImage(element);
                    if (img == null) {
                        return img;
                    }
                    DRepresentationDescriptor descRep = this.getRepresentationDescriptor(element);
                    if (descRep != null && this.isInvalidRepresentation(descRep)) {
                        StringBuilder sB = new StringBuilder();
                        sB.append(descRep.getClass().getName());
                        RepresentationDescription description = descRep.getDescription();
                        if (description != null) {
                            sB.append('_');
                            sB.append(description.getClass().getName());
                        }
                        sB.append(DISABLED_REPRESENTATION_SUFFIX);
                        String key = sB.toString();
                        Image disabledImage = SiriusEditPlugin.getPlugin().getImageRegistry().get(key);
                        if (disabledImage == null) {
                            ImageDescriptor desc = ImageDescriptor.createFromImage((Image)img);
                            ImageDescriptor disabledDesc = ImageDescriptor.createWithFlags((ImageDescriptor)desc, (int)1);
                            SiriusEditPlugin.getPlugin().getImageRegistry().put(key, disabledDesc);
                            disabledImage = SiriusEditPlugin.getPlugin().getImageRegistry().get(key);
                        }
                        img = disabledImage;
                    }
                    if (!(element instanceof RepresentationDescriptionItem) || !((wrapped = ((RepresentationDescriptionItem)element).getWrappedObject()) instanceof RepresentationDescription)) break block15;
                    String key = ((RepresentationDescription)wrapped).eClass().getName() + "_decorated";
                    Image baseImg = img;
                    img = SiriusEditPlugin.getPlugin().getImageRegistry().get(key);
                    if (img == null) {
                        ImageDescriptor[] imageDescriptors = new ImageDescriptor[5];
                        imageDescriptors[3] = REPRESENTATION_DESCRIPTION_OVERLAY_DESC;
                        img = new DecorationOverlayIcon(baseImg, imageDescriptors).createImage();
                        SiriusEditPlugin.getPlugin().getImageRegistry().put(key, img);
                    }
                }
                catch (IllegalStateException | NullPointerException runtimeException) {}
            } else if (element instanceof IFile && new IFileQuery(file = (IFile)element).isResourceHandledByOpenedSession()) {
                String fileExtension = file.getFileExtension();
                int severity = -1;
                try {
                    severity = file.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
                }
                catch (CoreException coreException) {}
                String imgKey = fileExtension + "Decorated" + severity;
                img = SiriusEditPlugin.getPlugin().getImageRegistry().get(imgKey);
                if (img == null) {
                    ImageDescriptor imageDescriptor = null;
                    IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)file.getAdapter(IWorkbenchAdapter.class);
                    if (wbAdapter != null) {
                        imageDescriptor = wbAdapter.getImageDescriptor((Object)file);
                    }
                    if (imageDescriptor != null) {
                        img = this.addIFileDecorators(severity, imageDescriptor);
                        SiriusEditPlugin.getPlugin().getImageRegistry().put(imgKey, img);
                    }
                }
            }
        }
        return img;
    }

    private Image addIFileDecorators(int severity, ImageDescriptor imageDescriptor) {
        ImageDescriptor[] imageDescriptors = new ImageDescriptor[5];
        imageDescriptors[1] = SIRIUS_MODELING_OVERLAY_DESC;
        switch (severity) {
            case 2: {
                imageDescriptors[2] = ERROR_OVERLAY_DESC;
                break;
            }
            case 1: {
                imageDescriptors[2] = WARNING_OVERLAY_DESC;
                break;
            }
            case 0: {
                imageDescriptors[2] = INFO_OVERLAY_DESC;
                break;
            }
        }
        return new DecorationOverlayIcon(imageDescriptor.createImage(), imageDescriptors).createImage();
    }

    private boolean isInvalidRepresentation(Object element) {
        DRepresentationDescriptor representationDescriptor = this.getRepresentationDescriptor(element);
        return representationDescriptor != null && !new DRepresentationDescriptorQuery(representationDescriptor).isRepresentationValid();
    }

    private DRepresentationDescriptor getRepresentationDescriptor(Object element) {
        Object candidateElement = element;
        if (element instanceof ItemWrapper) {
            candidateElement = ((ItemWrapper)element).getWrappedObject();
        }
        DRepresentationDescriptor repDesc = null;
        if (candidateElement instanceof DRepresentation) {
            repDesc = new DRepresentationQuery((DRepresentation)candidateElement).getRepresentationDescriptor();
        } else if (candidateElement instanceof DRepresentationDescriptor) {
            repDesc = (DRepresentationDescriptor)candidateElement;
        }
        return repDesc;
    }

    public String getText(Object element) {
        Object text = null;
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            Option modelingProject = ModelingProject.asModelingProject((IProject)project);
            if (modelingProject.some() && SiriusCommonLabelProvider.shoudlShowSessionDirtyStatus(((ModelingProject)modelingProject.get()).getSession())) {
                text = DIRTY + project.getName();
            }
        } else if (element instanceof IFile) {
            text = this.doGetFileText((IFile)element);
        } else if (!(element instanceof IResource) && this.sessionLabelProvider != null) {
            try {
                text = this.sessionLabelProvider.getText(element);
            }
            catch (IllegalStateException | NullPointerException runtimeException) {}
        }
        return text;
    }

    private String doGetFileText(IFile file) {
        Object text = null;
        IProject parentProject = file.getProject();
        if (parentProject != null) {
            if ("aird".equals(file.getFileExtension())) {
                List<Session> openedSessions;
                if (!ModelingProject.hasModelingProjectNature((IProject)parentProject) && (openedSessions = this.getOpenSessions(file)).size() == 1) {
                    boolean dirty = SiriusCommonLabelProvider.shoudlShowSessionDirtyStatus(openedSessions.iterator().next());
                    text = dirty ? DIRTY + file.getName() : file.getName();
                }
            } else {
                Iterable transientSessions = Iterables.filter(this.getOpenSessions(file), (Predicate)new SiriusCommonContentProvider.TransientSessionPredicate());
                if (Iterables.size((Iterable)transientSessions) == 1) {
                    boolean dirty = SiriusCommonLabelProvider.shoudlShowSessionDirtyStatus((Session)transientSessions.iterator().next());
                    text = dirty ? DIRTY + file.getName() : file.getName();
                }
            }
        }
        return text;
    }

    private List<Session> getOpenSessions(IFile file) {
        return Lists.newArrayList((Iterable)Iterables.filter(FileSessionFinder.getSelectedSessions(Collections.singletonList(file)), (Predicate)new Predicate<Session>(){

            public boolean apply(Session input) {
                return input.isOpen();
            }
        }));
    }

    public static boolean shoudlShowSessionDirtyStatus(Session session) {
        if (SessionUIManager.INSTANCE != null) {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
            if (session != null && uiSession != null && session.isOpen() && uiSession.isOpen()) {
                boolean shouldBeSavedWithoutEditor;
                IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
                boolean bl = shouldBeSavedWithoutEditor = preferenceStore != null && preferenceStore.getBoolean(SiriusUIPreferencesKeys.PREF_SAVE_WHEN_NO_EDITOR.name());
                if (SessionStatus.DIRTY == session.getStatus() && (!shouldBeSavedWithoutEditor || uiSession.getSiriusEditors().isEmpty())) {
                    return true;
                }
            }
        }
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.sessionLabelProvider != null) {
            this.sessionLabelProvider.addListener(listener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.sessionLabelProvider != null) {
            this.sessionLabelProvider.removeListener(listener);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public Color getForeground(Object element) {
        Color foreground = null;
        try {
            if (element instanceof ItemWrapper) {
                if (!this.isInModelingProject((ItemWrapper)element) || !(element instanceof AnalysisResourceItem)) {
                    foreground = VisualBindingManager.getDefault().getColorFromName("dark_gray");
                }
            } else if (element instanceof DRepresentationDescriptor) {
                foreground = VisualBindingManager.getDefault().getColorFromName("dark_blue");
            }
            if (this.isInvalidRepresentation(element)) {
                foreground = VisualBindingManager.getDefault().getColorFromName("light_gray");
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {}
        return foreground;
    }

    private boolean isInModelingProject(CommonSessionItem object) {
        IResource parentResource = null;
        CommonSessionItem wrapper = object;
        while (wrapper != null && wrapper.getParent() != null && parentResource == null) {
            Object parent = wrapper.getParent();
            if (parent instanceof IResource) {
                parentResource = (IResource)parent;
                continue;
            }
            if (!(parent instanceof CommonSessionItem)) break;
            wrapper = (CommonSessionItem)wrapper.getParent();
        }
        if (parentResource != null) {
            IProject project = parentResource.getProject();
            return project != null ? ModelingProject.hasModelingProjectNature((IProject)project) : false;
        }
        return false;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public void dispose() {
        if (this.sessionLabelProvider != null) {
            this.sessionLabelProvider.dispose();
            this.sessionLabelProvider = null;
        }
    }

    public void saveState(IMemento aMemento) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }
}

