/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.streams;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.protocol.Protocol;

public class StreamsDataReceiver
extends PlatformObject {
    private final Writer writer;
    private final List<String> streamTypeIds;
    private final ListenerList listeners;

    public StreamsDataReceiver(Writer writer, String[] streamTypeIds) {
        Assert.isNotNull((Object)writer);
        this.writer = writer;
        this.streamTypeIds = streamTypeIds != null ? Arrays.asList(streamTypeIds) : null;
        this.listeners = new ListenerList();
    }

    public final void addListener(Listener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.add((Object)listener);
    }

    public final void removeListener(Listener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.remove((Object)listener);
    }

    public final void notifyListener(final String data) {
        Assert.isNotNull((Object)data);
        final Object[] listeners = this.listeners.getListeners();
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    Assert.isTrue((boolean)(listener instanceof Listener));
                    ((Listener)listener).dataReceived(data);
                    ++n2;
                }
            }
        });
    }

    public void dispose() {
        this.listeners.clear();
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final Writer getWriter() {
        return this.writer;
    }

    public final boolean isApplicable(String streamTypeId) {
        Assert.isNotNull((Object)streamTypeId);
        return this.streamTypeIds == null || this.streamTypeIds.contains(streamTypeId);
    }

    public static interface Listener {
        public void dataReceived(String var1);
    }
}

