/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.controls.ConfigurationPanelControl;
import org.eclipse.tm.terminal.view.ui.help.IContextHelpIds;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.interfaces.ILauncherDelegate;
import org.eclipse.tm.terminal.view.ui.internal.dialogs.ErrorSettingsPanel;
import org.eclipse.tm.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.tm.terminal.view.ui.launcher.LauncherDelegateManager;
import org.eclipse.tm.terminal.view.ui.local.showin.ExternalExecutablesManager;
import org.eclipse.tm.terminal.view.ui.nls.Messages;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public class LaunchTerminalSettingsDialog
extends TrayDialog {
    private static final String NO_CONNECTORS_LABEL = "none";
    private String contextHelpId = null;
    private ISelection selection = null;
    Combo terminals;
    SettingsPanelControl settings;
    final Map<String, ILauncherDelegate> label2delegate = new HashMap<String, ILauncherDelegate>();
    final Map<String, Map<String, Object>> label2properties = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> data = null;
    private IDialogSettings dialogSettings;
    private String singleDelegateLabel = null;
    private long start = 0L;

    public LaunchTerminalSettingsDialog(Shell shell) {
        this(shell, 0L);
    }

    public LaunchTerminalSettingsDialog(Shell shell, long start) {
        super(shell);
        this.start = start;
        this.initializeDialogSettings();
        this.contextHelpId = IContextHelpIds.LAUNCH_TERMINAL_SETTINGS_DIALOG;
        this.setHelpAvailable(true);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public boolean close() {
        this.dispose();
        return super.close();
    }

    protected void dispose() {
        if (this.settings != null) {
            this.settings.dispose();
            this.settings = null;
        }
        this.dialogSettings = null;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        this.validate();
        return composite;
    }

    protected final Control createDialogArea(Composite parent) {
        Control control;
        if (this.contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.contextHelpId);
        }
        if ((control = super.createDialogArea(parent)) instanceof Composite) {
            ScrolledComposite sc = new ScrolledComposite((Composite)control, 512);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            sc.setLayout((Layout)layout);
            sc.setLayoutData((Object)new GridData(1808));
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            Composite composite = new Composite((Composite)sc, 0);
            composite.setLayout((Layout)new GridLayout());
            this.createDialogAreaContent(composite);
            sc.setContent((Control)composite);
            sc.setMinSize(composite.computeSize(-1, -1));
            control = sc;
        }
        return control;
    }

    public void setDialogTitle(String title) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().setText(title);
        }
    }

    protected void createDialogAreaContent(Composite parent) {
        String[] stringArray;
        String terminalLabel;
        Assert.isNotNull((Object)parent);
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
            UIPlugin.getTraceHandler().trace("Creating dialog area after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
        }
        this.setDialogTitle(Messages.LaunchTerminalSettingsDialog_title);
        List<String> items = this.getTerminals();
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (items.size() != 1) {
            Label label = new Label(panel, 256);
            label.setText(Messages.LaunchTerminalSettingsDialog_combo_label);
            this.terminals = new Combo(panel, 8);
            this.terminals.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.terminals.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IConfigurationPanel oldPanel = LaunchTerminalSettingsDialog.this.settings.getActiveConfigurationPanel();
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    if (oldPanel != null) {
                        oldPanel.extractData(data);
                    }
                    data.remove("ip.port");
                    data.remove("timeout");
                    data.remove("tm.terminal.connector.id");
                    data.remove("encoding");
                    LaunchTerminalSettingsDialog.this.settings.showConfigurationPanel(LaunchTerminalSettingsDialog.this.terminals.getText());
                    IConfigurationPanel newPanel = LaunchTerminalSettingsDialog.this.settings.getActiveConfigurationPanel();
                    if (newPanel != null) {
                        newPanel.setupData(data);
                    }
                    LaunchTerminalSettingsDialog.this.getShell().pack();
                    LaunchTerminalSettingsDialog.this.validate();
                }
            });
            this.fillCombo(this.terminals, items);
        } else {
            Assert.isTrue((items.size() == 1 ? 1 : 0) != 0);
            this.singleDelegateLabel = items.get(0);
        }
        this.settings = new SettingsPanelControl();
        String string = terminalLabel = this.terminals != null ? this.terminals.getItem(0) : this.singleDelegateLabel;
        if (terminalLabel != null) {
            ILauncherDelegate delegate = this.label2delegate.get(terminalLabel);
            Assert.isNotNull((Object)delegate);
            IConfigurationPanel configPanel = delegate.getPanel(this.settings);
            if (configPanel != null) {
                this.settings.addConfigurationPanel(terminalLabel, configPanel);
                configPanel.setSelection(this.getSelection());
            }
        }
        if (this.terminals != null) {
            stringArray = this.terminals.getItems();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.singleDelegateLabel;
        }
        this.settings.setupPanel(panel, stringArray);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.settings.getPanel().setLayoutData((Object)layoutData);
        if (this.terminals != null) {
            this.terminals.select(0);
            this.settings.showConfigurationPanel(this.terminals.getText());
            this.terminals.setEnabled(this.terminals.getItemCount() > 1);
        } else {
            this.settings.showConfigurationPanel(this.singleDelegateLabel);
        }
        this.restoreWidgetValues();
        LaunchTerminalSettingsDialog.applyDialogFont((Control)panel);
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
            UIPlugin.getTraceHandler().trace("Created dialog area after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
        }
    }

    protected void fillCombo(Combo combo, List<String> items) {
        Assert.isNotNull((Object)combo);
        Assert.isNotNull(items);
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
            UIPlugin.getTraceHandler().trace("Filling combo after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
        }
        Collections.sort(items);
        combo.setItems(items.toArray(new String[items.size()]));
    }

    protected List<String> getTerminals() {
        List<Map<String, String>> l;
        ArrayList<String> items = new ArrayList<String>();
        ILauncherDelegate localLauncher = null;
        if (this.selection == null || this.selection.isEmpty()) {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Getting launcher delegates after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            delegates = LauncherDelegateManager.getInstance().getLauncherDelegates(false);
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Got launcher delegates after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            var7_4 = delegates;
            var6_5 = delegates.length;
            var5_7 = 0;
            while (var5_7 < var6_5) {
                delegate = var7_4[var5_7];
                if (!delegate.isHidden() && !this.isFiltered(this.selection, delegate)) {
                    label = delegate.getLabel();
                    if (label == null || "".equals(label.trim()) || this.label2delegate.containsKey(label)) {
                        label = delegate.getId();
                    }
                    this.label2delegate.put(label, delegate);
                    items.add(label);
                    if ("org.eclipse.tm.terminal.connector.local.launcher.local".equals(delegate.getId())) {
                        localLauncher = delegate;
                    }
                }
                ++var5_7;
            }
        } else {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Getting applicable launcher delegates after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            delegates = LauncherDelegateManager.getInstance().getApplicableLauncherDelegates(this.selection);
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Got applicable launcher delegates after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            var7_4 = delegates;
            var6_5 = delegates.length;
            var5_7 = 0;
            while (var5_7 < var6_5) {
                delegate = var7_4[var5_7];
                if (!delegate.isHidden() && !this.isFiltered(this.selection, delegate)) {
                    label = delegate.getLabel();
                    if (label == null || "".equals(label.trim())) {
                        label = delegate.getId();
                    }
                    this.label2delegate.put(label, delegate);
                    items.add(label);
                    if ("org.eclipse.tm.terminal.connector.local.launcher.local".equals(delegate.getId())) {
                        localLauncher = delegate;
                    }
                }
                ++var5_7;
            }
        }
        if (localLauncher != null && (l = ExternalExecutablesManager.load()) != null && !l.isEmpty()) {
            for (Map<String, String> executableData : l) {
                ISelection selection;
                boolean translate;
                String name = executableData.get("Name");
                String path = executableData.get("Path");
                String args = executableData.get("Args");
                String strTranslate = executableData.get("Translate");
                boolean bl = translate = strTranslate != null ? Boolean.parseBoolean(strTranslate) : false;
                if (name == null || "".equals(name) || path == null || "".equals(path)) continue;
                ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
                ISelection iSelection = selection = service != null ? service.getSelection() : null;
                if (selection != null && selection.isEmpty()) {
                    selection = null;
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("process.path", path);
                properties.put("process.args", args);
                properties.put("translateBackslashesOnPaste", translate);
                this.label2delegate.put(name, localLauncher);
                this.label2properties.put(name, properties);
                items.add(name);
            }
        }
        if (items.isEmpty()) {
            AbstractLauncherDelegate noDelegate = new AbstractLauncherDelegate(){

                @Override
                public boolean needsUserConfiguration() {
                    return false;
                }

                @Override
                public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
                    return new ErrorSettingsPanel(container, Messages.LaunchTerminalSettingsDialog_error_no_terminal_connectors);
                }

                @Override
                public void execute(Map<String, Object> properties, ITerminalService.Done done) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
                    throw new UnsupportedOperationException();
                }
            };
            this.label2delegate.put(NO_CONNECTORS_LABEL, noDelegate);
            items.add(NO_CONNECTORS_LABEL);
        }
        return items;
    }

    protected boolean isFiltered(ISelection selection, ILauncherDelegate delegate) {
        return false;
    }

    public void validate() {
        IConfigurationPanel panel = this.settings.getActiveConfigurationPanel();
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(panel.isValid());
        }
    }

    public void setMessage(String message, int messageType) {
        if (this.settings != null) {
            this.settings.setMessage(message, messageType);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.terminals != null) {
                settings.put("terminalLabel", this.terminals.getText());
            }
            this.settings.saveWidgetValues(settings, null);
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            int index;
            String terminalLabel = settings.get("terminalLabel");
            int n = index = terminalLabel != null && this.terminals != null ? Arrays.asList(this.terminals.getItems()).indexOf(terminalLabel) : -1;
            if (index != -1) {
                this.terminals.select(index);
                this.settings.showConfigurationPanel(this.terminals.getText());
            }
            this.settings.restoreWidgetValues(settings, null);
        }
    }

    protected void okPressed() {
        String delegateId;
        IConfigurationPanel panel = this.settings.getActiveConfigurationPanel();
        Assert.isNotNull((Object)panel);
        if (!panel.isValid()) {
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setText(Messages.LaunchTerminalSettingsDialog_error_title);
            mb.setMessage(NLS.bind((String)Messages.LaunchTerminalSettingsDialog_error_invalidSettings, (Object)(panel.getMessage() != null ? panel.getMessage() : Messages.LaunchTerminalSettingsDialog_error_unknownReason)));
            mb.open();
            return;
        }
        this.data = new HashMap<String, Object>();
        String terminalLabel = this.terminals != null ? this.terminals.getText() : this.singleDelegateLabel;
        String string = delegateId = terminalLabel != null ? this.label2delegate.get(terminalLabel).getId() : null;
        if (delegateId != null) {
            this.data.put("delegateId", delegateId);
        }
        this.data.put("selection", this.selection);
        if (this.label2properties.containsKey(terminalLabel)) {
            this.data.putAll(this.label2properties.get(terminalLabel));
        }
        panel.extractData(this.data);
        this.saveWidgetValues();
        super.okPressed();
    }

    public Map<String, Object> getSettings() {
        return this.data;
    }

    protected void initializeDialogSettings() {
        IDialogSettings settings = UIPlugin.getDefault().getDialogSettings();
        Assert.isNotNull((Object)settings);
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getSimpleName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getSimpleName());
        }
        this.setDialogSettings(section);
    }

    public IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.initializeDialogSettings();
        }
        return this.dialogSettings;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    protected class SettingsPanelControl
    extends ConfigurationPanelControl {
        public SettingsPanelControl() {
            this.setPanelIsGroup(true);
        }

        @Override
        public String getGroupLabel() {
            return Messages.LaunchTerminalSettingsDialog_group_label;
        }

        @Override
        public void showConfigurationPanel(String key) {
            IConfigurationPanel configPanel = this.getConfigurationPanel(key);
            if (this.isEmptyConfigurationPanel(configPanel)) {
                ILauncherDelegate delegate = LaunchTerminalSettingsDialog.this.label2delegate.get(key);
                Assert.isNotNull((Object)delegate);
                configPanel = delegate.getPanel(this);
                if (configPanel != null) {
                    IDialogSettings configPanelSettings;
                    LaunchTerminalSettingsDialog.this.settings.addConfigurationPanel(key, configPanel);
                    configPanel.setSelection(LaunchTerminalSettingsDialog.this.getSelection());
                    configPanel.setupPanel(this.getPanel());
                    IDialogSettings dialogSettings = LaunchTerminalSettingsDialog.this.settings.getDialogSettings(LaunchTerminalSettingsDialog.this.getDialogSettings());
                    IDialogSettings iDialogSettings = configPanelSettings = dialogSettings != null ? dialogSettings.getSection(key) : null;
                    if (configPanelSettings != null) {
                        configPanel.doRestoreWidgetValues(configPanelSettings, null);
                    }
                }
            }
            super.showConfigurationPanel(key);
        }

        @Override
        public void validate() {
            LaunchTerminalSettingsDialog.this.validate();
        }
    }
}

